/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ReachableFileUtil;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StaticTableOperations;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class TestReachableFileUtil {
    private static final HadoopTables TABLES = new HadoopTables(new Configuration());
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"c1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"c2", (Type)Types.StringType.get())});
    private static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("c1").build();
    private static final DataFile FILE_A = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-a.parquet").withFileSizeInBytes(10L).withRecordCount(1L).build();
    private static final DataFile FILE_B = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-b.parquet").withFileSizeInBytes(10L).withRecordCount(1L).build();
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private Table table;

    @Before
    public void setupTableLocation() throws Exception {
        File tableDir = this.temp.newFolder();
        String tableLocation = tableDir.toURI().toString();
        this.table = TABLES.create(SCHEMA, SPEC, (Map)Maps.newHashMap(), tableLocation);
    }

    @Test
    public void testManifestListLocations() {
        this.table.newAppend().appendFile(FILE_A).commit();
        this.table.newAppend().appendFile(FILE_B).commit();
        List manifestListPaths = ReachableFileUtil.manifestListLocations((Table)this.table);
        Assert.assertEquals((long)manifestListPaths.size(), (long)2L);
    }

    @Test
    public void testMetadataFileLocations() {
        this.table.updateProperties().set("write.metadata.previous-versions-max", "1").commit();
        this.table.newAppend().appendFile(FILE_A).commit();
        this.table.newAppend().appendFile(FILE_B).commit();
        Set metadataFileLocations = ReachableFileUtil.metadataFileLocations((Table)this.table, (boolean)true);
        Assert.assertEquals((long)metadataFileLocations.size(), (long)4L);
        metadataFileLocations = ReachableFileUtil.metadataFileLocations((Table)this.table, (boolean)false);
        Assert.assertEquals((long)metadataFileLocations.size(), (long)2L);
    }

    @Test
    public void testMetadataFileLocationsWithMissingFiles() {
        this.table.updateProperties().set("write.metadata.previous-versions-max", "1").commit();
        this.table.newAppend().appendFile(FILE_A).commit();
        TableOperations operations = ((HasTableOperations)this.table).operations();
        String location = operations.current().metadataFileLocation();
        this.table.newAppend().appendFile(FILE_B).commit();
        this.table.io().deleteFile(location);
        Set metadataFileLocations = ReachableFileUtil.metadataFileLocations((Table)this.table, (boolean)true);
        Assert.assertEquals((long)metadataFileLocations.size(), (long)2L);
    }

    @Test
    public void testVersionHintWithStaticTables() {
        TableOperations ops = ((HasTableOperations)this.table).operations();
        TableMetadata metadata = ops.current();
        String metadataFileLocation = metadata.metadataFileLocation();
        StaticTableOperations staticOps = new StaticTableOperations(metadataFileLocation, this.table.io());
        BaseTable staticTable = new BaseTable((TableOperations)staticOps, metadataFileLocation);
        String reportedVersionHintLocation = ReachableFileUtil.versionHintLocation((Table)staticTable);
        String expectedVersionHintLocation = ops.metadataFileLocation("version-hint.text");
        Assert.assertEquals((Object)expectedVersionHintLocation, (Object)reportedVersionHintLocation);
    }

    @Test
    public void testVersionHintWithBucketNameAsLocation() {
        Table mockTable = (Table)Mockito.mock(Table.class);
        Mockito.when((Object)mockTable.location()).thenReturn((Object)"s3://bucket1");
        String reportedVersionHintLocation = ReachableFileUtil.versionHintLocation((Table)mockTable);
        String expectedVersionHintLocation = "s3://bucket1/metadata/version-hint.text";
        Assert.assertEquals((Object)expectedVersionHintLocation, (Object)reportedVersionHintLocation);
    }
}

