/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.ParallelIterable;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.Test;

public class TestParallelIterable {
    @Test
    public void closeParallelIteratorWithoutCompleteIteration() throws IOException, IllegalAccessException, NoSuchFieldException {
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Iterable transform = Iterables.transform((Iterable)Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5}), item -> new CloseableIterable<Integer>(){

            public void close() {
            }

            public CloseableIterator<Integer> iterator() {
                return CloseableIterator.withClose(Collections.singletonList(item).iterator());
            }
        });
        ParallelIterable parallelIterable = new ParallelIterable(transform, executor);
        CloseableIterator iterator = parallelIterable.iterator();
        Field queueField = iterator.getClass().getDeclaredField("queue");
        queueField.setAccessible(true);
        ConcurrentLinkedQueue queue = (ConcurrentLinkedQueue)queueField.get(iterator);
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        Assertions.assertThat((Integer)((Integer)iterator.next())).isNotNull();
        Awaitility.await((String)"Queue is populated").atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> this.queueHasElements((CloseableIterator<Integer>)iterator, queue));
        iterator.close();
        Awaitility.await((String)"Queue is cleared").atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertThat((Collection)queue).isEmpty());
    }

    private void queueHasElements(CloseableIterator<Integer> iterator, Queue queue) {
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        Assertions.assertThat((Integer)((Integer)iterator.next())).isNotNull();
        Assertions.assertThat((Collection)queue).isNotEmpty();
    }
}

