/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.LockManager;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.LockManagers;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestLockManagers {
    @Test
    public void testLoadDefaultLockManager() {
        Assertions.assertThat((Object)LockManagers.defaultLockManager()).isInstanceOf(LockManagers.InMemoryLockManager.class);
    }

    @Test
    public void testLoadCustomLockManager() {
        HashMap properties = Maps.newHashMap();
        properties.put("lock-impl", CustomLockManager.class.getName());
        Assertions.assertThat((Object)LockManagers.from((Map)properties)).isInstanceOf(CustomLockManager.class);
    }

    static class CustomLockManager
    implements LockManager {
        CustomLockManager() {
        }

        public boolean acquire(String entityId, String ownerId) {
            return false;
        }

        public boolean release(String entityId, String ownerId) {
            return false;
        }

        public void close() throws Exception {
        }

        public void initialize(Map<String, String> properties) {
        }
    }
}

