/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import org.apache.iceberg.util.LocationUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestLocationUtil {
    @Test
    public void testStripTrailingSlash() {
        String pathWithoutTrailingSlash = "s3://bucket/db/tbl";
        Assert.assertEquals((String)"Should have no trailing slashes", (Object)pathWithoutTrailingSlash, (Object)LocationUtil.stripTrailingSlash((String)pathWithoutTrailingSlash));
        String pathWithSingleTrailingSlash = pathWithoutTrailingSlash + "/";
        Assert.assertEquals((String)"Should have no trailing slashes", (Object)pathWithoutTrailingSlash, (Object)LocationUtil.stripTrailingSlash((String)pathWithSingleTrailingSlash));
        String pathWithMultipleTrailingSlash = pathWithoutTrailingSlash + "////";
        Assert.assertEquals((String)"Should have no trailing slashes", (Object)pathWithoutTrailingSlash, (Object)LocationUtil.stripTrailingSlash((String)pathWithMultipleTrailingSlash));
        String pathWithOnlySlash = "////";
        Assert.assertEquals((String)"Should have no trailing slashes", (Object)"", (Object)LocationUtil.stripTrailingSlash((String)pathWithOnlySlash));
    }

    @Test
    public void testStripTrailingSlashWithInvalidPath() {
        String[] invalidPaths;
        for (String invalidPath : invalidPaths = new String[]{null, ""}) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LocationUtil.stripTrailingSlash((String)invalidPath)).isInstanceOf(IllegalArgumentException.class)).hasMessage("path must not be null or empty");
        }
    }
}

