/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.util.JsonUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestJsonUtil {
    @Test
    public void get() throws JsonProcessingException {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.get((String)"x", (JsonNode)JsonUtil.mapper().readTree("{}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing field: x");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.get((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": null}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing field: x");
        Assertions.assertThat((String)JsonUtil.get((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": \"23\"}")).asText()).isEqualTo("23");
    }

    @Test
    public void getInt() throws JsonProcessingException {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getInt((String)"x", (JsonNode)JsonUtil.mapper().readTree("{}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing int: x");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getInt((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": null}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to an integer value: x: null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getInt((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": \"23\"}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to an integer value: x: \"23\"");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getInt((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": 23.0}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to an integer value: x: 23.0");
        Assertions.assertThat((int)JsonUtil.getInt((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": 23}"))).isEqualTo(23);
    }

    @Test
    public void getIntOrNull() throws JsonProcessingException {
        Assertions.assertThat((Integer)JsonUtil.getIntOrNull((String)"x", (JsonNode)JsonUtil.mapper().readTree("{}"))).isNull();
        Assertions.assertThat((Integer)JsonUtil.getIntOrNull((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": 23}"))).isEqualTo(23);
        Assertions.assertThat((Integer)JsonUtil.getIntOrNull((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": null}"))).isNull();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getIntOrNull((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": \"23\"}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to an integer value: x: \"23\"");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getIntOrNull((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": 23.0}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to an integer value: x: 23.0");
    }

    @Test
    public void getLong() throws JsonProcessingException {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getLong((String)"x", (JsonNode)JsonUtil.mapper().readTree("{}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing long: x");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getLong((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": null}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to a long value: x: null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getLong((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": \"23\"}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to a long value: x: \"23\"");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getLong((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": 23.0}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to a long value: x: 23.0");
        Assertions.assertThat((long)JsonUtil.getLong((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": 23}"))).isEqualTo(23L);
    }

    @Test
    public void getLongOrNull() throws JsonProcessingException {
        Assertions.assertThat((Long)JsonUtil.getLongOrNull((String)"x", (JsonNode)JsonUtil.mapper().readTree("{}"))).isNull();
        Assertions.assertThat((Long)JsonUtil.getLongOrNull((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": 23}"))).isEqualTo(23L);
        Assertions.assertThat((Long)JsonUtil.getLongOrNull((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": null}"))).isNull();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getLongOrNull((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": \"23\"}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to a long value: x: \"23\"");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getLongOrNull((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": 23.0}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to a long value: x: 23.0");
    }

    @Test
    public void getString() throws JsonProcessingException {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getString((String)"x", (JsonNode)JsonUtil.mapper().readTree("{}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing string: x");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getString((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": null}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to a string value: x: null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getString((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": 23}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to a string value: x: 23");
        Assertions.assertThat((String)JsonUtil.getString((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": \"23\"}"))).isEqualTo("23");
    }

    @Test
    public void getStringOrNull() throws JsonProcessingException {
        Assertions.assertThat((String)JsonUtil.getStringOrNull((String)"x", (JsonNode)JsonUtil.mapper().readTree("{}"))).isNull();
        Assertions.assertThat((String)JsonUtil.getStringOrNull((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": \"23\"}"))).isEqualTo("23");
        Assertions.assertThat((String)JsonUtil.getStringOrNull((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": null}"))).isNull();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getStringOrNull((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": 23}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to a string value: x: 23");
    }

    @Test
    public void getBool() throws JsonProcessingException {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getBool((String)"x", (JsonNode)JsonUtil.mapper().readTree("{}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing boolean: x");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getBool((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": null}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to a boolean value: x: null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getBool((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": \"23\"}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to a boolean value: x: \"23\"");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getBool((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": \"true\"}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to a boolean value: x: \"true\"");
        Assertions.assertThat((boolean)JsonUtil.getBool((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": true}"))).isTrue();
        Assertions.assertThat((boolean)JsonUtil.getBool((String)"x", (JsonNode)JsonUtil.mapper().readTree("{\"x\": false}"))).isFalse();
    }

    @Test
    public void getIntegerList() throws JsonProcessingException {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getIntegerList((String)"items", (JsonNode)JsonUtil.mapper().readTree("{}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing list: items");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getIntegerList((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": null}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse from non-array value: items: null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getIntegerList((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": [13, \"23\"]}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse integer from non-int value in items: \"23\"");
        List<Integer> items = Arrays.asList(23, 45);
        Assertions.assertThat((List)JsonUtil.getIntegerList((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": [23, 45]}"))).isEqualTo(items);
        String json = JsonUtil.generate(gen -> {
            gen.writeStartObject();
            JsonUtil.writeIntegerArray((String)"items", (Iterable)items, (JsonGenerator)gen);
            gen.writeEndObject();
        }, (boolean)false);
        Assertions.assertThat((List)JsonUtil.getIntegerList((String)"items", (JsonNode)JsonUtil.mapper().readTree(json))).isEqualTo(items);
    }

    @Test
    public void getIntegerSet() throws JsonProcessingException {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getIntegerSet((String)"items", (JsonNode)JsonUtil.mapper().readTree("{}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing set: items");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getIntegerSet((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": null}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse from non-array value: items: null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getIntegerSet((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": [13, \"23\"]}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse integer from non-int value in items: \"23\"");
        Assertions.assertThat((Collection)JsonUtil.getIntegerSet((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": [23, 45]}"))).containsExactlyElementsOf(Arrays.asList(23, 45));
    }

    @Test
    public void getIntegerSetOrNull() throws JsonProcessingException {
        Assertions.assertThat((Collection)JsonUtil.getIntegerSetOrNull((String)"items", (JsonNode)JsonUtil.mapper().readTree("{}"))).isNull();
        Assertions.assertThat((Collection)JsonUtil.getIntegerSetOrNull((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": null}"))).isNull();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getIntegerSetOrNull((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": [13, \"23\"]}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse integer from non-int value in items: \"23\"");
        Assertions.assertThat((Collection)JsonUtil.getIntegerSetOrNull((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": [23, 45]}"))).containsExactlyElementsOf(Arrays.asList(23, 45));
    }

    @Test
    public void getLongList() throws JsonProcessingException {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getLongList((String)"items", (JsonNode)JsonUtil.mapper().readTree("{}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing list: items");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getLongList((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": null}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse from non-array value: items: null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getLongList((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": [13, \"23\"]}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse long from non-long value in items: \"23\"");
        List<Long> items = Arrays.asList(23L, 45L);
        Assertions.assertThat((List)JsonUtil.getLongList((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": [23, 45]}"))).isEqualTo(items);
        String json = JsonUtil.generate(gen -> {
            gen.writeStartObject();
            JsonUtil.writeLongArray((String)"items", (Iterable)items, (JsonGenerator)gen);
            gen.writeEndObject();
        }, (boolean)false);
        Assertions.assertThat((List)JsonUtil.getLongList((String)"items", (JsonNode)JsonUtil.mapper().readTree(json))).isEqualTo(items);
    }

    @Test
    public void getLongSet() throws JsonProcessingException {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getLongSet((String)"items", (JsonNode)JsonUtil.mapper().readTree("{}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing set: items");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getLongSet((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": null}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse from non-array value: items: null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getLongSet((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": [13, \"23\"]}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse long from non-long value in items: \"23\"");
        Assertions.assertThat((Collection)JsonUtil.getLongSet((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": [23, 45]}"))).containsExactlyElementsOf(Arrays.asList(23L, 45L));
    }

    @Test
    public void getLongSetOrNull() throws JsonProcessingException {
        Assertions.assertThat((Collection)JsonUtil.getLongSetOrNull((String)"items", (JsonNode)JsonUtil.mapper().readTree("{}"))).isNull();
        Assertions.assertThat((Collection)JsonUtil.getLongSetOrNull((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": null}"))).isNull();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getLongSetOrNull((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": [13, \"23\"]}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse long from non-long value in items: \"23\"");
        Assertions.assertThat((Collection)JsonUtil.getLongSetOrNull((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": [23, 45]}"))).containsExactlyElementsOf(Arrays.asList(23L, 45L));
    }

    @Test
    public void getStringList() throws JsonProcessingException {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getStringList((String)"items", (JsonNode)JsonUtil.mapper().readTree("{}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing list: items");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getStringList((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": null}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse from non-array value: items: null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getStringList((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": [\"23\", 45]}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse string from non-text value in items: 45");
        List<String> items = Arrays.asList("23", "45");
        Assertions.assertThat((List)JsonUtil.getStringList((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": [\"23\", \"45\"]}"))).containsExactlyElementsOf(items);
        String json = JsonUtil.generate(gen -> {
            gen.writeStartObject();
            JsonUtil.writeStringArray((String)"items", (Iterable)items, (JsonGenerator)gen);
            gen.writeEndObject();
        }, (boolean)false);
        Assertions.assertThat((List)JsonUtil.getStringList((String)"items", (JsonNode)JsonUtil.mapper().readTree(json))).isEqualTo(items);
    }

    @Test
    public void getStringListOrNull() throws JsonProcessingException {
        Assertions.assertThat((List)JsonUtil.getStringListOrNull((String)"items", (JsonNode)JsonUtil.mapper().readTree("{}"))).isNull();
        Assertions.assertThat((List)JsonUtil.getStringListOrNull((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": null}"))).isNull();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getStringListOrNull((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": [\"23\", 45]}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse string from non-text value in items: 45");
        Assertions.assertThat((List)JsonUtil.getStringListOrNull((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": [\"23\", \"45\"]}"))).containsExactlyElementsOf(Arrays.asList("23", "45"));
    }

    @Test
    public void getStringSet() throws JsonProcessingException {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getStringSet((String)"items", (JsonNode)JsonUtil.mapper().readTree("{}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing set: items");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getStringSet((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": null}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse from non-array value: items: null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getStringSet((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": [\"23\", 45]}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse string from non-text value in items: 45");
        Assertions.assertThat((Collection)JsonUtil.getStringSet((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": [\"23\", \"45\"]}"))).containsExactlyElementsOf(Arrays.asList("23", "45"));
    }

    @Test
    public void getStringMap() throws JsonProcessingException {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getStringMap((String)"items", (JsonNode)JsonUtil.mapper().readTree("{}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing map: items");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getStringMap((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": null}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse from non-object value: items: null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonUtil.getStringMap((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": {\"a\":\"23\", \"b\":45}}"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to a string value: b: 45");
        ImmutableMap items = ImmutableMap.of((Object)"a", (Object)"23", (Object)"b", (Object)"45");
        Assertions.assertThat((Map)JsonUtil.getStringMap((String)"items", (JsonNode)JsonUtil.mapper().readTree("{\"items\": {\"a\":\"23\", \"b\":\"45\"}}"))).isEqualTo((Object)items);
        String json = JsonUtil.generate(arg_0 -> TestJsonUtil.lambda$getStringMap$49((Map)items, arg_0), (boolean)false);
        Assertions.assertThat((Map)JsonUtil.getStringMap((String)"items", (JsonNode)JsonUtil.mapper().readTree(json))).isEqualTo((Object)items);
    }

    private static /* synthetic */ void lambda$getStringMap$49(Map items, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        JsonUtil.writeStringMap((String)"items", (Map)items, (JsonGenerator)gen);
        gen.writeEndObject();
    }
}

