/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.LockManagers;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestInMemoryLockManager {
    private LockManagers.InMemoryLockManager lockManager;
    private String lockEntityId;
    private String ownerId;
    @Rule
    public Timeout timeout = new Timeout(5L, TimeUnit.SECONDS);

    @Before
    public void before() {
        this.lockEntityId = UUID.randomUUID().toString();
        this.ownerId = UUID.randomUUID().toString();
        this.lockManager = new LockManagers.InMemoryLockManager((Map)Maps.newHashMap());
    }

    @After
    public void after() {
        this.lockManager.close();
    }

    @Test
    public void testAcquireOnceSingleProcess() {
        this.lockManager.acquireOnce(this.lockEntityId, this.ownerId);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lockManager.acquireOnce(this.lockEntityId, this.ownerId)).isInstanceOf(IllegalStateException.class)).hasMessageStartingWith("Lock for").hasMessageContaining("currently held by").hasMessageContaining("expiration");
    }

    @Test
    public void testAcquireOnceMultiProcesses() {
        List results = IntStream.range(0, 10).parallel().mapToObj(i -> {
            try {
                this.lockManager.acquireOnce(this.lockEntityId, this.ownerId);
                return true;
            }
            catch (IllegalStateException e) {
                return false;
            }
        }).collect(Collectors.toList());
        Assert.assertEquals((String)"only 1 thread should have acquired the lock", (long)1L, (long)results.stream().filter(s -> s).count());
    }

    @Test
    public void testReleaseAndAcquire() {
        Assert.assertTrue((boolean)this.lockManager.acquire(this.lockEntityId, this.ownerId));
        Assert.assertTrue((boolean)this.lockManager.release(this.lockEntityId, this.ownerId));
        Assert.assertTrue((String)"acquire after release should succeed", (boolean)this.lockManager.acquire(this.lockEntityId, this.ownerId));
    }

    @Test
    public void testReleaseWithWrongOwner() {
        Assert.assertTrue((boolean)this.lockManager.acquire(this.lockEntityId, this.ownerId));
        Assert.assertFalse((String)"should return false if ownerId is wrong", (boolean)this.lockManager.release(this.lockEntityId, UUID.randomUUID().toString()));
    }

    @Test
    public void testAcquireSingleProcess() throws Exception {
        this.lockManager.initialize((Map)ImmutableMap.of((Object)"lock.acquire-interval-ms", (Object)"500", (Object)"lock.acquire-timeout-ms", (Object)"2000"));
        Assert.assertTrue((boolean)this.lockManager.acquire(this.lockEntityId, this.ownerId));
        String oldOwner = this.ownerId;
        CompletableFuture.supplyAsync(() -> {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            Assert.assertTrue((boolean)this.lockManager.release(this.lockEntityId, oldOwner));
            return null;
        });
        this.ownerId = UUID.randomUUID().toString();
        long start = System.currentTimeMillis();
        Assert.assertTrue((boolean)this.lockManager.acquire(this.lockEntityId, this.ownerId));
        Assert.assertTrue((String)"should succeed after 200ms", (System.currentTimeMillis() - start >= 200L ? 1 : 0) != 0);
    }

    @Test
    public void testAcquireMultiProcessAllSucceed() {
        this.lockManager.initialize((Map)ImmutableMap.of((Object)"lock.acquire-interval-ms", (Object)"500"));
        long start = System.currentTimeMillis();
        List results = IntStream.range(0, 3).parallel().mapToObj(i -> {
            String owner = UUID.randomUUID().toString();
            boolean succeeded = this.lockManager.acquire(this.lockEntityId, owner);
            if (succeeded) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                Assert.assertTrue((boolean)this.lockManager.release(this.lockEntityId, owner));
            }
            return succeeded;
        }).collect(Collectors.toList());
        Assert.assertEquals((String)"all lock acquire should succeed sequentially", (long)3L, (long)results.stream().filter(s -> s).count());
        Assert.assertTrue((String)"must take more than 3 seconds", (System.currentTimeMillis() - start >= 3000L ? 1 : 0) != 0);
    }

    @Test
    public void testAcquireMultiProcessOnlyOneSucceed() {
        this.lockManager.initialize((Map)ImmutableMap.of((Object)"lock.heartbeat-interval-ms", (Object)"100", (Object)"lock.acquire-interval-ms", (Object)"500", (Object)"lock.acquire-timeout-ms", (Object)"2000"));
        List results = IntStream.range(0, 3).parallel().mapToObj(i -> this.lockManager.acquire(this.lockEntityId, this.ownerId)).collect(Collectors.toList());
        Assert.assertEquals((String)"only 1 thread should have acquired the lock", (long)1L, (long)results.stream().filter(s -> s).count());
    }
}

