/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.Map;
import java.util.Optional;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.util.EnvironmentUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

class TestEnvironmentUtil {
    TestEnvironmentUtil() {
    }

    @Test
    public void testEnvironmentSubstitution() {
        Optional envEntry = System.getenv().entrySet().stream().findFirst();
        Assumptions.assumeTrue((boolean)envEntry.isPresent(), (String)"Expecting at least one env. variable to be present");
        Map resolvedProps = EnvironmentUtil.resolveAll((Map)ImmutableMap.of((Object)"env-test", (Object)("env:" + (String)((Map.Entry)envEntry.get()).getKey())));
        Assertions.assertEquals((Object)ImmutableMap.of((Object)"env-test", (Object)((String)((Map.Entry)envEntry.get()).getValue())), (Object)resolvedProps, (String)"Should get the user from the environment");
    }

    @Test
    public void testMultipleEnvironmentSubstitutions() {
        Map result = EnvironmentUtil.resolveAll((Map)ImmutableMap.of((Object)"USER", (Object)"u", (Object)"VAR", (Object)"value"), (Map)ImmutableMap.of((Object)"user-test", (Object)"env:USER", (Object)"other", (Object)"left-alone", (Object)"var", (Object)"env:VAR"));
        Assertions.assertEquals((Object)ImmutableMap.of((Object)"user-test", (Object)"u", (Object)"other", (Object)"left-alone", (Object)"var", (Object)"value"), (Object)result, (String)"Should resolve all values starting with env:");
    }

    @Test
    public void testEnvironmentSubstitutionWithMissingVar() {
        Map result = EnvironmentUtil.resolveAll((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"user-test", (Object)"env:USER"));
        Assertions.assertEquals((Object)ImmutableMap.of(), (Object)result, (String)"Should not contain values with missing environment variables");
    }
}

