/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.List;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.BinPacking;
import org.junit.Assert;
import org.junit.Test;

public class TestBinPacking {
    @Test
    public void testBasicBinPacking() {
        Assert.assertEquals((String)"Should pack the first 2 values", this.list(this.list(1, 2), this.list(3), this.list(4), this.list(5)), this.pack(this.list(1, 2, 3, 4, 5), 3L));
        Assert.assertEquals((String)"Should pack the first 2 values", this.list(this.list(1, 2), this.list(3), this.list(4), this.list(5)), this.pack(this.list(1, 2, 3, 4, 5), 5L));
        Assert.assertEquals((String)"Should pack the first 3 values", this.list(this.list(1, 2, 3), this.list(4), this.list(5)), this.pack(this.list(1, 2, 3, 4, 5), 6L));
        Assert.assertEquals((String)"Should pack the first 3 values", this.list(this.list(1, 2, 3), this.list(4), this.list(5)), this.pack(this.list(1, 2, 3, 4, 5), 8L));
        Assert.assertEquals((String)"Should pack the first 3 values, last 2 values", this.list(this.list(1, 2, 3), this.list(4, 5)), this.pack(this.list(1, 2, 3, 4, 5), 9L));
        Assert.assertEquals((String)"Should pack the first 4 values", this.list(this.list(1, 2, 3, 4), this.list(5)), this.pack(this.list(1, 2, 3, 4, 5), 10L));
        Assert.assertEquals((String)"Should pack the first 4 values", this.list(this.list(1, 2, 3, 4), this.list(5)), this.pack(this.list(1, 2, 3, 4, 5), 14L));
        Assert.assertEquals((String)"Should pack the first 5 values", this.list(this.list(1, 2, 3, 4, 5)), this.pack(this.list(1, 2, 3, 4, 5), 15L));
    }

    @Test
    public void testReverseBinPackingSingleLookback() {
        Assert.assertEquals((String)"Should pack the first 2 values", this.list(this.list(1, 2), this.list(3), this.list(4), this.list(5)), this.packEnd(this.list(1, 2, 3, 4, 5), 3L, 1));
        Assert.assertEquals((String)"Should pack the first 2 values", this.list(this.list(1, 2), this.list(3), this.list(4), this.list(5)), this.packEnd(this.list(1, 2, 3, 4, 5), 4L, 1));
        Assert.assertEquals((String)"Should pack the second and third values", this.list(this.list(1), this.list(2, 3), this.list(4), this.list(5)), this.packEnd(this.list(1, 2, 3, 4, 5), 5L, 1));
        Assert.assertEquals((String)"Should pack the first 3 values", this.list(this.list(1, 2, 3), this.list(4), this.list(5)), this.packEnd(this.list(1, 2, 3, 4, 5), 6L, 1));
        Assert.assertEquals((String)"Should pack the first two pairs of values", this.list(this.list(1, 2), this.list(3, 4), this.list(5)), this.packEnd(this.list(1, 2, 3, 4, 5), 7L, 1));
        Assert.assertEquals((String)"Should pack the first two pairs of values", this.list(this.list(1, 2), this.list(3, 4), this.list(5)), this.packEnd(this.list(1, 2, 3, 4, 5), 8L, 1));
        Assert.assertEquals((String)"Should pack the first 3 values, last 2 values", this.list(this.list(1, 2, 3), this.list(4, 5)), this.packEnd(this.list(1, 2, 3, 4, 5), 9L, 1));
        Assert.assertEquals((String)"Should pack the first 3 values, last 2 values", this.list(this.list(1, 2, 3), this.list(4, 5)), this.packEnd(this.list(1, 2, 3, 4, 5), 11L, 1));
        Assert.assertEquals((String)"Should pack the first 3 values, last 2 values", this.list(this.list(1, 2), this.list(3, 4, 5)), this.packEnd(this.list(1, 2, 3, 4, 5), 12L, 1));
        Assert.assertEquals((String)"Should pack the last 4 values", this.list(this.list(1), this.list(2, 3, 4, 5)), this.packEnd(this.list(1, 2, 3, 4, 5), 14L, 1));
        Assert.assertEquals((String)"Should pack the first 5 values", this.list(this.list(1, 2, 3, 4, 5)), this.packEnd(this.list(1, 2, 3, 4, 5), 15L, 1));
    }

    @Test
    public void testReverseBinPackingUnlimitedLookback() {
        Assert.assertEquals((String)"Should pack the first 2 values", this.list(this.list(1, 2), this.list(3), this.list(4), this.list(5)), this.packEnd(this.list(1, 2, 3, 4, 5), 3L));
        Assert.assertEquals((String)"Should pack 1 with 3", this.list(this.list(2), this.list(1, 3), this.list(4), this.list(5)), this.packEnd(this.list(1, 2, 3, 4, 5), 4L));
        Assert.assertEquals((String)"Should pack 2,3 and 1,4", this.list(this.list(2, 3), this.list(1, 4), this.list(5)), this.packEnd(this.list(1, 2, 3, 4, 5), 5L));
        Assert.assertEquals((String)"Should pack 2,4 and 1,5", this.list(this.list(3), this.list(2, 4), this.list(1, 5)), this.packEnd(this.list(1, 2, 3, 4, 5), 6L));
        Assert.assertEquals((String)"Should pack 3,4 and 2,5", this.list(this.list(1), this.list(3, 4), this.list(2, 5)), this.packEnd(this.list(1, 2, 3, 4, 5), 7L));
        Assert.assertEquals((String)"Should pack 1,2,3 and 3,5", this.list(this.list(1, 2, 4), this.list(3, 5)), this.packEnd(this.list(1, 2, 3, 4, 5), 8L));
        Assert.assertEquals((String)"Should pack the first 3 values, last 2 values", this.list(this.list(1, 2, 3), this.list(4, 5)), this.packEnd(this.list(1, 2, 3, 4, 5), 9L));
        Assert.assertEquals((String)"Should pack 2,3 and 1,4,5", this.list(this.list(2, 3), this.list(1, 4, 5)), this.packEnd(this.list(1, 2, 3, 4, 5), 10L));
        Assert.assertEquals((String)"Should pack 1,3 and 2,4,5", this.list(this.list(1, 3), this.list(2, 4, 5)), this.packEnd(this.list(1, 2, 3, 4, 5), 11L));
        Assert.assertEquals((String)"Should pack 1,2 and 3,4,5", this.list(this.list(1, 2), this.list(3, 4, 5)), this.packEnd(this.list(1, 2, 3, 4, 5), 12L));
        Assert.assertEquals((String)"Should pack 1,2 and 3,4,5", this.list(this.list(2), this.list(1, 3, 4, 5)), this.packEnd(this.list(1, 2, 3, 4, 5), 13L));
        Assert.assertEquals((String)"Should pack the last 4 values", this.list(this.list(1), this.list(2, 3, 4, 5)), this.packEnd(this.list(1, 2, 3, 4, 5), 14L));
        Assert.assertEquals((String)"Should pack the first 5 values", this.list(this.list(1, 2, 3, 4, 5)), this.packEnd(this.list(1, 2, 3, 4, 5), 15L));
    }

    @Test
    public void testBinPackingLookBack() {
        Assert.assertEquals((String)"Unlimited look-back: should merge ones into first bin", this.list(this.list(5, 1, 1, 1), this.list(5), this.list(5)), this.pack(this.list(5, 1, 5, 1, 5, 1), 8L));
        Assert.assertEquals((String)"2 bin look-back: should merge two ones into first bin", this.list(this.list(5, 1, 1), this.list(5, 1), this.list(5)), this.pack(this.list(5, 1, 5, 1, 5, 1), 8L, 2));
        Assert.assertEquals((String)"1 bin look-back: should merge ones with fives", this.list(this.list(5, 1), this.list(5, 1), this.list(5, 1)), this.pack(this.list(5, 1, 5, 1, 5, 1), 8L, 1));
        Assert.assertEquals((String)"2 bin look-back: should merge until targetWeight when largestBinFirst is enabled", this.list(this.list(36, 36, 36), this.list(128), this.list(36, 65), this.list(65)), this.pack(this.list(36, 36, 36, 36, 65, 65, 128), 128L, 2, true));
        Assert.assertEquals((String)"1 bin look-back: should merge until targetWeight when largestBinFirst is enabled", this.list(this.list(64, 64), this.list(128), this.list(32, 32, 32, 32)), this.pack(this.list(64, 64, 128, 32, 32, 32, 32), 128L, 1, true));
    }

    private List<List<Integer>> pack(List<Integer> items, long targetWeight) {
        return this.pack(items, targetWeight, Integer.MAX_VALUE);
    }

    private List<List<Integer>> pack(List<Integer> items, long targetWeight, int lookback) {
        return this.pack(items, targetWeight, lookback, false);
    }

    private List<List<Integer>> pack(List<Integer> items, long targetWeight, int lookback, boolean largestBinFirst) {
        BinPacking.ListPacker packer = new BinPacking.ListPacker(targetWeight, lookback, largestBinFirst);
        return packer.pack(items, Integer::longValue);
    }

    private List<List<Integer>> packEnd(List<Integer> items, long targetWeight) {
        return this.packEnd(items, targetWeight, Integer.MAX_VALUE);
    }

    private List<List<Integer>> packEnd(List<Integer> items, long targetWeight, int lookback) {
        BinPacking.ListPacker packer = new BinPacking.ListPacker(targetWeight, lookback, false);
        return packer.packEnd(items, Integer::longValue);
    }

    private <T> List<T> list(T ... items) {
        return Lists.newArrayList((Object[])items);
    }
}

