/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.rest.RequestResponseTestBase;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;
import org.junit.Assert;
import org.junit.Test;

public class TestUpdateNamespacePropertiesResponse
extends RequestResponseTestBase<UpdateNamespacePropertiesResponse> {
    private static final List<String> UPDATED = ImmutableList.of((Object)"owner");
    private static final List<String> REMOVED = ImmutableList.of((Object)"foo");
    private static final List<String> MISSING = ImmutableList.of((Object)"bar");
    private static final List<String> EMPTY_LIST = ImmutableList.of();

    @Test
    public void testRoundTripSerDe() throws JsonProcessingException {
        String fullJson = "{\"removed\":[\"foo\"],\"updated\":[\"owner\"],\"missing\":[\"bar\"]}";
        this.assertRoundTripSerializesEquallyFrom(fullJson, UpdateNamespacePropertiesResponse.builder().addUpdated(UPDATED).addRemoved(REMOVED).addMissing(MISSING).build());
        String jsonOnlyUpdated = "{\"removed\":[],\"updated\":[\"owner\"],\"missing\":[]}";
        this.assertRoundTripSerializesEquallyFrom(jsonOnlyUpdated, UpdateNamespacePropertiesResponse.builder().addUpdated(UPDATED).build());
        this.assertRoundTripSerializesEquallyFrom(jsonOnlyUpdated, UpdateNamespacePropertiesResponse.builder().addUpdated("owner").build());
        this.assertRoundTripSerializesEquallyFrom(jsonOnlyUpdated, UpdateNamespacePropertiesResponse.builder().addUpdated(UPDATED).addMissing(EMPTY_LIST).addRemoved(EMPTY_LIST).build());
        String jsonOnlyRemoved = "{\"removed\":[\"foo\"],\"updated\":[],\"missing\":[]}";
        this.assertRoundTripSerializesEquallyFrom(jsonOnlyRemoved, UpdateNamespacePropertiesResponse.builder().addRemoved(REMOVED).build());
        this.assertRoundTripSerializesEquallyFrom(jsonOnlyRemoved, UpdateNamespacePropertiesResponse.builder().addRemoved("foo").build());
        this.assertRoundTripSerializesEquallyFrom(jsonOnlyRemoved, UpdateNamespacePropertiesResponse.builder().addRemoved(REMOVED).addUpdated(EMPTY_LIST).addMissing(EMPTY_LIST).build());
        String jsonOnlyMissing = "{\"removed\":[],\"updated\":[],\"missing\":[\"bar\"]}";
        this.assertRoundTripSerializesEquallyFrom(jsonOnlyMissing, UpdateNamespacePropertiesResponse.builder().addMissing(MISSING).build());
        this.assertRoundTripSerializesEquallyFrom(jsonOnlyMissing, UpdateNamespacePropertiesResponse.builder().addMissing("bar").build());
        this.assertRoundTripSerializesEquallyFrom(jsonOnlyMissing, UpdateNamespacePropertiesResponse.builder().addMissing(MISSING).addUpdated(EMPTY_LIST).addRemoved(EMPTY_LIST).build());
        String jsonWithAllFieldsAsEmptyList = "{\"removed\":[],\"updated\":[],\"missing\":[]}";
        this.assertRoundTripSerializesEquallyFrom(jsonWithAllFieldsAsEmptyList, UpdateNamespacePropertiesResponse.builder().build());
    }

    @Test
    public void testCanDeserializeWithoutDefaultValues() throws JsonProcessingException {
        UpdateNamespacePropertiesResponse onlyUpdated = UpdateNamespacePropertiesResponse.builder().addUpdated(UPDATED).build();
        String jsonOnlyUpdatedOthersNull = "{\"removed\":null,\"updated\":[\"owner\"],\"missing\":null}";
        this.assertEquals(this.deserialize(jsonOnlyUpdatedOthersNull), onlyUpdated);
        String jsonOnlyUpdatedOthersMissing = "{\"updated\":[\"owner\"]}";
        this.assertEquals(this.deserialize(jsonOnlyUpdatedOthersMissing), onlyUpdated);
        UpdateNamespacePropertiesResponse onlyRemoved = UpdateNamespacePropertiesResponse.builder().addRemoved(REMOVED).build();
        String jsonOnlyRemovedOthersNull = "{\"removed\":[\"foo\"],\"updated\":null,\"missing\":null}";
        this.assertEquals(this.deserialize(jsonOnlyRemovedOthersNull), onlyRemoved);
        String jsonOnlyRemovedOthersMissing = "{\"removed\":[\"foo\"]}";
        this.assertEquals(this.deserialize(jsonOnlyRemovedOthersMissing), onlyRemoved);
        UpdateNamespacePropertiesResponse onlyMissing = UpdateNamespacePropertiesResponse.builder().addMissing(MISSING).build();
        String jsonOnlyMissingFieldOthersNull = "{\"removed\":null,\"updated\":null,\"missing\":[\"bar\"]}";
        this.assertEquals(this.deserialize(jsonOnlyMissingFieldOthersNull), onlyMissing);
        String jsonOnlyMissingFieldIsPresent = "{\"missing\":[\"bar\"]}";
        this.assertEquals(this.deserialize(jsonOnlyMissingFieldIsPresent), onlyMissing);
        UpdateNamespacePropertiesResponse noValues = UpdateNamespacePropertiesResponse.builder().build();
        String emptyJson = "{}";
        this.assertEquals(this.deserialize(emptyJson), noValues);
    }

    @Test
    public void testDeserializeInvalidResponse() {
        String jsonInvalidTypeOnRemovedField = "{\"removed\":{\"foo\":true},\"updated\":[\"owner\"],\"missing\":[\"bar\"]}";
        AssertHelpers.assertThrows((String)"A JSON response with an invalid type for one of the fields should fail to parse", JsonProcessingException.class, () -> this.deserialize(jsonInvalidTypeOnRemovedField));
        String jsonInvalidTypeOnUpdatedField = "{\"updated\":\"owner\",\"missing\":[\"bar\"]}";
        AssertHelpers.assertThrows((String)"A JSON response with an invalid type for one of the fields should fail to parse", JsonProcessingException.class, () -> this.deserialize(jsonInvalidTypeOnUpdatedField));
        String jsonInvalidValueOfTypeIntNestedInRemovedList = "{\"removed\":[\"foo\", \"bar\", 123456], ,\"updated\":[\"owner\"],\"missing\":[\"bar\"]}";
        AssertHelpers.assertThrows((String)"A JSON response with an invalid type inside one of the list fields should fail to deserialize", JsonProcessingException.class, () -> this.deserialize(jsonInvalidValueOfTypeIntNestedInRemovedList));
        AssertHelpers.assertThrows((String)"A null JSON response body should fail to deserialize", IllegalArgumentException.class, () -> this.deserialize(null));
    }

    @Test
    public void testBuilderDoesNotCreateInvalidObjects() {
        ArrayList listContainingNull = Lists.newArrayList((Object[])new String[]{"a", null, null});
        AssertHelpers.assertThrows((String)"The builder should not allow using null as a property that was updated", NullPointerException.class, (String)"Invalid updated property: null", () -> UpdateNamespacePropertiesResponse.builder().addUpdated((String)null).build());
        AssertHelpers.assertThrows((String)"The builder should not allow passing a null list of properties that were removed", NullPointerException.class, (String)"Invalid updated property list: null", () -> UpdateNamespacePropertiesResponse.builder().addUpdated((Collection)null).build());
        AssertHelpers.assertThrows((String)"The builder should not allow passing a list of properties that were removed with a null element", IllegalArgumentException.class, (String)"Invalid updated property: null", () -> UpdateNamespacePropertiesResponse.builder().addUpdated((Collection)listContainingNull).build());
        AssertHelpers.assertThrows((String)"The builder should not allow using null as a property that was removed", NullPointerException.class, (String)"Invalid removed property: null", () -> UpdateNamespacePropertiesResponse.builder().addRemoved((String)null).build());
        AssertHelpers.assertThrows((String)"The builder should not allow passing a null list of properties that were removed", NullPointerException.class, (String)"Invalid removed property list: null", () -> UpdateNamespacePropertiesResponse.builder().addRemoved((Collection)null).build());
        AssertHelpers.assertThrows((String)"The builder should not allow passing a list of properties that were removed with a null element", IllegalArgumentException.class, (String)"Invalid removed property: null", () -> UpdateNamespacePropertiesResponse.builder().addRemoved((Collection)listContainingNull).build());
        AssertHelpers.assertThrows((String)"The builder should not allow using null as a property that was missing", NullPointerException.class, (String)"Invalid missing property: null", () -> UpdateNamespacePropertiesResponse.builder().addMissing((String)null).build());
        AssertHelpers.assertThrows((String)"The builder should not allow passing a null list of properties that were missing", NullPointerException.class, (String)"Invalid missing property list: null", () -> UpdateNamespacePropertiesResponse.builder().addMissing((Collection)null).build());
        AssertHelpers.assertThrows((String)"The builder should not allow passing a list of properties that were missing with a null element", IllegalArgumentException.class, (String)"Invalid missing property: null", () -> UpdateNamespacePropertiesResponse.builder().addMissing((Collection)listContainingNull).build());
    }

    @Override
    public String[] allFieldsFromSpec() {
        return new String[]{"updated", "removed", "missing"};
    }

    @Override
    public UpdateNamespacePropertiesResponse createExampleInstance() {
        return UpdateNamespacePropertiesResponse.builder().addUpdated(UPDATED).addMissing(MISSING).addRemoved(REMOVED).build();
    }

    @Override
    public void assertEquals(UpdateNamespacePropertiesResponse actual, UpdateNamespacePropertiesResponse expected) {
        Assert.assertEquals((String)"Properties updated should be equal", (Object)Sets.newHashSet((Iterable)actual.updated()), (Object)Sets.newHashSet((Iterable)expected.updated()));
        Assert.assertEquals((String)"Properties removed should be equal", (Object)Sets.newHashSet((Iterable)actual.removed()), (Object)Sets.newHashSet((Iterable)expected.removed()));
        Assert.assertEquals((String)"Properties missing should be equal", (Object)Sets.newHashSet((Iterable)actual.missing()), (Object)Sets.newHashSet((Iterable)expected.missing()));
    }

    @Override
    public UpdateNamespacePropertiesResponse deserialize(String json) throws JsonProcessingException {
        UpdateNamespacePropertiesResponse resp = (UpdateNamespacePropertiesResponse)TestUpdateNamespacePropertiesResponse.mapper().readValue(json, UpdateNamespacePropertiesResponse.class);
        resp.validate();
        return resp;
    }
}

