/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.rest.RequestResponseTestBase;
import org.apache.iceberg.rest.auth.OAuth2Util;
import org.apache.iceberg.rest.responses.OAuthTokenResponse;
import org.junit.Assert;
import org.junit.Test;

public class TestOAuthTokenResponse
extends RequestResponseTestBase<OAuthTokenResponse> {
    @Override
    public String[] allFieldsFromSpec() {
        return new String[]{"access_token", "token_type", "issued_token_type", "expires_in", "scope"};
    }

    @Override
    public OAuthTokenResponse createExampleInstance() {
        return OAuthTokenResponse.builder().setExpirationInSeconds(600).withToken("test-token").withIssuedTokenType("urn:ietf:params:oauth:token-type:access_token").withTokenType("Bearer").addScope("catalog").build();
    }

    @Override
    public void assertEquals(OAuthTokenResponse actual, OAuthTokenResponse expected) {
        Assert.assertEquals((String)"Token should match", (Object)expected.token(), (Object)actual.token());
        Assert.assertEquals((String)"Token type should match", (Object)expected.tokenType(), (Object)actual.tokenType());
        Assert.assertEquals((String)"Issued token type should match", (Object)expected.issuedTokenType(), (Object)actual.issuedTokenType());
        Assert.assertEquals((String)"Expiration should match", (Object)expected.expiresInSeconds(), (Object)actual.expiresInSeconds());
        Assert.assertEquals((String)"Scope should match", (Object)expected.scopes(), (Object)actual.scopes());
    }

    @Override
    public OAuthTokenResponse deserialize(String json) throws JsonProcessingException {
        return OAuth2Util.tokenResponseFromJson((String)json);
    }

    @Override
    public String serialize(OAuthTokenResponse response) throws JsonProcessingException {
        return OAuth2Util.tokenResponseToJson((OAuthTokenResponse)response);
    }

    @Test
    public void testRoundTrip() throws Exception {
        this.assertRoundTripSerializesEquallyFrom("{\"access_token\":\"bearer-token\",\"token_type\":\"bearer\"}", OAuthTokenResponse.builder().withToken("bearer-token").withTokenType("bearer").build());
        this.assertRoundTripSerializesEquallyFrom("{\"access_token\":\"bearer-token\",\"token_type\":\"bearer\",\"issued_token_type\":\"urn:ietf:params:oauth:token-type:access_token\"}", OAuthTokenResponse.builder().withToken("bearer-token").withTokenType("bearer").withIssuedTokenType("urn:ietf:params:oauth:token-type:access_token").build());
        this.assertRoundTripSerializesEquallyFrom("{\"access_token\":\"bearer-token\",\"token_type\":\"bearer\",\"expires_in\":600}", OAuthTokenResponse.builder().withToken("bearer-token").withTokenType("bearer").setExpirationInSeconds(600).build());
        this.assertRoundTripSerializesEquallyFrom("{\"access_token\":\"bearer-token\",\"token_type\":\"bearer\",\"scope\":\"a b\"}", OAuthTokenResponse.builder().withToken("bearer-token").withTokenType("bearer").addScope("a").addScope("b").build());
        this.assertRoundTripSerializesEquallyFrom("{\"access_token\":\"bearer-token\",\"token_type\":\"bearer\",\"issued_token_type\":\"urn:ietf:params:oauth:token-type:access_token\",\"expires_in\":600,\"scope\":\"a b\"}", OAuthTokenResponse.builder().withToken("bearer-token").withTokenType("bearer").withIssuedTokenType("urn:ietf:params:oauth:token-type:access_token").setExpirationInSeconds(600).addScope("a").addScope("b").build());
    }

    @Test
    public void testFailures() {
        AssertHelpers.assertThrows((String)"Token should be required", IllegalArgumentException.class, (String)"missing string: access_token", () -> this.deserialize("{\"token_type\":\"bearer\"}"));
        AssertHelpers.assertThrows((String)"Token should be string", IllegalArgumentException.class, (String)"Cannot parse to a string value: access_token: 34", () -> this.deserialize("{\"access_token\":34,\"token_type\":\"bearer\"}"));
        AssertHelpers.assertThrows((String)"Token type should be required", IllegalArgumentException.class, (String)"missing string: token_type", () -> this.deserialize("{\"access_token\":\"bearer-token\"}"));
        AssertHelpers.assertThrows((String)"Token type should be string", IllegalArgumentException.class, (String)"Cannot parse to a string value: token_type: 34", () -> this.deserialize("{\"access_token\":\"bearer-token\",\"token_type\":34}"));
    }
}

