/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.rest.responses.OAuthErrorResponseParser;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestOAuthErrorResponseParser {
    @Test
    public void testOAuthErrorResponseFromJson() {
        String error = "invalid_client";
        String description = "Credentials given were invalid";
        String uri = "http://iceberg.apache.org";
        String json = String.format("{\"error\":\"%s\",\"error_description\":\"%s\",\"error_uri\":\"%s\"}", error, description, uri);
        ErrorResponse expected = ErrorResponse.builder().responseCode(Integer.valueOf(400)).withType(error).withMessage(description).build();
        this.assertEquals(expected, OAuthErrorResponseParser.fromJson((int)400, (String)json));
    }

    @Test
    public void testOAuthErrorResponseFromJsonWithNulls() {
        String error = "invalid_client";
        String json = String.format("{\"error\":\"%s\"}", error);
        ErrorResponse expected = ErrorResponse.builder().responseCode(Integer.valueOf(400)).withType(error).build();
        this.assertEquals(expected, OAuthErrorResponseParser.fromJson((int)400, (String)json));
        json = String.format("{\"error\":\"%s\",\"error_description\":null,\"error_uri\":null}", error);
        this.assertEquals(expected, OAuthErrorResponseParser.fromJson((int)400, (String)json));
    }

    @Test
    public void testOAuthErrorResponseFromJsonMissingError() {
        String description = "Credentials given were invalid";
        String uri = "http://iceberg.apache.org";
        String json = String.format("{\"error_description\":\"%s\",\"error_uri\":\"%s\"}", description, uri);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> OAuthErrorResponseParser.fromJson((int)400, (String)json)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing string: error");
    }

    public void assertEquals(ErrorResponse expected, ErrorResponse actual) {
        Assertions.assertThat((Integer)actual.code()).isEqualTo((Object)expected.code());
        Assertions.assertThat((String)actual.type()).isEqualTo(expected.type());
        Assertions.assertThat((String)actual.message()).isEqualTo(expected.message());
    }
}

