/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.rest.RequestResponseTestBase;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestLoadTableResponse
extends RequestResponseTestBase<LoadTableResponse> {
    private static final String TEST_METADATA_LOCATION = "s3://bucket/test/location/metadata/v1.metadata.json";
    private static final String TEST_TABLE_LOCATION = "s3://bucket/test/location";
    private static final Schema SCHEMA_7 = new Schema(7, new Types.NestedField[]{Types.NestedField.required((int)1, (String)"x", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"y", (Type)Types.LongType.get(), (String)"comment"), Types.NestedField.required((int)3, (String)"z", (Type)Types.LongType.get())});
    private static final PartitionSpec SPEC_5 = PartitionSpec.builderFor((Schema)SCHEMA_7).withSpecId(5).build();
    private static final SortOrder SORT_ORDER_3 = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA_7).withOrderId(3).asc("y", NullOrder.NULLS_FIRST)).desc((Term)Expressions.bucket((String)"z", (int)4), NullOrder.NULLS_LAST).build();
    private static final Map<String, String> TABLE_PROPS = ImmutableMap.of((Object)"format-version", (Object)"1", (Object)"owner", (Object)"hank");
    private static final Map<String, String> CONFIG = ImmutableMap.of((Object)"foo", (Object)"bar");

    @Override
    public String[] allFieldsFromSpec() {
        return new String[]{"metadata-location", "metadata", "config"};
    }

    @Override
    public LoadTableResponse createExampleInstance() {
        TableMetadata metadata = TableMetadata.buildFrom((TableMetadata)TableMetadata.newTableMetadata((Schema)SCHEMA_7, (PartitionSpec)SPEC_5, (SortOrder)SORT_ORDER_3, (String)TEST_TABLE_LOCATION, TABLE_PROPS)).discardChanges().withMetadataLocation(TEST_METADATA_LOCATION).build();
        return LoadTableResponse.builder().withTableMetadata(metadata).addAllConfig(CONFIG).build();
    }

    @Override
    public LoadTableResponse deserialize(String json) throws JsonProcessingException {
        LoadTableResponse resp = (LoadTableResponse)TestLoadTableResponse.mapper().readValue(json, LoadTableResponse.class);
        resp.validate();
        return resp;
    }

    @Test
    public void testFailures() {
        AssertHelpers.assertThrows((String)"Table metadata should be required", NullPointerException.class, (String)"Invalid metadata: null", () -> LoadTableResponse.builder().build());
    }

    @Test
    public void testRoundTripSerdeWithV1TableMetadata() throws Exception {
        String tableMetadataJson = this.readTableMetadataInputFile("TableMetadataV1Valid.json");
        TableMetadata v1Metadata = TableMetadataParser.fromJson((String)TEST_METADATA_LOCATION, (String)tableMetadataJson);
        String json = String.format("{\"metadata-location\":\"%s\",\"metadata\":%s,\"config\":{\"foo\":\"bar\"}}", TEST_METADATA_LOCATION, TableMetadataParser.toJson((TableMetadata)v1Metadata));
        LoadTableResponse resp = LoadTableResponse.builder().withTableMetadata(v1Metadata).addAllConfig(CONFIG).build();
        this.assertRoundTripSerializesEquallyFrom(json, resp);
    }

    @Test
    public void testMissingSchemaType() throws Exception {
        String tableMetadataJson = this.readTableMetadataInputFile("TableMetadataV1MissingSchemaType.json");
        AssertHelpers.assertThrows((String)"Cannot parse type from json when there is no type", IllegalArgumentException.class, (String)"Cannot parse type from json:", () -> TableMetadataParser.fromJson((String)TEST_METADATA_LOCATION, (String)tableMetadataJson));
    }

    @Test
    public void testRoundTripSerdeWithV2TableMetadata() throws Exception {
        String tableMetadataJson = this.readTableMetadataInputFile("TableMetadataV2Valid.json");
        TableMetadata v2Metadata = TableMetadataParser.fromJson((String)TEST_METADATA_LOCATION, (String)tableMetadataJson);
        String json = String.format("{\"metadata-location\":\"%s\",\"metadata\":%s,\"config\":{\"foo\":\"bar\"}}", TEST_METADATA_LOCATION, TableMetadataParser.toJson((TableMetadata)v2Metadata));
        LoadTableResponse resp = LoadTableResponse.builder().withTableMetadata(v2Metadata).addAllConfig(CONFIG).build();
        this.assertRoundTripSerializesEquallyFrom(json, resp);
    }

    @Test
    public void testCanDeserializeWithoutDefaultValues() throws Exception {
        String metadataJson = this.readTableMetadataInputFile("TableMetadataV1Valid.json");
        String json = String.format("{\"metadata-location\":\"%s\",\"metadata\":%s}", TEST_METADATA_LOCATION, metadataJson);
        TableMetadata metadata = TableMetadataParser.fromJson((String)TEST_METADATA_LOCATION, (String)metadataJson);
        LoadTableResponse actual = this.deserialize(json);
        LoadTableResponse expected = LoadTableResponse.builder().withTableMetadata(metadata).build();
        this.assertEquals(actual, expected);
        Assert.assertEquals((String)"Deserialized JSON with missing fields should have the default values", (Object)ImmutableMap.of(), (Object)actual.config());
    }

    @Override
    public void assertEquals(LoadTableResponse actual, LoadTableResponse expected) {
        Assert.assertEquals((String)"Should have the same configuration", (Object)expected.config(), (Object)actual.config());
        this.assertEqualTableMetadata(actual.tableMetadata(), expected.tableMetadata());
        Assert.assertEquals((String)"Should have the same metadata location", (Object)expected.metadataLocation(), (Object)actual.metadataLocation());
    }

    private void assertEqualTableMetadata(TableMetadata actual, TableMetadata expected) {
        Assert.assertEquals((String)"Format version should match", (long)expected.formatVersion(), (long)actual.formatVersion());
        Assert.assertEquals((String)"Table UUID should match", (Object)expected.uuid(), (Object)actual.uuid());
        Assert.assertEquals((String)"Table location should match", (Object)expected.location(), (Object)actual.location());
        Assert.assertEquals((String)"Last column id", (long)expected.lastColumnId(), (long)actual.lastColumnId());
        Assert.assertEquals((String)"Schema should match", (Object)expected.schema().asStruct(), (Object)actual.schema().asStruct());
        TestHelpers.assertSameSchemaList((List)expected.schemas(), (List)actual.schemas());
        Assert.assertEquals((String)"Current schema id should match", (long)expected.currentSchemaId(), (long)actual.currentSchemaId());
        Assert.assertEquals((String)"Schema should match", (Object)expected.schema().asStruct(), (Object)actual.schema().asStruct());
        Assert.assertEquals((String)"Last sequence number should match", (long)expected.lastSequenceNumber(), (long)actual.lastSequenceNumber());
        Assert.assertEquals((String)"Partition spec should match", (Object)expected.spec().toString(), (Object)actual.spec().toString());
        Assert.assertEquals((String)"Default spec ID should match", (long)expected.defaultSpecId(), (long)actual.defaultSpecId());
        Assert.assertEquals((String)"PartitionSpec map should match", (Object)expected.specs(), (Object)actual.specs());
        Assert.assertEquals((String)"Default Sort ID should match", (long)expected.defaultSortOrderId(), (long)actual.defaultSortOrderId());
        Assert.assertEquals((String)"Sort order should match", (Object)expected.sortOrder(), (Object)actual.sortOrder());
        Assert.assertEquals((String)"Sort order map should match", (Object)expected.sortOrders(), (Object)actual.sortOrders());
        Assert.assertEquals((String)"Properties should match", (Object)expected.properties(), (Object)actual.properties());
        Assert.assertEquals((String)"Snapshots should match", (Object)Lists.transform((List)expected.snapshots(), Snapshot::snapshotId), (Object)Lists.transform((List)actual.snapshots(), Snapshot::snapshotId));
        Assert.assertEquals((String)"History should match", (Object)expected.snapshotLog(), (Object)actual.snapshotLog());
        Snapshot expectedCurrentSnapshot = expected.currentSnapshot();
        Snapshot actualCurrentSnapshot = actual.currentSnapshot();
        Assert.assertTrue((String)"Both expected and actual current snapshot should either be null or non-null", (expectedCurrentSnapshot != null && actualCurrentSnapshot != null || expectedCurrentSnapshot == null && actualCurrentSnapshot == null ? 1 : 0) != 0);
        if (expectedCurrentSnapshot != null) {
            Assert.assertEquals((String)"Current snapshot ID should match", (long)expected.currentSnapshot().snapshotId(), (long)actual.currentSnapshot().snapshotId());
            Assert.assertEquals((String)"Parent snapshot ID should match", (Object)expected.currentSnapshot().parentId(), (Object)actual.currentSnapshot().parentId());
            Assert.assertEquals((String)"Schema ID for current snapshot should match", (Object)expected.currentSnapshot().schemaId(), (Object)actual.currentSnapshot().schemaId());
        }
        Assert.assertEquals((String)"Metadata file location should match", (Object)expected.metadataFileLocation(), (Object)actual.metadataFileLocation());
        Assert.assertEquals((String)"Last column id should match", (long)expected.lastColumnId(), (long)actual.lastColumnId());
        Assert.assertEquals((String)"Schema should match", (Object)expected.schema().asStruct(), (Object)actual.schema().asStruct());
        TestHelpers.assertSameSchemaList((List)expected.schemas(), (List)actual.schemas());
        Assert.assertEquals((String)"Current schema id should match", (long)expected.currentSchemaId(), (long)actual.currentSchemaId());
        Assert.assertEquals((String)"Refs map should match", (Object)expected.refs(), (Object)actual.refs());
    }

    private String readTableMetadataInputFile(String fileName) throws Exception {
        Path path = Paths.get(this.getClass().getClassLoader().getResource(fileName).toURI());
        return String.join((CharSequence)"", Files.readAllLines(path));
    }
}

