/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.rest.RequestResponseTestBase;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.junit.Assert;
import org.junit.Test;

public class TestListTablesResponse
extends RequestResponseTestBase<ListTablesResponse> {
    private static final List<TableIdentifier> IDENTIFIERS = ImmutableList.of((Object)TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"accounting", "tax"}), (String)"paid"));

    @Test
    public void testRoundTripSerDe() throws JsonProcessingException {
        String fullJson = "{\"identifiers\":[{\"namespace\":[\"accounting\",\"tax\"],\"name\":\"paid\"}]}";
        this.assertRoundTripSerializesEquallyFrom(fullJson, ListTablesResponse.builder().addAll(IDENTIFIERS).build());
        String emptyIdentifiers = "{\"identifiers\":[]}";
        this.assertRoundTripSerializesEquallyFrom(emptyIdentifiers, ListTablesResponse.builder().build());
    }

    @Test
    public void testDeserializeInvalidResponsesThrows() {
        String identifiersHasWrongType = "{\"identifiers\":\"accounting%1Ftax\"}";
        AssertHelpers.assertThrows((String)"A JSON response with the incorrect type for the field identifiers should fail to parse", JsonProcessingException.class, () -> this.deserialize(identifiersHasWrongType));
        String emptyJson = "{}";
        AssertHelpers.assertThrows((String)"An empty JSON response should fail to deserialize", IllegalArgumentException.class, (String)"Invalid identifier list: null", () -> this.deserialize(emptyJson));
        String jsonWithKeysSpelledIncorrectly = "{\"identifyrezzzz\":[{\"namespace\":[\"accounting\",\"tax\"],\"name\":\"paid\"}]}";
        AssertHelpers.assertThrows((String)"A JSON response with the keys spelled incorrectly should fail to deserialize", IllegalArgumentException.class, (String)"Invalid identifier list: null", () -> this.deserialize(jsonWithKeysSpelledIncorrectly));
        String jsonWithInvalidIdentifiersInList = "{\"identifiers\":[{\"namespace\":\"accounting.tax\",\"name\":\"paid\"}]}";
        AssertHelpers.assertThrows((String)"A JSON response with an invalid identifier in the list of identifiers should fail to parse", JsonProcessingException.class, () -> this.deserialize(jsonWithInvalidIdentifiersInList));
        String jsonWithInvalidIdentifiersInList2 = "{\"identifiers\":[{\"namespace\":[\"accounting\",\"tax\"],\"name\":\"paid\"},\"accounting.tax.paid\"]}";
        AssertHelpers.assertThrows((String)"A JSON response with an invalid identifier in the list of identifiers should fail to parse", JsonProcessingException.class, () -> this.deserialize(jsonWithInvalidIdentifiersInList2));
        String jsonWithInvalidTypeForNamePartOfIdentifier = "{\"identifiers\":[{\"namespace\":[\"accounting\",\"tax\"],\"name\":true}]}";
        AssertHelpers.assertThrows((String)"A JSON response with an invalid identifier in the list of identifiers should fail to parse", JsonProcessingException.class, () -> this.deserialize(jsonWithInvalidTypeForNamePartOfIdentifier));
        String nullJson = null;
        AssertHelpers.assertThrows((String)"A null JSON response should fail to deserialize", IllegalArgumentException.class, () -> this.deserialize(nullJson));
    }

    @Test
    public void testBuilderDoesNotCreateInvalidObjects() {
        AssertHelpers.assertThrows((String)"The builder should not allow using null as a table identifier to add to the list", NullPointerException.class, (String)"Invalid table identifier: null", () -> ListTablesResponse.builder().add(null).build());
        AssertHelpers.assertThrows((String)"The builder should not allow passing a null list of table identifiers to add", NullPointerException.class, (String)"Invalid table identifier list: null", () -> ListTablesResponse.builder().addAll(null).build());
        ArrayList listWithNullElement = Lists.newArrayList((Object[])new TableIdentifier[]{TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"foo"}), (String)"bar"), null});
        AssertHelpers.assertThrows((String)"The builder should not allow passing a collection of table identifiers with a null element in it", IllegalArgumentException.class, (String)"Invalid table identifier: null", () -> ListTablesResponse.builder().addAll((Collection)listWithNullElement).build());
    }

    @Override
    public String[] allFieldsFromSpec() {
        return new String[]{"identifiers"};
    }

    @Override
    public ListTablesResponse createExampleInstance() {
        return ListTablesResponse.builder().addAll(IDENTIFIERS).build();
    }

    @Override
    public void assertEquals(ListTablesResponse actual, ListTablesResponse expected) {
        Assert.assertTrue((String)"Identifiers should be equal", (actual.identifiers().size() == expected.identifiers().size() && Sets.newHashSet((Iterable)actual.identifiers()).equals(Sets.newHashSet((Iterable)expected.identifiers())) ? 1 : 0) != 0);
    }

    @Override
    public ListTablesResponse deserialize(String json) throws JsonProcessingException {
        ListTablesResponse resp = (ListTablesResponse)TestListTablesResponse.mapper().readValue(json, ListTablesResponse.class);
        resp.validate();
        return resp;
    }
}

