/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.rest.RequestResponseTestBase;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.junit.Assert;
import org.junit.Test;

public class TestListNamespacesResponse
extends RequestResponseTestBase<ListNamespacesResponse> {
    private static final List<Namespace> NAMESPACES = ImmutableList.of((Object)Namespace.of((String[])new String[]{"accounting"}), (Object)Namespace.of((String[])new String[]{"tax"}));

    @Test
    public void testRoundTripSerDe() throws JsonProcessingException {
        String fullJson = "{\"namespaces\":[[\"accounting\"],[\"tax\"]]}";
        ListNamespacesResponse fullValue = ListNamespacesResponse.builder().addAll(NAMESPACES).build();
        this.assertRoundTripSerializesEquallyFrom(fullJson, fullValue);
        String emptyNamespaces = "{\"namespaces\":[]}";
        this.assertRoundTripSerializesEquallyFrom(emptyNamespaces, ListNamespacesResponse.builder().build());
    }

    @Test
    public void testDeserializeInvalidResponseThrows() {
        String jsonNamespacesHasWrongType = "{\"namespaces\":\"accounting\"}";
        AssertHelpers.assertThrows((String)"A malformed JSON response with the wrong type for a field should fail to deserialize", JsonProcessingException.class, () -> this.deserialize(jsonNamespacesHasWrongType));
        String emptyJson = "{}";
        AssertHelpers.assertThrows((String)"An empty JSON response will deserialize, but not into a valid object", IllegalArgumentException.class, (String)"Invalid namespace: null", () -> this.deserialize(emptyJson));
        String jsonWithKeysSpelledIncorrectly = "{\"namepsacezz\":[\"accounting\",\"tax\"]}";
        AssertHelpers.assertThrows((String)"A JSON response with the keys spelled incorrectly should fail to deserialize", IllegalArgumentException.class, (String)"Invalid namespace: null", () -> this.deserialize(jsonWithKeysSpelledIncorrectly));
        String nullJson = null;
        AssertHelpers.assertThrows((String)"A null JSON response should fail to deserialize", IllegalArgumentException.class, () -> this.deserialize(nullJson));
    }

    @Test
    public void testBuilderDoesNotCreateInvalidObjects() {
        AssertHelpers.assertThrows((String)"The builder should not allow using null as a namespace to add to the list", NullPointerException.class, (String)"Invalid namespace: null", () -> ListNamespacesResponse.builder().add(null).build());
        AssertHelpers.assertThrows((String)"The builder should not allow passing a null list of namespaces to add", NullPointerException.class, (String)"Invalid namespace list: null", () -> ListNamespacesResponse.builder().addAll(null).build());
        ArrayList listWithNullElement = Lists.newArrayList((Object[])new Namespace[]{Namespace.of((String[])new String[]{"a"}), null});
        AssertHelpers.assertThrows((String)"The builder should not allow passing a collection of namespaces with a null element in it", IllegalArgumentException.class, (String)"Invalid namespace: null", () -> ListNamespacesResponse.builder().addAll((Collection)listWithNullElement).build());
    }

    @Override
    public String[] allFieldsFromSpec() {
        return new String[]{"namespaces"};
    }

    @Override
    public ListNamespacesResponse createExampleInstance() {
        return ListNamespacesResponse.builder().addAll(NAMESPACES).build();
    }

    @Override
    public void assertEquals(ListNamespacesResponse actual, ListNamespacesResponse expected) {
        Assert.assertTrue((String)"Namespaces list should be equal", (actual.namespaces().size() == expected.namespaces().size() && Sets.newHashSet((Iterable)actual.namespaces()).equals(Sets.newHashSet((Iterable)expected.namespaces())) ? 1 : 0) != 0);
    }

    @Override
    public ListNamespacesResponse deserialize(String json) throws JsonProcessingException {
        ListNamespacesResponse resp = (ListNamespacesResponse)TestListNamespacesResponse.mapper().readValue(json, ListNamespacesResponse.class);
        resp.validate();
        return resp;
    }
}

