/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.rest.RequestResponseTestBase;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.junit.Assert;
import org.junit.Test;

public class TestGetNamespaceResponse
extends RequestResponseTestBase<GetNamespaceResponse> {
    private static final Namespace NAMESPACE = Namespace.of((String[])new String[]{"accounting", "tax"});
    private static final Map<String, String> PROPERTIES = ImmutableMap.of((Object)"owner", (Object)"Hank");
    private static final Map<String, String> EMPTY_PROPERTIES = ImmutableMap.of();

    @Test
    public void testRoundTripSerDe() throws JsonProcessingException {
        String fullJson = "{\"namespace\":[\"accounting\",\"tax\"],\"properties\":{\"owner\":\"Hank\"}}";
        GetNamespaceResponse fullValue = GetNamespaceResponse.builder().withNamespace(NAMESPACE).setProperties(PROPERTIES).build();
        this.assertRoundTripSerializesEquallyFrom(fullJson, fullValue);
        String emptyProps = "{\"namespace\":[\"accounting\",\"tax\"],\"properties\":{}}";
        this.assertRoundTripSerializesEquallyFrom(emptyProps, GetNamespaceResponse.builder().withNamespace(NAMESPACE).build());
        this.assertRoundTripSerializesEquallyFrom(emptyProps, GetNamespaceResponse.builder().withNamespace(NAMESPACE).setProperties(EMPTY_PROPERTIES).build());
    }

    @Test
    public void testCanDeserializeWithoutDefaultValues() throws JsonProcessingException {
        GetNamespaceResponse withoutProps = GetNamespaceResponse.builder().withNamespace(NAMESPACE).build();
        String jsonWithNullProperties = "{\"namespace\":[\"accounting\",\"tax\"],\"properties\":null}";
        this.assertEquals(this.deserialize(jsonWithNullProperties), withoutProps);
    }

    @Test
    public void testDeserializeInvalidResponse() {
        String jsonNamespaceHasWrongType = "{\"namespace\":\"accounting%1Ftax\",\"properties\":null}";
        AssertHelpers.assertThrows((String)"A JSON response with the wrong type for a field should fail to deserialize", JsonProcessingException.class, (String)"Cannot parse string array from non-array", () -> this.deserialize(jsonNamespaceHasWrongType));
        String jsonPropertiesHasWrongType = "{\"namespace\":[\"accounting\",\"tax\"],\"properties\":[]}";
        AssertHelpers.assertThrows((String)"A JSON response with the wrong type for a field should fail to deserialize", JsonProcessingException.class, () -> this.deserialize(jsonPropertiesHasWrongType));
        String emptyJson = "{}";
        AssertHelpers.assertThrows((String)"An empty JSON request should fail to deserialize after validation", IllegalArgumentException.class, (String)"Invalid namespace: null", () -> this.deserialize(emptyJson));
        String jsonWithKeysSpelledIncorrectly = "{\"namepsace\":[\"accounting\",\"tax\"],\"propertiezzzz\":{\"owner\":\"Hank\"}}";
        AssertHelpers.assertThrows((String)"A JSON response with the keys spelled incorrectly should fail to deserialize", IllegalArgumentException.class, (String)"Invalid namespace: null", () -> this.deserialize(jsonWithKeysSpelledIncorrectly));
        String nullJson = null;
        AssertHelpers.assertThrows((String)"An empty JSON request should fail to deserialize", IllegalArgumentException.class, () -> this.deserialize(nullJson));
    }

    @Test
    public void testBuilderDoesNotBuildInvalidRequests() {
        AssertHelpers.assertThrows((String)"The builder should not allow using null for the namespace", NullPointerException.class, (String)"Invalid namespace: null", () -> GetNamespaceResponse.builder().withNamespace(null).build());
        AssertHelpers.assertThrows((String)"The builder should not allow passing a null collection of properties", NullPointerException.class, (String)"Invalid properties map: null", () -> GetNamespaceResponse.builder().setProperties(null).build());
        HashMap mapWithNullKey = Maps.newHashMap();
        mapWithNullKey.put(null, "hello");
        AssertHelpers.assertThrows((String)"The builder should not allow using null as a key in the properties to set", IllegalArgumentException.class, (String)"Invalid property: null", () -> GetNamespaceResponse.builder().setProperties(mapWithNullKey).build());
        HashMap mapWithMultipleNullValues = Maps.newHashMap();
        mapWithMultipleNullValues.put("a", null);
        mapWithMultipleNullValues.put("b", "b");
        AssertHelpers.assertThrows((String)"The builder should not allow using null as a value in the properties to set", IllegalArgumentException.class, (String)"Invalid value for properties [a]: null", () -> GetNamespaceResponse.builder().setProperties(mapWithMultipleNullValues).build());
    }

    @Override
    public String[] allFieldsFromSpec() {
        return new String[]{"namespace", "properties"};
    }

    @Override
    public GetNamespaceResponse createExampleInstance() {
        return GetNamespaceResponse.builder().withNamespace(NAMESPACE).setProperties(PROPERTIES).build();
    }

    @Override
    public void assertEquals(GetNamespaceResponse actual, GetNamespaceResponse expected) {
        Assert.assertEquals((String)"Namespace should be equal", (Object)actual.namespace(), (Object)expected.namespace());
        Assert.assertEquals((String)"Properties should be equal", (Object)actual.properties(), (Object)expected.properties());
    }

    @Override
    public GetNamespaceResponse deserialize(String json) throws JsonProcessingException {
        GetNamespaceResponse resp = (GetNamespaceResponse)TestGetNamespaceResponse.mapper().readValue(json, GetNamespaceResponse.class);
        resp.validate();
        return resp;
    }
}

