/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.rest.RequestResponseTestBase;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.junit.Assert;
import org.junit.Test;

public class TestCreateNamespaceResponse
extends RequestResponseTestBase<CreateNamespaceResponse> {
    private static final Namespace NAMESPACE = Namespace.of((String[])new String[]{"accounting", "tax"});
    private static final Map<String, String> PROPERTIES = ImmutableMap.of((Object)"owner", (Object)"Hank");
    private static final Map<String, String> EMPTY_PROPERTIES = ImmutableMap.of();

    @Test
    public void testRoundTripSerDe() throws JsonProcessingException {
        String fullJson = "{\"namespace\":[\"accounting\",\"tax\"],\"properties\":{\"owner\":\"Hank\"}}";
        CreateNamespaceResponse req = CreateNamespaceResponse.builder().withNamespace(NAMESPACE).setProperties(PROPERTIES).build();
        this.assertRoundTripSerializesEquallyFrom(fullJson, req);
        String jsonEmptyProperties = "{\"namespace\":[\"accounting\",\"tax\"],\"properties\":{}}";
        CreateNamespaceResponse responseWithExplicitEmptyProperties = CreateNamespaceResponse.builder().withNamespace(NAMESPACE).setProperties(EMPTY_PROPERTIES).build();
        this.assertRoundTripSerializesEquallyFrom(jsonEmptyProperties, responseWithExplicitEmptyProperties);
        CreateNamespaceResponse responseWithImplicitEmptyProperties = CreateNamespaceResponse.builder().withNamespace(NAMESPACE).build();
        this.assertRoundTripSerializesEquallyFrom(jsonEmptyProperties, responseWithImplicitEmptyProperties);
        String jsonEmptyNamespace = "{\"namespace\":[],\"properties\":{}}";
        CreateNamespaceResponse responseWithEmptyNamespace = CreateNamespaceResponse.builder().withNamespace(Namespace.empty()).build();
        this.assertRoundTripSerializesEquallyFrom(jsonEmptyNamespace, responseWithEmptyNamespace);
    }

    @Test
    public void testCanDeserializeWithoutDefaultValues() throws JsonProcessingException {
        CreateNamespaceResponse noProperties = CreateNamespaceResponse.builder().withNamespace(NAMESPACE).build();
        String jsonWithMissingProperties = "{\"namespace\":[\"accounting\",\"tax\"]}";
        this.assertEquals(this.deserialize(jsonWithMissingProperties), noProperties);
        String jsonWithNullProperties = "{\"namespace\":[\"accounting\",\"tax\"],\"properties\":null}";
        this.assertEquals(this.deserialize(jsonWithNullProperties), noProperties);
        String jsonEmptyNamespaceMissingProperties = "{\"namespace\":[]}";
        CreateNamespaceResponse responseWithEmptyNamespace = CreateNamespaceResponse.builder().withNamespace(Namespace.empty()).build();
        this.assertEquals(this.deserialize(jsonEmptyNamespaceMissingProperties), responseWithEmptyNamespace);
    }

    @Test
    public void testDeserializeInvalidResponse() {
        String jsonResponseMalformedNamespaceValue = "{\"namespace\":\"accounting%1Ftax\",\"properties\":null}";
        AssertHelpers.assertThrows((String)"A JSON response with the wrong type for the namespace field should fail to deserialize", JsonProcessingException.class, (String)"Cannot parse string array from non-array", () -> this.deserialize(jsonResponseMalformedNamespaceValue));
        String jsonResponsePropertiesHasWrongType = "{\"namespace\":[\"accounting\",\"tax\"],\"properties\":[]}";
        AssertHelpers.assertThrows((String)"A JSON response with the wrong type for the properties field should fail to deserialize", JsonProcessingException.class, () -> this.deserialize(jsonResponsePropertiesHasWrongType));
        AssertHelpers.assertThrows((String)"An empty JSON response should fail to deserialize", IllegalArgumentException.class, (String)"Invalid namespace: null", () -> this.deserialize("{}"));
        String jsonMisspelledKeys = "{\"namepsace\":[\"accounting\",\"tax\"],\"propertiezzzz\":{\"owner\":\"Hank\"}}";
        AssertHelpers.assertThrows((String)"A JSON response with the keys spelled incorrectly should fail to deserialize and validate", IllegalArgumentException.class, (String)"Invalid namespace: null", () -> this.deserialize(jsonMisspelledKeys));
        AssertHelpers.assertThrows((String)"A null JSON response body should fail to deserialize", IllegalArgumentException.class, () -> this.deserialize(null));
    }

    @Test
    public void testBuilderDoesNotBuildInvalidRequests() {
        AssertHelpers.assertThrows((String)"The builder should not allow using null for the namespace", NullPointerException.class, (String)"Invalid namespace: null", () -> CreateNamespaceResponse.builder().withNamespace(null).build());
        AssertHelpers.assertThrows((String)"The builder should not allow passing a null collection of properties", NullPointerException.class, (String)"Invalid collection of properties: null", () -> CreateNamespaceResponse.builder().setProperties(null).build());
        HashMap mapWithNullKey = Maps.newHashMap();
        mapWithNullKey.put(null, "hello");
        AssertHelpers.assertThrows((String)"The builder should not allow using null as a key in the properties to set", IllegalArgumentException.class, (String)"Invalid property to set: null", () -> CreateNamespaceResponse.builder().setProperties(mapWithNullKey).build());
        HashMap mapWithMultipleNullValues = Maps.newHashMap();
        mapWithMultipleNullValues.put("a", null);
        mapWithMultipleNullValues.put("b", "b");
        AssertHelpers.assertThrows((String)"The builder should not allow using null as a value in the properties to set", IllegalArgumentException.class, (String)"Invalid value to set for properties [a]: null", () -> CreateNamespaceResponse.builder().setProperties(mapWithMultipleNullValues).build());
    }

    @Override
    public String[] allFieldsFromSpec() {
        return new String[]{"namespace", "properties"};
    }

    @Override
    public CreateNamespaceResponse createExampleInstance() {
        return CreateNamespaceResponse.builder().withNamespace(NAMESPACE).setProperties(PROPERTIES).build();
    }

    @Override
    public void assertEquals(CreateNamespaceResponse actual, CreateNamespaceResponse expected) {
        Assert.assertEquals((String)"Namespaces should be equal", (Object)actual.namespace(), (Object)expected.namespace());
        Assert.assertEquals((String)"Properties should be equal", (Object)actual.properties(), (Object)expected.properties());
    }

    @Override
    public CreateNamespaceResponse deserialize(String json) throws JsonProcessingException {
        CreateNamespaceResponse response = (CreateNamespaceResponse)TestCreateNamespaceResponse.mapper().readValue(json, CreateNamespaceResponse.class);
        response.validate();
        return response;
    }
}

