/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.rest.RequestResponseTestBase;
import org.apache.iceberg.rest.responses.ConfigResponse;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestConfigResponse
extends RequestResponseTestBase<ConfigResponse> {
    private static final Map<String, String> DEFAULTS = ImmutableMap.of((Object)"warehouse", (Object)"s3://bucket/warehouse");
    private static final Map<String, String> OVERRIDES = ImmutableMap.of((Object)"clients", (Object)"5");
    private static final Map<String, String> DEFAULTS_WITH_NULL_VALUE = Maps.newHashMap();
    private static final Map<String, String> OVERRIDES_WITH_NULL_VALUE = Maps.newHashMap();

    @BeforeClass
    public static void beforeAllForRestCatalogConfig() {
        DEFAULTS_WITH_NULL_VALUE.put("warehouse", null);
        OVERRIDES_WITH_NULL_VALUE.put("clients", null);
    }

    @Test
    public void testRoundTripSerDe() throws JsonProcessingException {
        String fullJson = "{\"defaults\":{\"warehouse\":\"s3://bucket/warehouse\"},\"overrides\":{\"clients\":\"5\"}}";
        this.assertRoundTripSerializesEquallyFrom(fullJson, ConfigResponse.builder().withOverrides(OVERRIDES).withDefaults(DEFAULTS).build());
        this.assertRoundTripSerializesEquallyFrom(fullJson, ConfigResponse.builder().withOverride("clients", "5").withDefault("warehouse", "s3://bucket/warehouse").build());
        String jsonEmptyDefaults = "{\"defaults\":{},\"overrides\":{\"clients\":\"5\"}}";
        this.assertRoundTripSerializesEquallyFrom(jsonEmptyDefaults, ConfigResponse.builder().withOverrides(OVERRIDES).build());
        this.assertRoundTripSerializesEquallyFrom(jsonEmptyDefaults, ConfigResponse.builder().withOverrides(OVERRIDES).withDefaults((Map)ImmutableMap.of()).build());
        this.assertRoundTripSerializesEquallyFrom(jsonEmptyDefaults, ConfigResponse.builder().withOverride("clients", "5").build());
        String jsonEmptyOverrides = "{\"defaults\":{\"warehouse\":\"s3://bucket/warehouse\"},\"overrides\":{}}";
        this.assertRoundTripSerializesEquallyFrom(jsonEmptyOverrides, ConfigResponse.builder().withDefaults(DEFAULTS).build());
        this.assertRoundTripSerializesEquallyFrom(jsonEmptyOverrides, ConfigResponse.builder().withDefault("warehouse", "s3://bucket/warehouse").build());
        this.assertRoundTripSerializesEquallyFrom(jsonEmptyOverrides, ConfigResponse.builder().withDefaults(DEFAULTS).withOverrides((Map)ImmutableMap.of()).build());
        String emptyJson = "{\"defaults\":{},\"overrides\":{}}";
        this.assertRoundTripSerializesEquallyFrom(emptyJson, ConfigResponse.builder().build());
        this.assertRoundTripSerializesEquallyFrom(emptyJson, ConfigResponse.builder().withOverrides((Map)ImmutableMap.of()).withDefaults((Map)ImmutableMap.of()).build());
    }

    @Test
    public void testCanDeserializeWithoutDefaultValues() throws JsonProcessingException {
        ConfigResponse noOverrides = ConfigResponse.builder().withDefaults(DEFAULTS).build();
        String jsonMissingOverrides = "{\"defaults\":{\"warehouse\":\"s3://bucket/warehouse\"}}";
        this.assertEquals(this.deserialize(jsonMissingOverrides), noOverrides);
        String jsonNullOverrides = "{\"defaults\":{\"warehouse\":\"s3://bucket/warehouse\"},\"overrides\":null}";
        this.assertEquals(this.deserialize(jsonNullOverrides), noOverrides);
        ConfigResponse noDefaults = ConfigResponse.builder().withOverrides(OVERRIDES).build();
        String jsonMissingDefaults = "{\"overrides\":{\"clients\":\"5\"}}";
        this.assertEquals(this.deserialize(jsonMissingDefaults), noDefaults);
        String jsonNullDefaults = "{\"defaults\":null,\"overrides\":{\"clients\":\"5\"}}";
        this.assertEquals(this.deserialize(jsonNullDefaults), noDefaults);
        ConfigResponse noValues = ConfigResponse.builder().build();
        String jsonEmptyObject = "{}";
        this.assertEquals(this.deserialize(jsonEmptyObject), noValues);
        String jsonNullForAllFields = "{\"defaults\":null,\"overrides\":null}";
        this.assertEquals(this.deserialize(jsonNullForAllFields), noValues);
    }

    @Test
    public void testCanUseNullAsPropertyValue() throws JsonProcessingException {
        String jsonNullValueInDefaults = "{\"defaults\":{\"warehouse\":null},\"overrides\":{\"clients\":\"5\"}}";
        this.assertRoundTripSerializesEquallyFrom(jsonNullValueInDefaults, ConfigResponse.builder().withDefaults(DEFAULTS_WITH_NULL_VALUE).withOverrides(OVERRIDES).build());
        this.assertRoundTripSerializesEquallyFrom(jsonNullValueInDefaults, ConfigResponse.builder().withDefault("warehouse", null).withOverrides(OVERRIDES).build());
        String jsonNullValueInOverrides = "{\"defaults\":{\"warehouse\":\"s3://bucket/warehouse\"},\"overrides\":{\"clients\":null}}";
        this.assertRoundTripSerializesEquallyFrom(jsonNullValueInOverrides, ConfigResponse.builder().withDefaults(DEFAULTS).withOverrides(OVERRIDES_WITH_NULL_VALUE).build());
        this.assertRoundTripSerializesEquallyFrom(jsonNullValueInOverrides, ConfigResponse.builder().withDefaults(DEFAULTS).withOverride("clients", null).build());
    }

    @Test
    public void testDeserializeInvalidResponse() {
        String jsonDefaultsHasWrongType = "{\"defaults\":[\"warehouse\",\"s3://bucket/warehouse\"],\"overrides\":{\"clients\":\"5\"}}";
        AssertHelpers.assertThrows((String)"A JSON response with the wrong type for the defaults field should fail to deserialize", JsonProcessingException.class, () -> this.deserialize(jsonDefaultsHasWrongType));
        String jsonOverridesHasWrongType = "{\"defaults\":{\"warehouse\":\"s3://bucket/warehouse\"},\"overrides\":\"clients\"}";
        AssertHelpers.assertThrows((String)"A JSON response with the wrong type for the overrides field should fail to deserialize", JsonProcessingException.class, () -> this.deserialize(jsonOverridesHasWrongType));
        AssertHelpers.assertThrows((String)"A null JSON response body should fail to deserialize", IllegalArgumentException.class, () -> this.deserialize(null));
    }

    @Test
    public void testBuilderDoesNotCreateInvalidObjects() {
        AssertHelpers.assertThrows((String)"The builder should not allow using null as a key in the properties to override", NullPointerException.class, (String)"Invalid override property: null", () -> ConfigResponse.builder().withOverride(null, "100").build());
        AssertHelpers.assertThrows((String)"The builder should not allow using null as a key in the default properties", NullPointerException.class, (String)"Invalid default property: null", () -> ConfigResponse.builder().withDefault(null, "100").build());
        AssertHelpers.assertThrows((String)"The builder should not allow passing a null map of config properties to override", NullPointerException.class, (String)"Invalid override properties map: null", () -> ConfigResponse.builder().withOverrides(null).build());
        AssertHelpers.assertThrows((String)"The builder should not allow passing a null map of default config properties", NullPointerException.class, (String)"Invalid default properties map: null", () -> ConfigResponse.builder().withDefaults(null).build());
        HashMap mapWithNullKey = Maps.newHashMap();
        mapWithNullKey.put(null, "a");
        mapWithNullKey.put("b", "b");
        AssertHelpers.assertThrows((String)"The builder should not allow passing a map of default config properties with a null key", IllegalArgumentException.class, (String)"Invalid default property: null", () -> ConfigResponse.builder().withDefaults(mapWithNullKey).build());
        AssertHelpers.assertThrows((String)"The builder should not allow passing a map of properties to override with a null key", IllegalArgumentException.class, (String)"Invalid override property: null", () -> ConfigResponse.builder().withOverrides(mapWithNullKey).build());
    }

    @Test
    public void testMergeStripsNullValuedEntries() {
        HashMap mapWithNullValue = Maps.newHashMap();
        mapWithNullValue.put("a", null);
        mapWithNullValue.put("b", "from_overrides");
        HashMap overrides = mapWithNullValue;
        ImmutableMap defaults = ImmutableMap.of((Object)"a", (Object)"from_defaults");
        ImmutableMap clientConfig = ImmutableMap.of((Object)"a", (Object)"from_client", (Object)"c", (Object)"from_client");
        ConfigResponse resp = ConfigResponse.builder().withOverrides((Map)overrides).withDefaults((Map)defaults).build();
        Map merged = resp.merge((Map)clientConfig);
        ImmutableMap expected = ImmutableMap.of((Object)"b", (Object)"from_overrides", (Object)"c", (Object)"from_client");
        Assert.assertEquals((String)"The merged properties map should use values from defaults, then client config, and finally overrides", (Object)expected, (Object)merged);
        Assert.assertFalse((String)"The merged properties map should omit keys with null values", (boolean)merged.containsValue(null));
    }

    @Override
    public String[] allFieldsFromSpec() {
        return new String[]{"defaults", "overrides"};
    }

    @Override
    public ConfigResponse createExampleInstance() {
        return ConfigResponse.builder().withDefaults(DEFAULTS).withOverrides(OVERRIDES).build();
    }

    @Override
    public void assertEquals(ConfigResponse actual, ConfigResponse expected) {
        Assert.assertEquals((String)"Config properties to use as defaults should be equal", (Object)actual.defaults(), (Object)expected.defaults());
        Assert.assertEquals((String)"Config properties to use as overrides should be equal", (Object)actual.overrides(), (Object)expected.overrides());
    }

    @Override
    public ConfigResponse deserialize(String json) throws JsonProcessingException {
        ConfigResponse resp = (ConfigResponse)TestConfigResponse.mapper().readValue(json, ConfigResponse.class);
        resp.validate();
        return resp;
    }
}

