/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import java.util.Arrays;
import java.util.List;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.rest.responses.ErrorResponseParser;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestCatalogErrorResponseParser {
    @Test
    public void testErrorResponseToJson() {
        String message = "The given namespace does not exist";
        String type = "NoSuchNamespaceException";
        Integer code = 404;
        String errorModelJson = String.format("{\"message\":\"%s\",\"type\":\"%s\",\"code\":%d}", message, type, code);
        String json = "{\"error\":" + errorModelJson + "}";
        ErrorResponse response = ErrorResponse.builder().withMessage(message).withType(type).responseCode(code).build();
        Assert.assertEquals((String)"Should be able to serialize an error response as json", (Object)ErrorResponseParser.toJson((ErrorResponse)response), (Object)json);
    }

    @Test
    public void testErrorResponseToJsonWithStack() {
        String message = "The given namespace does not exist";
        String type = "NoSuchNamespaceException";
        Integer code = 404;
        List<String> stack = Arrays.asList("a", "b");
        String errorModelJson = String.format("{\"message\":\"%s\",\"type\":\"%s\",\"code\":%d,\"stack\":[\"a\",\"b\"]}", message, type, code);
        String json = "{\"error\":" + errorModelJson + "}";
        ErrorResponse response = ErrorResponse.builder().withMessage(message).withType(type).responseCode(code).withStackTrace(stack).build();
        Assert.assertEquals((String)"Should be able to serialize an error response as json", (Object)json, (Object)ErrorResponseParser.toJson((ErrorResponse)response));
    }

    @Test
    public void testErrorResponseFromJson() {
        String message = "The given namespace does not exist";
        String type = "NoSuchNamespaceException";
        Integer code = 404;
        String errorModelJson = String.format("{\"message\":\"%s\",\"type\":\"%s\",\"code\":%d}", message, type, code);
        String json = "{\"error\":" + errorModelJson + "}";
        ErrorResponse expected = ErrorResponse.builder().withMessage(message).withType(type).responseCode(code).build();
        this.assertEquals(expected, ErrorResponseParser.fromJson((String)json));
    }

    @Test
    public void testErrorResponseFromJsonWithStack() {
        String message = "The given namespace does not exist";
        String type = "NoSuchNamespaceException";
        Integer code = 404;
        List<String> stack = Arrays.asList("a", "b");
        String errorModelJson = String.format("{\"message\":\"%s\",\"type\":\"%s\",\"code\":%d,\"stack\":[\"a\",\"b\"]}", message, type, code);
        String json = "{\"error\":" + errorModelJson + "}";
        ErrorResponse expected = ErrorResponse.builder().withMessage(message).withType(type).responseCode(code).withStackTrace(stack).build();
        this.assertEquals(expected, ErrorResponseParser.fromJson((String)json));
    }

    @Test
    public void testErrorResponseFromJsonWithExplicitNullStack() {
        String message = "The given namespace does not exist";
        String type = "NoSuchNamespaceException";
        Integer code = 404;
        List stack = null;
        String errorModelJson = String.format("{\"message\":\"%s\",\"type\":\"%s\",\"code\":%d,\"stack\":null}", message, type, code);
        String json = "{\"error\":" + errorModelJson + "}";
        ErrorResponse expected = ErrorResponse.builder().withMessage(message).withType(type).responseCode(code).withStackTrace(stack).build();
        this.assertEquals(expected, ErrorResponseParser.fromJson((String)json));
    }

    public void assertEquals(ErrorResponse expected, ErrorResponse actual) {
        Assertions.assertThat((String)actual.message()).isEqualTo(expected.message());
        Assertions.assertThat((String)actual.type()).isEqualTo(expected.type());
        Assertions.assertThat((Integer)actual.code()).isEqualTo((Object)expected.code());
        Assertions.assertThat((List)actual.stack()).isEqualTo((Object)expected.stack());
    }
}

