/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.requests;

import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.rest.requests.UpdateRequirementParser;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assert;
import org.junit.Test;

public class TestUpdateRequirementParser {
    @Test
    public void testUpdateRequirementWithoutRequirementTypeCannotParse() {
        ImmutableList invalidJson = ImmutableList.of((Object)"{\"type\":null,\"uuid\":\"2cc52516-5e73-41f2-b139-545d41a4e151\"}", (Object)"{\"uuid\":\"2cc52516-5e73-41f2-b139-545d41a4e151\"}");
        for (String json : invalidJson) {
            AssertHelpers.assertThrows((String)"UpdateRequirement without a recognized requirement type should fail to deserialize", IllegalArgumentException.class, (String)"Cannot parse update requirement. Missing field: type", () -> UpdateRequirementParser.fromJson((String)json));
        }
    }

    @Test
    public void testAssertUUIDFromJson() {
        String requirementType = "assert-table-uuid";
        String uuid = "2cc52516-5e73-41f2-b139-545d41a4e151";
        String json = String.format("{\"type\":\"assert-table-uuid\",\"uuid\":\"%s\"}", uuid);
        UpdateTableRequest.UpdateRequirement.AssertTableUUID expected = new UpdateTableRequest.UpdateRequirement.AssertTableUUID(uuid);
        this.assertEquals(requirementType, (UpdateTableRequest.UpdateRequirement)expected, UpdateRequirementParser.fromJson((String)json));
    }

    @Test
    public void testAssertUUIDToJson() {
        String uuid = "2cc52516-5e73-41f2-b139-545d41a4e151";
        String expected = String.format("{\"type\":\"assert-table-uuid\",\"uuid\":\"%s\"}", uuid);
        UpdateTableRequest.UpdateRequirement.AssertTableUUID actual = new UpdateTableRequest.UpdateRequirement.AssertTableUUID(uuid);
        Assert.assertEquals((String)"AssertTableUUID should convert to the correct JSON value", (Object)expected, (Object)UpdateRequirementParser.toJson((UpdateTableRequest.UpdateRequirement)actual));
    }

    @Test
    public void testAssertTableDoesNotExistFromJson() {
        String requirementType = "assert-create";
        String json = "{\"type\":\"assert-create\"}";
        UpdateTableRequest.UpdateRequirement.AssertTableDoesNotExist expected = new UpdateTableRequest.UpdateRequirement.AssertTableDoesNotExist();
        this.assertEquals(requirementType, (UpdateTableRequest.UpdateRequirement)expected, UpdateRequirementParser.fromJson((String)json));
    }

    @Test
    public void testAssertTableDoesNotExistToJson() {
        String expected = "{\"type\":\"assert-create\"}";
        UpdateTableRequest.UpdateRequirement.AssertTableDoesNotExist actual = new UpdateTableRequest.UpdateRequirement.AssertTableDoesNotExist();
        Assert.assertEquals((String)"AssertTableDoesNotExist should convert to the correct JSON value", (Object)expected, (Object)UpdateRequirementParser.toJson((UpdateTableRequest.UpdateRequirement)actual));
    }

    @Test
    public void testAssertRefSnapshotIdToJson() {
        String requirementType = "assert-ref-snapshot-id";
        String refName = "snapshot-name";
        Long snapshotId = 1L;
        String json = String.format("{\"type\":\"%s\",\"ref\":\"%s\",\"snapshot-id\":%d}", requirementType, refName, snapshotId);
        UpdateTableRequest.UpdateRequirement.AssertRefSnapshotID expected = new UpdateTableRequest.UpdateRequirement.AssertRefSnapshotID(refName, snapshotId);
        this.assertEquals(requirementType, (UpdateTableRequest.UpdateRequirement)expected, UpdateRequirementParser.fromJson((String)json));
    }

    @Test
    public void testAssertRefSnapshotIdToJsonWithNullSnapshotId() {
        String requirementType = "assert-ref-snapshot-id";
        String refName = "snapshot-name";
        Long snapshotId = null;
        String json = String.format("{\"type\":\"%s\",\"ref\":\"%s\",\"snapshot-id\":%d}", requirementType, refName, snapshotId);
        UpdateTableRequest.UpdateRequirement.AssertRefSnapshotID expected = new UpdateTableRequest.UpdateRequirement.AssertRefSnapshotID(refName, snapshotId);
        this.assertEquals(requirementType, (UpdateTableRequest.UpdateRequirement)expected, UpdateRequirementParser.fromJson((String)json));
    }

    @Test
    public void testAssertRefSnapshotIdFromJson() {
        String requirementType = "assert-ref-snapshot-id";
        String refName = "snapshot-name";
        Long snapshotId = 1L;
        String expected = String.format("{\"type\":\"%s\",\"ref\":\"%s\",\"snapshot-id\":%d}", requirementType, refName, snapshotId);
        UpdateTableRequest.UpdateRequirement.AssertRefSnapshotID actual = new UpdateTableRequest.UpdateRequirement.AssertRefSnapshotID(refName, snapshotId);
        Assert.assertEquals((String)"AssertRefSnapshotId should convert to the correct JSON value", (Object)expected, (Object)UpdateRequirementParser.toJson((UpdateTableRequest.UpdateRequirement)actual));
    }

    @Test
    public void testAssertRefSnapshotIdFromJsonWithNullSnapshotId() {
        String requirementType = "assert-ref-snapshot-id";
        String refName = "snapshot-name";
        Long snapshotId = null;
        String expected = String.format("{\"type\":\"%s\",\"ref\":\"%s\",\"snapshot-id\":%d}", requirementType, refName, snapshotId);
        UpdateTableRequest.UpdateRequirement.AssertRefSnapshotID actual = new UpdateTableRequest.UpdateRequirement.AssertRefSnapshotID(refName, snapshotId);
        Assert.assertEquals((String)"AssertRefSnapshotId should convert to the correct JSON value", (Object)expected, (Object)UpdateRequirementParser.toJson((UpdateTableRequest.UpdateRequirement)actual));
    }

    @Test
    public void testAssertLastAssignedFieldIdFromJson() {
        String requirementType = "assert-last-assigned-field-id";
        int lastAssignedFieldId = 12;
        String json = String.format("{\"type\":\"%s\",\"last-assigned-field-id\":%d}", requirementType, lastAssignedFieldId);
        UpdateTableRequest.UpdateRequirement.AssertLastAssignedFieldId expected = new UpdateTableRequest.UpdateRequirement.AssertLastAssignedFieldId(lastAssignedFieldId);
        this.assertEquals(requirementType, (UpdateTableRequest.UpdateRequirement)expected, UpdateRequirementParser.fromJson((String)json));
    }

    @Test
    public void testAssertLastAssignedFieldIdToJson() {
        String requirementType = "assert-last-assigned-field-id";
        int lastAssignedFieldId = 12;
        String expected = String.format("{\"type\":\"%s\",\"last-assigned-field-id\":%d}", requirementType, lastAssignedFieldId);
        UpdateTableRequest.UpdateRequirement.AssertLastAssignedFieldId actual = new UpdateTableRequest.UpdateRequirement.AssertLastAssignedFieldId(lastAssignedFieldId);
        Assert.assertEquals((String)"AssertLastAssignedFieldId should convert to the correct JSON value", (Object)expected, (Object)UpdateRequirementParser.toJson((UpdateTableRequest.UpdateRequirement)actual));
    }

    @Test
    public void testAssertCurrentSchemaIdFromJson() {
        String requirementType = "assert-current-schema-id";
        int schemaId = 4;
        String json = String.format("{\"type\":\"%s\",\"current-schema-id\":%d}", requirementType, schemaId);
        UpdateTableRequest.UpdateRequirement.AssertCurrentSchemaID expected = new UpdateTableRequest.UpdateRequirement.AssertCurrentSchemaID(schemaId);
        this.assertEquals(requirementType, (UpdateTableRequest.UpdateRequirement)expected, UpdateRequirementParser.fromJson((String)json));
    }

    @Test
    public void testAssertCurrentSchemaIdToJson() {
        String requirementType = "assert-current-schema-id";
        int schemaId = 4;
        String expected = String.format("{\"type\":\"%s\",\"current-schema-id\":%d}", requirementType, schemaId);
        UpdateTableRequest.UpdateRequirement.AssertCurrentSchemaID actual = new UpdateTableRequest.UpdateRequirement.AssertCurrentSchemaID(schemaId);
        Assert.assertEquals((String)"AssertCurrentSchemaId should convert to the correct JSON value", (Object)expected, (Object)UpdateRequirementParser.toJson((UpdateTableRequest.UpdateRequirement)actual));
    }

    @Test
    public void testAssertLastAssignedPartitionIdFromJson() {
        String requirementType = "assert-last-assigned-partition-id";
        int lastAssignedPartitionId = 1004;
        String json = String.format("{\"type\":\"%s\",\"last-assigned-partition-id\":%d}", requirementType, lastAssignedPartitionId);
        UpdateTableRequest.UpdateRequirement.AssertLastAssignedPartitionId expected = new UpdateTableRequest.UpdateRequirement.AssertLastAssignedPartitionId(lastAssignedPartitionId);
        this.assertEquals(requirementType, (UpdateTableRequest.UpdateRequirement)expected, UpdateRequirementParser.fromJson((String)json));
    }

    @Test
    public void testAssertLastAssignedPartitionIdToJson() {
        String requirementType = "assert-last-assigned-partition-id";
        int lastAssignedPartitionId = 1004;
        String expected = String.format("{\"type\":\"%s\",\"last-assigned-partition-id\":%d}", requirementType, lastAssignedPartitionId);
        UpdateTableRequest.UpdateRequirement.AssertLastAssignedPartitionId actual = new UpdateTableRequest.UpdateRequirement.AssertLastAssignedPartitionId(lastAssignedPartitionId);
        Assert.assertEquals((String)"AssertLastAssignedPartitionId should convert to the correct JSON value", (Object)expected, (Object)UpdateRequirementParser.toJson((UpdateTableRequest.UpdateRequirement)actual));
    }

    @Test
    public void testAssertDefaultSpecIdFromJson() {
        String requirementType = "assert-default-spec-id";
        int specId = 5;
        String json = String.format("{\"type\":\"%s\",\"default-spec-id\":%d}", requirementType, specId);
        UpdateTableRequest.UpdateRequirement.AssertDefaultSpecID expected = new UpdateTableRequest.UpdateRequirement.AssertDefaultSpecID(specId);
        this.assertEquals(requirementType, (UpdateTableRequest.UpdateRequirement)expected, UpdateRequirementParser.fromJson((String)json));
    }

    @Test
    public void testAssertDefaultSpecIdToJson() {
        String requirementType = "assert-default-spec-id";
        int specId = 5;
        String expected = String.format("{\"type\":\"%s\",\"default-spec-id\":%d}", requirementType, specId);
        UpdateTableRequest.UpdateRequirement.AssertDefaultSpecID actual = new UpdateTableRequest.UpdateRequirement.AssertDefaultSpecID(specId);
        Assert.assertEquals((String)"AssertDefaultSpecId should convert to the correct JSON value", (Object)expected, (Object)UpdateRequirementParser.toJson((UpdateTableRequest.UpdateRequirement)actual));
    }

    @Test
    public void testAssertDefaultSortOrderIdFromJson() {
        String requirementType = "assert-default-sort-order-id";
        int sortOrderId = 10;
        String json = String.format("{\"type\":\"%s\",\"default-sort-order-id\":%d}", requirementType, sortOrderId);
        UpdateTableRequest.UpdateRequirement.AssertDefaultSortOrderID expected = new UpdateTableRequest.UpdateRequirement.AssertDefaultSortOrderID(sortOrderId);
        this.assertEquals(requirementType, (UpdateTableRequest.UpdateRequirement)expected, UpdateRequirementParser.fromJson((String)json));
    }

    @Test
    public void testAssertDefaultSortOrderIdToJson() {
        String requirementType = "assert-default-sort-order-id";
        int sortOrderId = 10;
        String expected = String.format("{\"type\":\"%s\",\"default-sort-order-id\":%d}", requirementType, sortOrderId);
        UpdateTableRequest.UpdateRequirement.AssertDefaultSortOrderID actual = new UpdateTableRequest.UpdateRequirement.AssertDefaultSortOrderID(sortOrderId);
        Assert.assertEquals((String)"AssertDefaultSortOrderId should convert to the correct JSON value", (Object)expected, (Object)UpdateRequirementParser.toJson((UpdateTableRequest.UpdateRequirement)actual));
    }

    public void assertEquals(String requirementType, UpdateTableRequest.UpdateRequirement expected, UpdateTableRequest.UpdateRequirement actual) {
        switch (requirementType) {
            case "assert-table-uuid": {
                TestUpdateRequirementParser.compareAssertTableUUID((UpdateTableRequest.UpdateRequirement.AssertTableUUID)expected, (UpdateTableRequest.UpdateRequirement.AssertTableUUID)actual);
                break;
            }
            case "assert-create": {
                TestUpdateRequirementParser.compareAssertTableDoesNotExist(expected, actual);
                break;
            }
            case "assert-ref-snapshot-id": {
                TestUpdateRequirementParser.compareAssertRefSnapshotId((UpdateTableRequest.UpdateRequirement.AssertRefSnapshotID)expected, (UpdateTableRequest.UpdateRequirement.AssertRefSnapshotID)actual);
                break;
            }
            case "assert-last-assigned-field-id": {
                TestUpdateRequirementParser.compareAssertLastAssignedFieldId((UpdateTableRequest.UpdateRequirement.AssertLastAssignedFieldId)expected, (UpdateTableRequest.UpdateRequirement.AssertLastAssignedFieldId)actual);
                break;
            }
            case "assert-current-schema-id": {
                TestUpdateRequirementParser.compareAssertCurrentSchemaId((UpdateTableRequest.UpdateRequirement.AssertCurrentSchemaID)expected, (UpdateTableRequest.UpdateRequirement.AssertCurrentSchemaID)actual);
                break;
            }
            case "assert-last-assigned-partition-id": {
                TestUpdateRequirementParser.compareAssertLastAssignedPartitionId((UpdateTableRequest.UpdateRequirement.AssertLastAssignedPartitionId)expected, (UpdateTableRequest.UpdateRequirement.AssertLastAssignedPartitionId)actual);
                break;
            }
            case "assert-default-spec-id": {
                TestUpdateRequirementParser.compareAssertDefaultSpecId((UpdateTableRequest.UpdateRequirement.AssertDefaultSpecID)expected, (UpdateTableRequest.UpdateRequirement.AssertDefaultSpecID)actual);
                break;
            }
            case "assert-default-sort-order-id": {
                TestUpdateRequirementParser.compareAssertDefaultSortOrderId((UpdateTableRequest.UpdateRequirement.AssertDefaultSortOrderID)expected, (UpdateTableRequest.UpdateRequirement.AssertDefaultSortOrderID)actual);
                break;
            }
            default: {
                Assert.fail((String)("Unrecognized update requirement type: " + requirementType));
            }
        }
    }

    private static void compareAssertTableUUID(UpdateTableRequest.UpdateRequirement.AssertTableUUID expected, UpdateTableRequest.UpdateRequirement.AssertTableUUID actual) {
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)actual.uuid()).as("UUID from JSON should not be null", new Object[0])).isNotNull()).as("UUID should parse correctly from JSON", new Object[0])).isEqualTo(expected.uuid());
    }

    private static void compareAssertTableDoesNotExist(UpdateTableRequest.UpdateRequirement expected, UpdateTableRequest.UpdateRequirement actual) {
        ((ObjectAssert)Assertions.assertThat((Object)actual).isOfAnyClassIn(new Class[]{UpdateTableRequest.UpdateRequirement.AssertTableDoesNotExist.class})).hasSameClassAs((Object)expected);
    }

    private static void compareAssertRefSnapshotId(UpdateTableRequest.UpdateRequirement.AssertRefSnapshotID expected, UpdateTableRequest.UpdateRequirement.AssertRefSnapshotID actual) {
        ((AbstractStringAssert)Assertions.assertThat((String)actual.refName()).as("Ref name should parse correctly from JSON", new Object[0])).isEqualTo(expected.refName());
        ((AbstractLongAssert)Assertions.assertThat((Long)actual.snapshotId()).as("Snapshot ID should parse correctly from JSON", new Object[0])).isEqualTo((Object)expected.snapshotId());
    }

    private static void compareAssertLastAssignedFieldId(UpdateTableRequest.UpdateRequirement.AssertLastAssignedFieldId expected, UpdateTableRequest.UpdateRequirement.AssertLastAssignedFieldId actual) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)actual.lastAssignedFieldId()).as("Last assigned field id should parse correctly from JSON", new Object[0])).isEqualTo(expected.lastAssignedFieldId());
    }

    private static void compareAssertCurrentSchemaId(UpdateTableRequest.UpdateRequirement.AssertCurrentSchemaID expected, UpdateTableRequest.UpdateRequirement.AssertCurrentSchemaID actual) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)actual.schemaId()).as("Current schema id should parse correctly from JSON", new Object[0])).isEqualTo(expected.schemaId());
    }

    private static void compareAssertLastAssignedPartitionId(UpdateTableRequest.UpdateRequirement.AssertLastAssignedPartitionId expected, UpdateTableRequest.UpdateRequirement.AssertLastAssignedPartitionId actual) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)actual.lastAssignedPartitionId()).as("Last assigned partition id should parse correctly from JSON", new Object[0])).isEqualTo(expected.lastAssignedPartitionId());
    }

    private static void compareAssertDefaultSpecId(UpdateTableRequest.UpdateRequirement.AssertDefaultSpecID expected, UpdateTableRequest.UpdateRequirement.AssertDefaultSpecID actual) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)actual.specId()).as("Default spec id should parse correctly from JSON", new Object[0])).isEqualTo(expected.specId());
    }

    private static void compareAssertDefaultSortOrderId(UpdateTableRequest.UpdateRequirement.AssertDefaultSortOrderID expected, UpdateTableRequest.UpdateRequirement.AssertDefaultSortOrderID actual) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)actual.sortOrderId()).as("Default sort order id should parse correctly from JSON", new Object[0])).isEqualTo(expected.sortOrderId());
    }
}

