/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.requests;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.rest.RequestResponseTestBase;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.junit.Assert;
import org.junit.Test;

public class TestUpdateNamespacePropertiesRequest
extends RequestResponseTestBase<UpdateNamespacePropertiesRequest> {
    private static final Map<String, String> UPDATES = ImmutableMap.of((Object)"owner", (Object)"Hank");
    private static final List<String> REMOVALS = ImmutableList.of((Object)"foo", (Object)"bar");
    private static final Map<String, String> EMPTY_UPDATES = ImmutableMap.of();
    private static final List<String> EMPTY_REMOVALS = ImmutableList.of();

    @Test
    public void testRoundTripSerDe() throws JsonProcessingException {
        String fullJson = "{\"removals\":[\"foo\",\"bar\"],\"updates\":{\"owner\":\"Hank\"}}";
        this.assertRoundTripSerializesEquallyFrom(fullJson, UpdateNamespacePropertiesRequest.builder().updateAll(UPDATES).removeAll(REMOVALS).build());
        String emptyRemoval = "{\"removals\":[],\"updates\":{\"owner\":\"Hank\"}}";
        this.assertRoundTripSerializesEquallyFrom(emptyRemoval, UpdateNamespacePropertiesRequest.builder().updateAll(UPDATES).removeAll(EMPTY_REMOVALS).build());
        this.assertRoundTripSerializesEquallyFrom(emptyRemoval, UpdateNamespacePropertiesRequest.builder().update("owner", "Hank").build());
        String emptyUpdates = "{\"removals\":[\"foo\",\"bar\"],\"updates\":{}}";
        this.assertRoundTripSerializesEquallyFrom(emptyUpdates, UpdateNamespacePropertiesRequest.builder().removeAll(REMOVALS).updateAll(EMPTY_UPDATES).build());
        this.assertRoundTripSerializesEquallyFrom(emptyUpdates, UpdateNamespacePropertiesRequest.builder().remove("foo").remove("bar").build());
        String jsonAllFieldsEmpty = "{\"removals\":[],\"updates\":{}}";
        this.assertRoundTripSerializesEquallyFrom(jsonAllFieldsEmpty, UpdateNamespacePropertiesRequest.builder().build());
    }

    @Test
    public void testCanDeserializeWithoutDefaultValues() throws JsonProcessingException {
        UpdateNamespacePropertiesRequest noRemovals = UpdateNamespacePropertiesRequest.builder().updateAll(UPDATES).build();
        String jsonWithNullRemovals = "{\"removals\":null,\"updates\":{\"owner\":\"Hank\"}}";
        UpdateNamespacePropertiesRequest parsed = this.deserialize(jsonWithNullRemovals);
        this.assertEquals(parsed, noRemovals);
        String jsonWithMissingRemovals = "{\"updates\":{\"owner\":\"Hank\"}}";
        this.assertEquals(this.deserialize(jsonWithMissingRemovals), noRemovals);
        UpdateNamespacePropertiesRequest noUpdates = UpdateNamespacePropertiesRequest.builder().removeAll(REMOVALS).build();
        String jsonWithNullUpdates = "{\"removals\":[\"foo\",\"bar\"],\"updates\":null}";
        this.assertEquals(this.deserialize(jsonWithNullUpdates), noUpdates);
        String jsonWithMissingUpdates = "{\"removals\":[\"foo\",\"bar\"]}";
        this.assertEquals(this.deserialize(jsonWithMissingUpdates), noUpdates);
        UpdateNamespacePropertiesRequest allMissing = UpdateNamespacePropertiesRequest.builder().build();
        String jsonAllNull = "{\"removals\":null,\"updates\":null}";
        this.assertEquals(this.deserialize(jsonAllNull), allMissing);
        String jsonAllMissing = "{}";
        this.assertEquals(this.deserialize(jsonAllMissing), allMissing);
    }

    @Test
    public void testParseInvalidJson() {
        String jsonInvalidTypeOnRemovalField = "{\"removals\":{\"foo\":\"bar\"},\"updates\":{\"owner\":\"Hank\"}}";
        AssertHelpers.assertThrows((String)"A JSON request with an invalid type for one of the fields should fail to parse", JsonProcessingException.class, () -> this.deserialize(jsonInvalidTypeOnRemovalField));
        String jsonInvalidTypeOnUpdatesField = "{\"removals\":[\"foo\":\"bar\"],\"updates\":[\"owner\"]}";
        AssertHelpers.assertThrows((String)"A JSON value with an invalid type for one of the fields should fail to parse", JsonProcessingException.class, () -> this.deserialize(jsonInvalidTypeOnUpdatesField));
        String invalidJsonWrongTypeInRemovalsList = "{\"removals\":[\"foo\",\"bar\", {\"owner\": \"Hank\"}],\"updates\":{\"owner\":\"Hank\"}}";
        AssertHelpers.assertThrows((String)"A JSON value with an invalid type inside one of the list fields should fail to parse", JsonProcessingException.class, () -> this.deserialize(invalidJsonWrongTypeInRemovalsList));
        String nullJson = null;
        AssertHelpers.assertThrows((String)"A null JSON should fail to parse", IllegalArgumentException.class, (String)"argument \"content\" is null", () -> this.deserialize(nullJson));
    }

    @Test
    public void testBuilderDoesNotCreateInvalidObjects() {
        AssertHelpers.assertThrows((String)"The builder should not allow using null as a key to remove", NullPointerException.class, (String)"Invalid property to remove: null", () -> UpdateNamespacePropertiesRequest.builder().remove(null).build());
        AssertHelpers.assertThrows((String)"The builder should not allow passing a null list of properties to remove", NullPointerException.class, (String)"Invalid list of properties to remove: null", () -> UpdateNamespacePropertiesRequest.builder().removeAll(null).build());
        ArrayList listWithNull = Lists.newArrayList((Object[])new String[]{"a", null, null});
        AssertHelpers.assertThrows((String)"The builder should not allow passing a list of properties to remove with a null element", IllegalArgumentException.class, (String)"Invalid property to remove: null", () -> UpdateNamespacePropertiesRequest.builder().removeAll((Collection)listWithNull).build());
        AssertHelpers.assertThrows((String)"The builder should not allow using null as a key to update", NullPointerException.class, (String)"Invalid property to update: null", () -> UpdateNamespacePropertiesRequest.builder().update(null, "100").build());
        AssertHelpers.assertThrows((String)"The builder should not allow using null as a value to update", NullPointerException.class, (String)"Invalid value to update for key [owner]: null. Use remove instead", () -> UpdateNamespacePropertiesRequest.builder().update("owner", null).build());
        AssertHelpers.assertThrows((String)"The builder should not allow passing a null collection of properties to update", NullPointerException.class, (String)"Invalid collection of properties to update: null", () -> UpdateNamespacePropertiesRequest.builder().updateAll(null).build());
        HashMap mapWithNullKey = Maps.newHashMap();
        mapWithNullKey.put(null, "hello");
        AssertHelpers.assertThrows((String)"The builder should not allow using null as a key to update from a collection of updates", IllegalArgumentException.class, (String)"Invalid property to update: null", () -> UpdateNamespacePropertiesRequest.builder().updateAll(mapWithNullKey).build());
        HashMap mapWithMultipleNullValues = Maps.newHashMap();
        mapWithMultipleNullValues.put("a", null);
        mapWithMultipleNullValues.put("b", "b");
        AssertHelpers.assertThrows((String)"The builder should not allow using null as a value to update from a collection of updates", IllegalArgumentException.class, (String)"Invalid value to update for properties [a]: null. Use remove instead", () -> UpdateNamespacePropertiesRequest.builder().updateAll(mapWithMultipleNullValues).build());
    }

    @Override
    public String[] allFieldsFromSpec() {
        return new String[]{"updates", "removals"};
    }

    @Override
    public UpdateNamespacePropertiesRequest createExampleInstance() {
        return UpdateNamespacePropertiesRequest.builder().updateAll(UPDATES).removeAll(REMOVALS).build();
    }

    @Override
    public void assertEquals(UpdateNamespacePropertiesRequest actual, UpdateNamespacePropertiesRequest expected) {
        Assert.assertEquals((String)"Properties to update should be equal", (Object)actual.updates(), (Object)expected.updates());
        Assert.assertEquals((String)"Properties to remove should be equal", (Object)Sets.newHashSet((Iterable)actual.removals()), (Object)Sets.newHashSet((Iterable)expected.removals()));
    }

    @Override
    public UpdateNamespacePropertiesRequest deserialize(String json) throws JsonProcessingException {
        UpdateNamespacePropertiesRequest request = (UpdateNamespacePropertiesRequest)TestUpdateNamespacePropertiesRequest.mapper().readValue(json, UpdateNamespacePropertiesRequest.class);
        request.validate();
        return request;
    }
}

