/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.requests;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.metrics.CommitMetrics;
import org.apache.iceberg.metrics.CommitMetricsResult;
import org.apache.iceberg.metrics.ImmutableCommitReport;
import org.apache.iceberg.metrics.ImmutableScanReport;
import org.apache.iceberg.metrics.MetricsReport;
import org.apache.iceberg.metrics.ScanMetrics;
import org.apache.iceberg.metrics.ScanMetricsResult;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.rest.requests.ReportMetricsRequest;
import org.apache.iceberg.rest.requests.ReportMetricsRequestParser;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestReportMetricsRequestParser {
    @Test
    public void nullCheck() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ReportMetricsRequestParser.toJson(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid metrics request: null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ReportMetricsRequestParser.fromJson((JsonNode)null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse metrics request from null object");
    }

    @Test
    public void missingFields() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ReportMetricsRequestParser.fromJson((String)"{}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing string: report-type");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ReportMetricsRequestParser.fromJson((String)"{\"report-type\":\"scan-report\"}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing string: table-name");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ReportMetricsRequestParser.fromJson((String)"{\"report-type\":\"scan-report\", \"table-name\" : \"x\"}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing long: snapshot-id");
    }

    @Test
    public void invalidReportType() {
        Assertions.assertThat((Comparable)ReportMetricsRequestParser.fromJson((String)"{\"report-type\":\"invalid\"}").reportType()).isEqualTo((Object)ReportMetricsRequest.unknown().reportType());
        Assertions.assertThat((Comparable)ReportMetricsRequestParser.fromJson((String)ReportMetricsRequestParser.toJson((ReportMetricsRequest)ReportMetricsRequest.of((MetricsReport)new MetricsReport(){}))).reportType()).isEqualTo((Object)ReportMetricsRequest.unknown().reportType());
        String json = "{\n  \"report-type\" : \"new-report-type\",\n  \"table-name\" : \"roundTripTableName\",\n  \"snapshot-id\" : 23,\n  \"filter\" : true,\n  \"schema-id\" : 4,\n  \"projected-field-ids\" : [ 1, 2, 3 ],\n  \"projected-field-names\" : [ \"c1\", \"c2\", \"c3\" ],\n  \"metrics\" : { }\n}";
        ReportMetricsRequest request = ReportMetricsRequestParser.fromJson((String)json);
        Assertions.assertThat((Comparable)request.reportType()).isEqualTo((Object)ReportMetricsRequest.unknown().reportType());
    }

    @Test
    public void roundTripSerdeWithScanReport() {
        String tableName = "roundTripTableName";
        ImmutableScanReport scanReport = ImmutableScanReport.builder().tableName(tableName).schemaId(4).addProjectedFieldIds(new int[]{1, 2, 3}).addProjectedFieldNames(new String[]{"c1", "c2", "c3"}).snapshotId(23L).filter((Expression)Expressions.alwaysTrue()).scanMetrics(ScanMetricsResult.fromScanMetrics((ScanMetrics)ScanMetrics.noop())).build();
        String expectedJson = "{\n  \"report-type\" : \"scan-report\",\n  \"table-name\" : \"roundTripTableName\",\n  \"snapshot-id\" : 23,\n  \"filter\" : true,\n  \"schema-id\" : 4,\n  \"projected-field-ids\" : [ 1, 2, 3 ],\n  \"projected-field-names\" : [ \"c1\", \"c2\", \"c3\" ],\n  \"metrics\" : { }\n}";
        ReportMetricsRequest metricsRequest = ReportMetricsRequest.of((MetricsReport)scanReport);
        String json = ReportMetricsRequestParser.toJson((ReportMetricsRequest)metricsRequest, (boolean)true);
        Assertions.assertThat((String)json).isEqualTo(expectedJson);
        Assertions.assertThat((Object)ReportMetricsRequestParser.fromJson((String)json).report()).isEqualTo((Object)metricsRequest.report());
    }

    @Test
    public void roundTripSerdeWithCommitReport() {
        String tableName = "roundTripTableName";
        ImmutableCommitReport commitReport = ImmutableCommitReport.builder().tableName(tableName).snapshotId(23L).sequenceNumber(4L).operation("DELETE").commitMetrics(CommitMetricsResult.from((CommitMetrics)CommitMetrics.noop(), (Map)ImmutableMap.of())).build();
        String expectedJson = "{\n  \"report-type\" : \"commit-report\",\n  \"table-name\" : \"roundTripTableName\",\n  \"snapshot-id\" : 23,\n  \"sequence-number\" : 4,\n  \"operation\" : \"DELETE\",\n  \"metrics\" : { }\n}";
        ReportMetricsRequest metricsRequest = ReportMetricsRequest.of((MetricsReport)commitReport);
        String json = ReportMetricsRequestParser.toJson((ReportMetricsRequest)metricsRequest, (boolean)true);
        Assertions.assertThat((String)json).isEqualTo(expectedJson);
        Assertions.assertThat((Object)ReportMetricsRequestParser.fromJson((String)json).report()).isEqualTo((Object)metricsRequest.report());
    }
}

