/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.requests;

import com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.catalog.TableIdentifierParser;
import org.apache.iceberg.rest.RequestResponseTestBase;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.junit.Assert;
import org.junit.Test;

public class TestRenameTableRequest
extends RequestResponseTestBase<RenameTableRequest> {
    private static final Namespace NAMESPACE = Namespace.of((String[])new String[]{"accounting", "tax"});
    private static final TableIdentifier TAX_PAID = TableIdentifier.of((Namespace)NAMESPACE, (String)"paid");
    private static final TableIdentifier TAX_PAID_RENAMED = TableIdentifier.of((Namespace)NAMESPACE, (String)"paid_2022");

    @Test
    public void testRoundTripSerDe() throws JsonProcessingException {
        String sourceJson = TableIdentifierParser.toJson((TableIdentifier)TAX_PAID);
        String destinationJson = TableIdentifierParser.toJson((TableIdentifier)TAX_PAID_RENAMED);
        String fullJson = String.format("{\"source\":%s,\"destination\":%s}", sourceJson, destinationJson);
        RenameTableRequest req = RenameTableRequest.builder().withSource(TAX_PAID).withDestination(TAX_PAID_RENAMED).build();
        this.assertRoundTripSerializesEquallyFrom(fullJson, req);
    }

    @Test
    public void testDeserializeInvalidRequestThrows() {
        String jsonSourceNullName = "{\"source\":{\"namespace\":[\"accounting\",\"tax\"],\"name\":null},\"destination\":{\"namespace\":[\"accounting\",\"tax\"],\"name\":\"paid_2022\"}}";
        AssertHelpers.assertThrows((String)"A JSON request with an invalid source table identifier, with null for the name, should fail to deserialize", JsonProcessingException.class, (String)"Cannot parse to a string value: name: null", () -> this.deserialize(jsonSourceNullName));
        String jsonDestinationNullName = "{\"source\":{\"namespace\":[\"accounting\",\"tax\"],\"name\":\"paid\"},\"destination\":{\"namespace\":[\"accounting\",\"tax\"],\"name\":null}}";
        AssertHelpers.assertThrows((String)"A JSON request with an invalid destination table, with null for the name, should fail to deserialize", JsonProcessingException.class, (String)"Cannot parse to a string value: name: null", () -> this.deserialize(jsonDestinationNullName));
        String jsonSourceMissingName = "{\"source\":{\"namespace\":[\"accounting\",\"tax\"]},\"destination\":{\"name\":\"paid_2022\"}}";
        AssertHelpers.assertThrows((String)"A JSON request with an invalid source table identifier, with no name, should fail to deserialize", JsonProcessingException.class, (String)"Cannot parse missing string: name", () -> this.deserialize(jsonSourceMissingName));
        String jsonDestinationMissingName = "{\"source\":{\"namespace\":[\"accounting\",\"tax\"],\"name\":\"paid\"},\"destination\":{\"namespace\":[\"accounting\",\"tax\"]}}";
        AssertHelpers.assertThrows((String)"A JSON request with an invalid destination table identifier, with no name, should fail to deserialize", JsonProcessingException.class, (String)"Cannot parse missing string: name", () -> this.deserialize(jsonDestinationMissingName));
        String emptyJson = "{}";
        AssertHelpers.assertThrows((String)"An empty JSON object should not parse into a valid RenameTableRequest instance", IllegalArgumentException.class, (String)"Invalid source table: null", () -> this.deserialize(emptyJson));
        AssertHelpers.assertThrows((String)"An empty JSON request should fail to deserialize", IllegalArgumentException.class, () -> this.deserialize(null));
    }

    @Test
    public void testBuilderDoesNotBuildInvalidRequests() {
        AssertHelpers.assertThrows((String)"The builder should not allow using null for the source table", NullPointerException.class, (String)"Invalid source table identifier: null", () -> RenameTableRequest.builder().withSource(null).withDestination(TAX_PAID_RENAMED).build());
        AssertHelpers.assertThrows((String)"The builder should not allow using null for the destination table", NullPointerException.class, (String)"Invalid destination table identifier: null", () -> RenameTableRequest.builder().withSource(TAX_PAID).withDestination(null).build());
    }

    @Override
    public String[] allFieldsFromSpec() {
        return new String[]{"source", "destination"};
    }

    @Override
    public RenameTableRequest createExampleInstance() {
        return RenameTableRequest.builder().withSource(TAX_PAID).withDestination(TAX_PAID_RENAMED).build();
    }

    @Override
    public void assertEquals(RenameTableRequest actual, RenameTableRequest expected) {
        Assert.assertEquals((String)"Source table identifier should be equal", (Object)expected.source(), (Object)actual.source());
        Assert.assertEquals((String)"Destination table identifier should be equal", (Object)expected.destination(), (Object)actual.destination());
    }

    @Override
    public RenameTableRequest deserialize(String json) throws JsonProcessingException {
        RenameTableRequest request = (RenameTableRequest)TestRenameTableRequest.mapper().readValue(json, RenameTableRequest.class);
        request.validate();
        return request;
    }
}

