/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.requests;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.SortOrderParser;
import org.apache.iceberg.UnboundPartitionSpec;
import org.apache.iceberg.UnboundSortOrder;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.rest.RequestResponseTestBase;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestCreateTableRequest
extends RequestResponseTestBase<CreateTableRequest> {
    private static final Map<String, String> SAMPLE_PROPERTIES = ImmutableMap.of((Object)"owner", (Object)"Hank");
    private static final Map<String, String> EMPTY_PROPERTIES = ImmutableMap.of();
    private static final String SAMPLE_NAME = "test_tbl";
    private static final String SAMPLE_LOCATION = "file://tmp/location/";
    private static final Schema SAMPLE_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
    private static final String SAMPLE_SCHEMA_JSON = SchemaParser.toJson((Schema)SAMPLE_SCHEMA);
    private static final PartitionSpec SAMPLE_SPEC = PartitionSpec.builderFor((Schema)SAMPLE_SCHEMA).bucket("id", 16).build();
    private static final SortOrder SAMPLE_WRITE_ORDER = ((SortOrder.Builder)SortOrder.builderFor((Schema)SAMPLE_SCHEMA).asc("data", NullOrder.NULLS_LAST)).build();

    @Test
    public void testRoundTripSerDe() throws JsonProcessingException {
        String fullJsonRaw = "{\"name\":\"test_tbl\",\"location\":\"file://tmp/location/\",\"schema\":{\"type\":\"struct\",\"schema-id\":0,\"fields\":[{\"id\":1,\"name\":\"id\",\"required\":true,\"type\":\"int\"},{\"id\":2,\"name\":\"data\",\"required\":false,\"type\":\"string\"}]},\"partition-spec\":{\"spec-id\":0,\"fields\":[{\"name\":\"id_bucket\",\"transform\":\"bucket[16]\",\"source-id\":1,\"field-id\":1000}]},\"write-order\":{\"order-id\":1,\"fields\":[{\"transform\":\"identity\",\"source-id\":2,\"direction\":\"asc\",\"null-order\":\"nulls-last\"}]},\"properties\":{\"owner\":\"Hank\"},\"stage-create\":false}";
        CreateTableRequest req = CreateTableRequest.builder().withName(SAMPLE_NAME).withLocation(SAMPLE_LOCATION).withSchema(SAMPLE_SCHEMA).setProperties(SAMPLE_PROPERTIES).withPartitionSpec(SAMPLE_SPEC).withWriteOrder(SAMPLE_WRITE_ORDER).build();
        this.assertRoundTripSerializesEquallyFrom(fullJsonRaw, req);
        String jsonStagedReq = String.format("{\"name\":\"%s\",\"location\":\"%s\",\"schema\":%s,\"partition-spec\":%s,\"write-order\":%s,\"properties\":%s,\"stage-create\":%b}", SAMPLE_NAME, SAMPLE_LOCATION, SchemaParser.toJson((Schema)SAMPLE_SCHEMA), PartitionSpecParser.toJson((UnboundPartitionSpec)SAMPLE_SPEC.toUnbound()), SortOrderParser.toJson((UnboundSortOrder)SAMPLE_WRITE_ORDER.toUnbound()), TestCreateTableRequest.mapper().writeValueAsString(SAMPLE_PROPERTIES), true);
        CreateTableRequest stagedReq = CreateTableRequest.builder().withName(SAMPLE_NAME).withLocation(SAMPLE_LOCATION).withSchema(SAMPLE_SCHEMA).setProperty("owner", "Hank").withPartitionSpec(SAMPLE_SPEC).withWriteOrder(SAMPLE_WRITE_ORDER).stageCreate().build();
        this.assertRoundTripSerializesEquallyFrom(jsonStagedReq, stagedReq);
        String jsonWithExplicitUnsortedUnordered = String.format("{\"name\":\"%s\",\"location\":null,\"schema\":%s,\"partition-spec\":%s,\"write-order\":%s,\"properties\":{},\"stage-create\":%b}", SAMPLE_NAME, SchemaParser.toJson((Schema)SAMPLE_SCHEMA), PartitionSpecParser.toJson((PartitionSpec)PartitionSpec.unpartitioned()), SortOrderParser.toJson((UnboundSortOrder)SortOrder.unsorted().toUnbound()), false);
        CreateTableRequest reqOnlyRequiredFieldsExplicitDefaults = CreateTableRequest.builder().withName(SAMPLE_NAME).withLocation(null).withSchema(SAMPLE_SCHEMA).setProperties(EMPTY_PROPERTIES).withPartitionSpec(PartitionSpec.unpartitioned()).withWriteOrder(SortOrder.unsorted()).build();
        this.assertRoundTripSerializesEquallyFrom(jsonWithExplicitUnsortedUnordered, reqOnlyRequiredFieldsExplicitDefaults);
        String jsonOnlyRequiredFieldsNullAsDefault = String.format("{\"name\":\"%s\",\"location\":null,\"schema\":%s,\"partition-spec\":null,\"write-order\":null,\"properties\":{},\"stage-create\":false}", SAMPLE_NAME, SchemaParser.toJson((Schema)SAMPLE_SCHEMA));
        CreateTableRequest reqOnlyRequiredFieldsMissingDefaults = CreateTableRequest.builder().withName(SAMPLE_NAME).withSchema(SAMPLE_SCHEMA).withPartitionSpec(null).withWriteOrder(null).build();
        this.assertRoundTripSerializesEquallyFrom(jsonOnlyRequiredFieldsNullAsDefault, reqOnlyRequiredFieldsMissingDefaults);
    }

    @Test
    public void testCanDeserializeWithoutDefaultValues() throws JsonProcessingException {
        String jsonOnlyRequiredFieldsMissingDefaults = String.format("{\"name\":\"%s\",\"schema\":%s}", SAMPLE_NAME, SchemaParser.toJson((Schema)SAMPLE_SCHEMA));
        CreateTableRequest reqOnlyRequiredFieldsMissingDefaults = CreateTableRequest.builder().withName(SAMPLE_NAME).withSchema(SAMPLE_SCHEMA).build();
        this.assertEquals(this.deserialize(jsonOnlyRequiredFieldsMissingDefaults), reqOnlyRequiredFieldsMissingDefaults);
    }

    @Test
    public void testDeserializeInvalidRequest() {
        String jsonMissingSchema = "{\"name\":\"foo\",\"location\":null,\"partition-spec\":null,\"write-order\":null,\"properties\":{},\"stage-create\":false}";
        AssertHelpers.assertThrows((String)"A JSON request with the keys spelled incorrectly should fail to deserialize and validate", IllegalArgumentException.class, (String)"Invalid schema: null", () -> this.deserialize(jsonMissingSchema));
        String jsonMissingName = String.format("{\"location\":null,\"schema\":%s,\"spec\":null,\"write-order\":null,\"properties\":{},\"stage-create\":false}", SAMPLE_SCHEMA_JSON);
        AssertHelpers.assertThrows((String)"A JSON request with the keys spelled incorrectly should fail to deserialize and validate", IllegalArgumentException.class, (String)"Invalid table name: null", () -> this.deserialize(jsonMissingName));
        String jsonIncorrectTypeForProperties = String.format("{\"name\":\"foo\",\"location\":null,\"schema\":%s,\"partition-spec\":null,\"write-order\":null,\"properties\":[],\"stage-create\":false}", SAMPLE_SCHEMA_JSON);
        AssertHelpers.assertThrows((String)"A JSON request with incorrect types for fields should fail to parse and validate", JsonProcessingException.class, () -> this.deserialize(jsonIncorrectTypeForProperties));
        AssertHelpers.assertThrows((String)"An empty JSON object should not parse into a CreateNamespaceRequest instance that passes validation", IllegalArgumentException.class, (String)"Invalid table name: null", () -> this.deserialize("{}"));
        AssertHelpers.assertThrows((String)"An empty JSON request should fail to deserialize", IllegalArgumentException.class, () -> this.deserialize(null));
    }

    @Test
    public void testBuilderDoesNotBuildInvalidRequests() {
        AssertHelpers.assertThrows((String)"The builder should not allow using null for the namespace", NullPointerException.class, (String)"Invalid name: null", () -> CreateTableRequest.builder().withName(null));
        AssertHelpers.assertThrows((String)"The builder should not allow using null for the schema", NullPointerException.class, (String)"Invalid schema: null", () -> CreateTableRequest.builder().withSchema(null));
        AssertHelpers.assertThrows((String)"The builder should not allow passing a null collection of properties", NullPointerException.class, (String)"Invalid collection of properties: null", () -> CreateTableRequest.builder().setProperties(null));
        HashMap mapWithNullKey = Maps.newHashMap();
        mapWithNullKey.put(null, "hello");
        AssertHelpers.assertThrows((String)"The builder should not allow using null as a key in the properties to set", IllegalArgumentException.class, (String)"Invalid property: null", () -> CreateTableRequest.builder().setProperties(mapWithNullKey));
        HashMap mapWithNullValue = Maps.newHashMap();
        mapWithNullValue.put("a", null);
        mapWithNullValue.put("b", "b");
        AssertHelpers.assertThrows((String)"The builder should not allow using null as a value in the properties to set", IllegalArgumentException.class, (String)"Invalid value for properties [a]: null", () -> CreateTableRequest.builder().setProperties(mapWithNullValue).build());
        AssertHelpers.assertThrows((String)"The builder should not allow using null as a value when setting a single property", IllegalArgumentException.class, (String)"Invalid value for property foo: null", () -> CreateTableRequest.builder().setProperty("foo", null));
        AssertHelpers.assertThrows((String)"The builder should not allow using null as a key when setting a single property", IllegalArgumentException.class, (String)"Invalid property: null", () -> CreateTableRequest.builder().setProperty(null, "foo"));
    }

    @Override
    public String[] allFieldsFromSpec() {
        return new String[]{"name", "location", "schema", "partition-spec", "write-order", "stage-create", "properties"};
    }

    @Override
    public CreateTableRequest createExampleInstance() {
        return CreateTableRequest.builder().withName(SAMPLE_NAME).withLocation(SAMPLE_LOCATION).withSchema(SAMPLE_SCHEMA).withPartitionSpec(SAMPLE_SPEC).withWriteOrder(SAMPLE_WRITE_ORDER).setProperties(SAMPLE_PROPERTIES).stageCreate().build();
    }

    @Override
    public void assertEquals(CreateTableRequest actual, CreateTableRequest expected) {
        Assert.assertEquals((String)"Name should be the same", (Object)expected.name(), (Object)actual.name());
        Assert.assertEquals((String)"Location should be the same if provided", (Object)expected.location(), (Object)actual.location());
        Assert.assertTrue((String)"Schemas should be equivalent and have same schema id", (expected.schema().sameSchema(actual.schema()) && expected.schema().schemaId() == actual.schema().schemaId() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Partition spec should be equal", (Object)expected.spec(), (Object)actual.spec());
        Assert.assertEquals((String)"Write [sort] order should be the same", (Object)expected.writeOrder(), (Object)actual.writeOrder());
        Assert.assertEquals((String)"Properties should be the same", (Object)expected.properties(), (Object)actual.properties());
        Assert.assertEquals((String)"Stage create should be equal", (Object)expected.stageCreate(), (Object)actual.stageCreate());
    }

    @Override
    public CreateTableRequest deserialize(String json) throws JsonProcessingException {
        CreateTableRequest request = (CreateTableRequest)TestCreateTableRequest.mapper().readValue(json, CreateTableRequest.class);
        request.validate();
        return request;
    }
}

