/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.requests;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.rest.RequestResponseTestBase;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.junit.Assert;
import org.junit.Test;

public class TestCreateNamespaceRequest
extends RequestResponseTestBase<CreateNamespaceRequest> {
    private static final Namespace NAMESPACE = Namespace.of((String[])new String[]{"accounting", "tax"});
    private static final Map<String, String> PROPERTIES = ImmutableMap.of((Object)"owner", (Object)"Hank");
    private static final Map<String, String> EMPTY_PROPERTIES = ImmutableMap.of();

    @Test
    public void testRoundTripSerDe() throws JsonProcessingException {
        String fullJson = "{\"namespace\":[\"accounting\",\"tax\"],\"properties\":{\"owner\":\"Hank\"}}";
        CreateNamespaceRequest req = CreateNamespaceRequest.builder().withNamespace(NAMESPACE).setProperties(PROPERTIES).build();
        this.assertRoundTripSerializesEquallyFrom(fullJson, req);
        String jsonEmptyProperties = "{\"namespace\":[\"accounting\",\"tax\"],\"properties\":{}}";
        CreateNamespaceRequest reqWithExplicitEmptyProperties = CreateNamespaceRequest.builder().withNamespace(NAMESPACE).setProperties(EMPTY_PROPERTIES).build();
        this.assertRoundTripSerializesEquallyFrom(jsonEmptyProperties, reqWithExplicitEmptyProperties);
        CreateNamespaceRequest reqWithImplicitEmptyProperties = CreateNamespaceRequest.builder().withNamespace(NAMESPACE).build();
        this.assertRoundTripSerializesEquallyFrom(jsonEmptyProperties, reqWithImplicitEmptyProperties);
        String jsonWithEmptyNamespace = "{\"namespace\":[],\"properties\":{}}";
        CreateNamespaceRequest reqUsingEmptyNamespace = CreateNamespaceRequest.builder().withNamespace(Namespace.empty()).build();
        this.assertRoundTripSerializesEquallyFrom(jsonWithEmptyNamespace, reqUsingEmptyNamespace);
    }

    @Test
    public void testCanDeserializeWithoutDefaultValues() throws JsonProcessingException {
        CreateNamespaceRequest req = CreateNamespaceRequest.builder().withNamespace(NAMESPACE).build();
        String jsonWithNullProperties = "{\"namespace\":[\"accounting\",\"tax\"],\"properties\":null}";
        this.assertEquals(this.deserialize(jsonWithNullProperties), req);
        String jsonWithMissingProperties = "{\"namespace\":[\"accounting\",\"tax\"]}";
        this.assertEquals(this.deserialize(jsonWithMissingProperties), req);
    }

    @Test
    public void testDeserializeInvalidRequest() {
        String jsonIncorrectTypeForNamespace = "{\"namespace\":\"accounting%1Ftax\",\"properties\":null}";
        AssertHelpers.assertThrows((String)"A JSON request with incorrect types for fields should fail to deserialize and validate", JsonProcessingException.class, (String)"Cannot parse string array from non-array", () -> this.deserialize(jsonIncorrectTypeForNamespace));
        String jsonIncorrectTypeForProperties = "{\"namespace\":[\"accounting\",\"tax\"],\"properties\":[]}";
        AssertHelpers.assertThrows((String)"A JSON request with incorrect types for fields should fail to parse and validate", JsonProcessingException.class, () -> this.deserialize(jsonIncorrectTypeForProperties));
        String jsonMisspelledKeys = "{\"namepsace\":[\"accounting\",\"tax\"],\"propertiezzzz\":{\"owner\":\"Hank\"}}";
        AssertHelpers.assertThrows((String)"A JSON request with the keys spelled incorrectly should fail to deserialize and validate", IllegalArgumentException.class, (String)"Invalid namespace: null", () -> this.deserialize(jsonMisspelledKeys));
        String emptyJson = "{}";
        AssertHelpers.assertThrows((String)"An empty JSON object should not parse into a CreateNamespaceRequest instance that passes validation", IllegalArgumentException.class, (String)"Invalid namespace: null", () -> this.deserialize(emptyJson));
        AssertHelpers.assertThrows((String)"An empty JSON request should fail to deserialize", IllegalArgumentException.class, () -> this.deserialize(null));
    }

    @Test
    public void testBuilderDoesNotBuildInvalidRequests() {
        AssertHelpers.assertThrows((String)"The builder should not allow using null for the namespace", NullPointerException.class, (String)"Invalid namespace: null", () -> CreateNamespaceRequest.builder().withNamespace(null).build());
        AssertHelpers.assertThrows((String)"The builder should not allow passing a null collection of properties", NullPointerException.class, (String)"Invalid collection of properties: null", () -> CreateNamespaceRequest.builder().setProperties(null).build());
        HashMap mapWithNullKey = Maps.newHashMap();
        mapWithNullKey.put(null, "hello");
        AssertHelpers.assertThrows((String)"The builder should not allow using null as a key in the properties to set", IllegalArgumentException.class, (String)"Invalid property: null", () -> CreateNamespaceRequest.builder().setProperties(mapWithNullKey).build());
        HashMap mapWithMultipleNullValues = Maps.newHashMap();
        mapWithMultipleNullValues.put("a", null);
        mapWithMultipleNullValues.put("b", "b");
        AssertHelpers.assertThrows((String)"The builder should not allow using null as a value in the properties to set", IllegalArgumentException.class, (String)"Invalid value for properties [a]: null", () -> CreateNamespaceRequest.builder().setProperties(mapWithMultipleNullValues).build());
    }

    @Override
    public String[] allFieldsFromSpec() {
        return new String[]{"namespace", "properties"};
    }

    @Override
    public CreateNamespaceRequest createExampleInstance() {
        return CreateNamespaceRequest.builder().withNamespace(NAMESPACE).setProperties(PROPERTIES).build();
    }

    @Override
    public void assertEquals(CreateNamespaceRequest actual, CreateNamespaceRequest expected) {
        Assert.assertEquals((String)"Namespaces should be equal", (Object)actual.namespace(), (Object)expected.namespace());
        Assert.assertEquals((String)"Properties should be equal", (Object)actual.properties(), (Object)expected.properties());
    }

    @Override
    public CreateNamespaceRequest deserialize(String json) throws JsonProcessingException {
        CreateNamespaceRequest request = (CreateNamespaceRequest)TestCreateNamespaceRequest.mapper().readValue(json, CreateNamespaceRequest.class);
        request.validate();
        return request;
    }
}

