/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.auth;

import org.apache.iceberg.rest.auth.OAuth2Util;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestOAuth2Util {
    @Test
    public void testOAuthScopeTokenValidation() {
        Assert.assertFalse((String)"Should reject scope token with \\", (boolean)OAuth2Util.isValidScopeToken((String)"a\\b"));
        Assert.assertFalse((String)"Should reject scope token with space", (boolean)OAuth2Util.isValidScopeToken((String)"a b"));
        Assert.assertFalse((String)"Should reject scope token with \"", (boolean)OAuth2Util.isValidScopeToken((String)"a\"b"));
        Assert.assertFalse((String)"Should reject scope token with DEL", (boolean)OAuth2Util.isValidScopeToken((String)"\u007f"));
        Assert.assertTrue((String)"Should accept scope token with !-/", (boolean)OAuth2Util.isValidScopeToken((String)"!#$%&'()*+,-./"));
        Assert.assertTrue((String)"Should accept scope token with 0-9", (boolean)OAuth2Util.isValidScopeToken((String)"0123456789"));
        Assert.assertTrue((String)"Should accept scope token with :-@", (boolean)OAuth2Util.isValidScopeToken((String)":;<=>?@"));
        Assert.assertTrue((String)"Should accept scope token with A-M", (boolean)OAuth2Util.isValidScopeToken((String)"ABCDEFGHIJKLM"));
        Assert.assertTrue((String)"Should accept scope token with N-Z", (boolean)OAuth2Util.isValidScopeToken((String)"NOPQRSTUVWXYZ"));
        Assert.assertTrue((String)"Should accept scope token with [-`, not \\", (boolean)OAuth2Util.isValidScopeToken((String)"[]^_`"));
        Assert.assertTrue((String)"Should accept scope token with a-m", (boolean)OAuth2Util.isValidScopeToken((String)"abcdefghijklm"));
        Assert.assertTrue((String)"Should accept scope token with n-z", (boolean)OAuth2Util.isValidScopeToken((String)"nopqrstuvwxyz"));
        Assert.assertTrue((String)"Should accept scope token with {-~", (boolean)OAuth2Util.isValidScopeToken((String)"{|}~"));
    }

    @Test
    public void testExpiresAt() {
        Assertions.assertThat((Long)OAuth2Util.expiresAtMillis(null)).isNull();
        Assertions.assertThat((Long)OAuth2Util.expiresAtMillis((String)"not a token")).isNull();
        String token = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiaWF0IjoxNTE2MjM5MDIyLCJleHAiOjF9.gQADTbdEv-rpDWKSkGLbmafyB5UUjTdm9B_1izpuZ6E";
        Assertions.assertThat((Long)OAuth2Util.expiresAtMillis((String)token)).isEqualTo(1000L);
        token = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiaWF0IjoxNTE2MjM5MDIyLCJleHAiOjE5OTk5OTk5OTk5fQ._3k92KJi2NTyTG6V1s2mzJ__GiQtL36DnzsZSkBdYPw";
        Assertions.assertThat((Long)OAuth2Util.expiresAtMillis((String)token)).isEqualTo(19999999999000L);
        token = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiaWF0IjoxNTE2MjM5MDIyfQ.SflKxwRJSMeKKF2QT4fwpMeJf36POk6yJV_adQssw5c";
        Assertions.assertThat((Long)OAuth2Util.expiresAtMillis((String)token)).isNull();
    }
}

