/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.util.Map;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.rest.ResourcePaths;
import org.junit.Assert;
import org.junit.Test;

public class TestResourcePaths {
    private final String prefix = "ws/catalog";
    private final ResourcePaths withPrefix = ResourcePaths.forCatalogProperties((Map)ImmutableMap.of((Object)"prefix", (Object)"ws/catalog"));
    private final ResourcePaths withoutPrefix = ResourcePaths.forCatalogProperties((Map)ImmutableMap.of());

    @Test
    public void testConfigPath() {
        Assert.assertEquals((Object)ResourcePaths.config(), (Object)"v1/config");
    }

    @Test
    public void testNamespaces() {
        Assert.assertEquals((Object)"v1/ws/catalog/namespaces", (Object)this.withPrefix.namespaces());
        Assert.assertEquals((Object)"v1/namespaces", (Object)this.withoutPrefix.namespaces());
    }

    @Test
    public void testNamespace() {
        Namespace ns = Namespace.of((String[])new String[]{"ns"});
        Assert.assertEquals((Object)"v1/ws/catalog/namespaces/ns", (Object)this.withPrefix.namespace(ns));
        Assert.assertEquals((Object)"v1/namespaces/ns", (Object)this.withoutPrefix.namespace(ns));
    }

    @Test
    public void testNamespaceWithSlash() {
        Namespace ns = Namespace.of((String[])new String[]{"n/s"});
        Assert.assertEquals((Object)"v1/ws/catalog/namespaces/n%2Fs", (Object)this.withPrefix.namespace(ns));
        Assert.assertEquals((Object)"v1/namespaces/n%2Fs", (Object)this.withoutPrefix.namespace(ns));
    }

    @Test
    public void testNamespaceWithMultipartNamespace() {
        Namespace ns = Namespace.of((String[])new String[]{"n", "s"});
        Assert.assertEquals((Object)"v1/ws/catalog/namespaces/n%1Fs", (Object)this.withPrefix.namespace(ns));
        Assert.assertEquals((Object)"v1/namespaces/n%1Fs", (Object)this.withoutPrefix.namespace(ns));
    }

    @Test
    public void testNamespaceProperties() {
        Namespace ns = Namespace.of((String[])new String[]{"ns"});
        Assert.assertEquals((Object)"v1/ws/catalog/namespaces/ns/properties", (Object)this.withPrefix.namespaceProperties(ns));
        Assert.assertEquals((Object)"v1/namespaces/ns/properties", (Object)this.withoutPrefix.namespaceProperties(ns));
    }

    @Test
    public void testNamespacePropertiesWithSlash() {
        Namespace ns = Namespace.of((String[])new String[]{"n/s"});
        Assert.assertEquals((Object)"v1/ws/catalog/namespaces/n%2Fs/properties", (Object)this.withPrefix.namespaceProperties(ns));
        Assert.assertEquals((Object)"v1/namespaces/n%2Fs/properties", (Object)this.withoutPrefix.namespaceProperties(ns));
    }

    @Test
    public void testNamespacePropertiesWithMultipartNamespace() {
        Namespace ns = Namespace.of((String[])new String[]{"n", "s"});
        Assert.assertEquals((Object)"v1/ws/catalog/namespaces/n%1Fs/properties", (Object)this.withPrefix.namespaceProperties(ns));
        Assert.assertEquals((Object)"v1/namespaces/n%1Fs/properties", (Object)this.withoutPrefix.namespaceProperties(ns));
    }

    @Test
    public void testTables() {
        Namespace ns = Namespace.of((String[])new String[]{"ns"});
        Assert.assertEquals((Object)"v1/ws/catalog/namespaces/ns/tables", (Object)this.withPrefix.tables(ns));
        Assert.assertEquals((Object)"v1/namespaces/ns/tables", (Object)this.withoutPrefix.tables(ns));
    }

    @Test
    public void testTablesWithSlash() {
        Namespace ns = Namespace.of((String[])new String[]{"n/s"});
        Assert.assertEquals((Object)"v1/ws/catalog/namespaces/n%2Fs/tables", (Object)this.withPrefix.tables(ns));
        Assert.assertEquals((Object)"v1/namespaces/n%2Fs/tables", (Object)this.withoutPrefix.tables(ns));
    }

    @Test
    public void testTablesWithMultipartNamespace() {
        Namespace ns = Namespace.of((String[])new String[]{"n", "s"});
        Assert.assertEquals((Object)"v1/ws/catalog/namespaces/n%1Fs/tables", (Object)this.withPrefix.tables(ns));
        Assert.assertEquals((Object)"v1/namespaces/n%1Fs/tables", (Object)this.withoutPrefix.tables(ns));
    }

    @Test
    public void testTable() {
        TableIdentifier ident = TableIdentifier.of((String[])new String[]{"ns", "table"});
        Assert.assertEquals((Object)"v1/ws/catalog/namespaces/ns/tables/table", (Object)this.withPrefix.table(ident));
        Assert.assertEquals((Object)"v1/namespaces/ns/tables/table", (Object)this.withoutPrefix.table(ident));
    }

    @Test
    public void testTableWithSlash() {
        TableIdentifier ident = TableIdentifier.of((String[])new String[]{"n/s", "tab/le"});
        Assert.assertEquals((Object)"v1/ws/catalog/namespaces/n%2Fs/tables/tab%2Fle", (Object)this.withPrefix.table(ident));
        Assert.assertEquals((Object)"v1/namespaces/n%2Fs/tables/tab%2Fle", (Object)this.withoutPrefix.table(ident));
    }

    @Test
    public void testTableWithMultipartNamespace() {
        TableIdentifier ident = TableIdentifier.of((String[])new String[]{"n", "s", "table"});
        Assert.assertEquals((Object)"v1/ws/catalog/namespaces/n%1Fs/tables/table", (Object)this.withPrefix.table(ident));
        Assert.assertEquals((Object)"v1/namespaces/n%1Fs/tables/table", (Object)this.withoutPrefix.table(ident));
    }
}

