/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.util.Map;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.rest.RESTUtil;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestRESTUtil {
    @Test
    public void testExtractPrefixMap() {
        ImmutableMap input = ImmutableMap.of((Object)"warehouse", (Object)"/tmp/warehouse", (Object)"rest.prefix", (Object)"/ws/ralphs_catalog", (Object)"rest.token", (Object)"YnVybiBhZnRlciByZWFkaW5nIC0gYWxzbyBoYW5rIGFuZCByYXVsIDQgZXZlcgo=", (Object)"rest.rest.uri", (Object)"https://localhost:1080/", (Object)"doesnt_start_with_prefix.rest", (Object)"", (Object)"", (Object)"");
        ImmutableMap expected = ImmutableMap.of((Object)"prefix", (Object)"/ws/ralphs_catalog", (Object)"token", (Object)"YnVybiBhZnRlciByZWFkaW5nIC0gYWxzbyBoYW5rIGFuZCByYXVsIDQgZXZlcgo=", (Object)"rest.uri", (Object)"https://localhost:1080/");
        Map actual = RESTUtil.extractPrefixMap((Map)input, (String)"rest.");
        Assertions.assertThat((Map)actual).isEqualTo((Object)expected);
    }

    @Test
    public void testStripTrailingSlash() {
        String[][] testCases;
        for (String[] testCase : testCases = new String[][]{{"https://foo", "https://foo"}, {"https://foo/", "https://foo"}, {"https://foo////", "https://foo"}, {null, null}}) {
            String input = testCase[0];
            String expected = testCase[1];
            Assertions.assertThat((String)RESTUtil.stripTrailingSlash((String)input)).isEqualTo(expected);
        }
    }

    @Test
    public void testRoundTripUrlEncodeDecodeNamespace() {
        Object[][] testCases;
        for (Object[] namespaceWithEncoding : testCases = new Object[][]{{new String[]{"dogs"}, "dogs"}, {new String[]{"dogs.named.hank"}, "dogs.named.hank"}, {new String[]{"dogs/named/hank"}, "dogs%2Fnamed%2Fhank"}, {new String[]{"dogs", "named", "hank"}, "dogs%1Fnamed%1Fhank"}, {new String[]{"dogs.and.cats", "named", "hank.or.james-westfall"}, "dogs.and.cats%1Fnamed%1Fhank.or.james-westfall"}}) {
            String[] levels = (String[])namespaceWithEncoding[0];
            String encodedNs = (String)namespaceWithEncoding[1];
            Namespace namespace = Namespace.of((String[])levels);
            Assertions.assertThat((String)RESTUtil.encodeNamespace((Namespace)namespace)).isEqualTo(encodedNs);
            Namespace asNamespace = RESTUtil.decodeNamespace((String)encodedNs);
            Assertions.assertThat((Object)asNamespace).isEqualTo((Object)namespace);
        }
    }

    @Test
    public void testNamespaceUrlEncodeDecodeDoesNotAllowNull() {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> RESTUtil.encodeNamespace(null)).withMessage("Invalid namespace: null");
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> RESTUtil.decodeNamespace(null)).withMessage("Invalid namespace: null");
    }

    @Test
    public void testOAuth2URLEncoding() {
        String utf8 = " %&+\u00a3\u20ac";
        String expected = "+%25%26%2B%C2%A3%E2%82%AC";
        Assertions.assertThat((String)RESTUtil.encodeString((String)utf8)).isEqualTo(expected);
    }

    @Test
    public void testOAuth2FormDataEncoding() {
        String utf8 = " %&+\u00a3\u20ac";
        String asString = "+%25%26%2B%C2%A3%E2%82%AC";
        ImmutableMap formData = ImmutableMap.of((Object)"client_id", (Object)"12345", (Object)"client_secret", (Object)utf8);
        String expected = "client_id=12345&client_secret=" + asString;
        Assertions.assertThat((String)RESTUtil.encodeFormData((Map)formData)).isEqualTo(expected);
    }

    @Test
    public void testOAuth2FormDataDecoding() {
        String utf8 = " %&+\u00a3\u20ac";
        String asString = "+%25%26%2B%C2%A3%E2%82%AC";
        ImmutableMap expected = ImmutableMap.of((Object)"client_id", (Object)"12345", (Object)"client_secret", (Object)utf8);
        String formString = "client_id=12345&client_secret=" + asString;
        Assertions.assertThat((Map)RESTUtil.decodeFormData((String)formString)).isEqualTo((Object)expected);
    }
}

