/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.CatalogTests;
import org.apache.iceberg.catalog.SessionCatalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.jdbc.JdbcCatalog;
import org.apache.iceberg.metrics.MetricsReport;
import org.apache.iceberg.metrics.MetricsReporter;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.rest.HTTPClient;
import org.apache.iceberg.rest.RESTCatalog;
import org.apache.iceberg.rest.RESTCatalogAdapter;
import org.apache.iceberg.rest.RESTCatalogServlet;
import org.apache.iceberg.rest.RESTMessage;
import org.apache.iceberg.rest.RESTObjectMapper;
import org.apache.iceberg.rest.RESTResponse;
import org.apache.iceberg.rest.RESTSessionCatalog;
import org.apache.iceberg.rest.ResourcePaths;
import org.apache.iceberg.rest.auth.AuthSessionUtil;
import org.apache.iceberg.rest.auth.OAuth2Util;
import org.apache.iceberg.rest.responses.ConfigResponse;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.OAuthTokenResponse;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestRESTCatalog
extends CatalogTests<RESTCatalog> {
    private static final ObjectMapper MAPPER = RESTObjectMapper.mapper();
    @TempDir
    public Path temp;
    private RESTCatalog restCatalog;
    private JdbcCatalog backendCatalog;
    private Server httpServer;

    @BeforeEach
    public void createCatalog() throws Exception {
        File warehouse = this.temp.toFile();
        Configuration conf = new Configuration();
        this.backendCatalog = new JdbcCatalog();
        this.backendCatalog.setConf((Object)conf);
        ImmutableMap backendCatalogProperties = ImmutableMap.of((Object)"warehouse", (Object)warehouse.getAbsolutePath(), (Object)"uri", (Object)("jdbc:sqlite:file::memory:?ic" + UUID.randomUUID().toString().replace("-", "")), (Object)"jdbc.username", (Object)"user", (Object)"jdbc.password", (Object)"password");
        this.backendCatalog.initialize("backend", (Map)backendCatalogProperties);
        ImmutableMap catalogHeaders = ImmutableMap.of((Object)"Authorization", (Object)"Bearer client-credentials-token:sub=catalog");
        ImmutableMap contextHeaders = ImmutableMap.of((Object)"Authorization", (Object)"Bearer client-credentials-token:sub=user");
        RESTCatalogAdapter adaptor = new RESTCatalogAdapter((Catalog)this.backendCatalog, (Map)catalogHeaders, (Map)contextHeaders){
            final /* synthetic */ Map val$catalogHeaders;
            final /* synthetic */ Map val$contextHeaders;
            {
                this.val$catalogHeaders = map;
                this.val$contextHeaders = map2;
                super(catalog);
            }

            @Override
            public <T extends RESTResponse> T execute(RESTCatalogAdapter.HTTPMethod method, String path, Map<String, String> queryParams, Object body, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
                if (!"v1/oauth/tokens".equals(path)) {
                    if ("v1/config".equals(path)) {
                        Assertions.assertThat(headers).containsAllEntriesOf(this.val$catalogHeaders);
                    } else {
                        Assertions.assertThat(headers).containsAllEntriesOf(this.val$contextHeaders);
                    }
                }
                Object request = TestRESTCatalog.roundTripSerialize(body, "request");
                T response = super.execute(method, path, queryParams, request, responseType, headers, errorHandler);
                RESTResponse responseAfterSerialization = (RESTResponse)TestRESTCatalog.roundTripSerialize(response, "response");
                return (T)responseAfterSerialization;
            }
        };
        RESTCatalogServlet servlet = new RESTCatalogServlet(adaptor);
        ServletContextHandler servletContext = new ServletContextHandler(0);
        servletContext.setContextPath("/");
        ServletHolder servletHolder = new ServletHolder((Servlet)servlet);
        servletHolder.setInitParameter("javax.ws.rs.Application", "ServiceListPublic");
        servletContext.addServlet(servletHolder, "/*");
        servletContext.setVirtualHosts(null);
        servletContext.setGzipHandler(new GzipHandler());
        this.httpServer = new Server(0);
        this.httpServer.setHandler((Handler)servletContext);
        this.httpServer.start();
        SessionCatalog.SessionContext context = new SessionCatalog.SessionContext(UUID.randomUUID().toString(), "user", (Map)ImmutableMap.of((Object)"credential", (Object)"user:12345"), (Map)ImmutableMap.of());
        this.restCatalog = new RESTCatalog(context, config -> HTTPClient.builder((Map)config).uri((String)config.get("uri")).build());
        this.restCatalog.setConf((Object)conf);
        this.restCatalog.initialize("prod", (Map)ImmutableMap.of((Object)"uri", (Object)this.httpServer.getURI().toString(), (Object)"credential", (Object)"catalog:12345"));
    }

    public static <T> T roundTripSerialize(T payload, String description) {
        if (payload != null) {
            try {
                if (payload instanceof RESTMessage) {
                    return (T)MAPPER.readValue(MAPPER.writeValueAsString(payload), payload.getClass());
                }
                return (T)MAPPER.readValue(MAPPER.writeValueAsString(payload), Map.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(String.format("Failed to serialize and deserialize %s: %s", description, payload), e);
            }
        }
        return null;
    }

    @AfterEach
    public void closeCatalog() throws Exception {
        if (this.restCatalog != null) {
            this.restCatalog.close();
        }
        if (this.backendCatalog != null) {
            this.backendCatalog.close();
        }
        if (this.httpServer != null) {
            this.httpServer.stop();
            this.httpServer.join();
        }
    }

    @Override
    protected RESTCatalog catalog() {
        return this.restCatalog;
    }

    @Override
    protected boolean supportsNamespaceProperties() {
        return true;
    }

    @Override
    protected boolean supportsServerSideRetry() {
        return true;
    }

    @Override
    protected boolean supportsNestedNamespaces() {
        return true;
    }

    @Test
    public void testConfigRoute() throws IOException {
        RESTCatalogAdapter testClient = new RESTCatalogAdapter((Catalog)this.backendCatalog){

            @Override
            public <T extends RESTResponse> T get(String path, Map<String, String> queryParams, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
                if ("v1/config".equals(path)) {
                    return 2.castResponse(responseType, ConfigResponse.builder().withDefaults((Map)ImmutableMap.of((Object)"clients", (Object)"1")).withOverrides((Map)ImmutableMap.of((Object)"cache-enabled", (Object)"false", (Object)"warehouse", (Object)(queryParams.get("warehouse") + "warehouse"))).build());
                }
                return super.get(path, queryParams, responseType, headers, errorHandler);
            }
        };
        RESTCatalog restCat = new RESTCatalog(config -> testClient);
        ImmutableMap initialConfig = ImmutableMap.of((Object)"uri", (Object)"http://localhost:8080", (Object)"cache-enabled", (Object)"true", (Object)"warehouse", (Object)"s3://bucket/");
        restCat.setConf((Object)new Configuration());
        restCat.initialize("prod", (Map)initialConfig);
        Assert.assertEquals((String)"Catalog properties after initialize should use the server's override properties", (Object)"false", restCat.properties().get("cache-enabled"));
        Assert.assertEquals((String)"Catalog after initialize should use the server's default properties if not specified", (Object)"1", restCat.properties().get("clients"));
        Assert.assertEquals((String)"Catalog should return final warehouse location", (Object)"s3://bucket/warehouse", restCat.properties().get("warehouse"));
        restCat.close();
    }

    @Test
    public void testInitializeWithBadArguments() throws IOException {
        RESTCatalog restCat = new RESTCatalog();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> restCat.initialize("prod", null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid configuration: null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> restCat.initialize("prod", (Map)ImmutableMap.of())).isInstanceOf(NullPointerException.class)).hasMessage("Invalid uri for http client: null");
        restCat.close();
    }

    @Test
    public void testCatalogBasicBearerToken() {
        ImmutableMap catalogHeaders = ImmutableMap.of((Object)"Authorization", (Object)"Bearer bearer-token");
        RESTCatalogAdapter adapter = (RESTCatalogAdapter)Mockito.spy((Object)new RESTCatalogAdapter((Catalog)this.backendCatalog));
        RESTCatalog catalog = new RESTCatalog(SessionCatalog.SessionContext.createEmpty(), config -> adapter);
        catalog.initialize("prod", (Map)ImmutableMap.of((Object)"uri", (Object)"ignored", (Object)"token", (Object)"bearer-token"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)catalog.tableExists(TableIdentifier.of((String[])new String[]{"ns", "table"})));
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/config"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(ConfigResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/namespaces/ns/tables/table"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(LoadTableResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
    }

    @Test
    public void testCatalogCredential() {
        ImmutableMap emptyHeaders = ImmutableMap.of();
        ImmutableMap catalogHeaders = ImmutableMap.of((Object)"Authorization", (Object)"Bearer client-credentials-token:sub=catalog");
        RESTCatalogAdapter adapter = (RESTCatalogAdapter)Mockito.spy((Object)new RESTCatalogAdapter((Catalog)this.backendCatalog));
        RESTCatalog catalog = new RESTCatalog(SessionCatalog.SessionContext.createEmpty(), config -> adapter);
        catalog.initialize("prod", (Map)ImmutableMap.of((Object)"uri", (Object)"ignored", (Object)"credential", (Object)"catalog:secret"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)catalog.tableExists(TableIdentifier.of((String[])new String[]{"ns", "table"})));
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.eq((Object)emptyHeaders), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/config"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(ConfigResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/namespaces/ns/tables/table"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(LoadTableResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
    }

    @Test
    public void testCatalogBearerTokenWithClientCredential() {
        ImmutableMap contextHeaders = ImmutableMap.of((Object)"Authorization", (Object)"Bearer client-credentials-token:sub=user");
        ImmutableMap catalogHeaders = ImmutableMap.of((Object)"Authorization", (Object)"Bearer bearer-token");
        RESTCatalogAdapter adapter = (RESTCatalogAdapter)Mockito.spy((Object)new RESTCatalogAdapter((Catalog)this.backendCatalog));
        SessionCatalog.SessionContext context = new SessionCatalog.SessionContext(UUID.randomUUID().toString(), "user", (Map)ImmutableMap.of((Object)"credential", (Object)"user:secret"), (Map)ImmutableMap.of());
        RESTCatalog catalog = new RESTCatalog(context, config -> adapter);
        catalog.initialize("prod", (Map)ImmutableMap.of((Object)"uri", (Object)"ignored", (Object)"token", (Object)"bearer-token"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)catalog.tableExists(TableIdentifier.of((String[])new String[]{"ns", "table"})));
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/config"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(ConfigResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/namespaces/ns/tables/table"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(LoadTableResponse.class), (Map)ArgumentMatchers.eq((Object)contextHeaders), (Consumer)ArgumentMatchers.any());
    }

    @Test
    public void testCatalogCredentialWithClientCredential() {
        ImmutableMap emptyHeaders = ImmutableMap.of();
        ImmutableMap contextHeaders = ImmutableMap.of((Object)"Authorization", (Object)"Bearer client-credentials-token:sub=user");
        ImmutableMap catalogHeaders = ImmutableMap.of((Object)"Authorization", (Object)"Bearer client-credentials-token:sub=catalog");
        RESTCatalogAdapter adapter = (RESTCatalogAdapter)Mockito.spy((Object)new RESTCatalogAdapter((Catalog)this.backendCatalog));
        SessionCatalog.SessionContext context = new SessionCatalog.SessionContext(UUID.randomUUID().toString(), "user", (Map)ImmutableMap.of((Object)"credential", (Object)"user:secret"), (Map)ImmutableMap.of());
        RESTCatalog catalog = new RESTCatalog(context, config -> adapter);
        catalog.initialize("prod", (Map)ImmutableMap.of((Object)"uri", (Object)"ignored", (Object)"credential", (Object)"catalog:secret"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)catalog.tableExists(TableIdentifier.of((String[])new String[]{"ns", "table"})));
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.eq((Object)emptyHeaders), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/config"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(ConfigResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/namespaces/ns/tables/table"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(LoadTableResponse.class), (Map)ArgumentMatchers.eq((Object)contextHeaders), (Consumer)ArgumentMatchers.any());
    }

    @Test
    public void testCatalogBearerTokenAndCredentialWithClientCredential() {
        ImmutableMap contextHeaders = ImmutableMap.of((Object)"Authorization", (Object)"Bearer client-credentials-token:sub=user");
        ImmutableMap initHeaders = ImmutableMap.of((Object)"Authorization", (Object)"Bearer bearer-token");
        ImmutableMap catalogHeaders = ImmutableMap.of((Object)"Authorization", (Object)"Bearer client-credentials-token:sub=catalog");
        RESTCatalogAdapter adapter = (RESTCatalogAdapter)Mockito.spy((Object)new RESTCatalogAdapter((Catalog)this.backendCatalog));
        SessionCatalog.SessionContext context = new SessionCatalog.SessionContext(UUID.randomUUID().toString(), "user", (Map)ImmutableMap.of((Object)"credential", (Object)"user:secret"), (Map)ImmutableMap.of());
        RESTCatalog catalog = new RESTCatalog(context, config -> adapter);
        catalog.initialize("prod", (Map)ImmutableMap.of((Object)"uri", (Object)"ignored", (Object)"credential", (Object)"catalog:secret", (Object)"token", (Object)"bearer-token"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)catalog.tableExists(TableIdentifier.of((String[])new String[]{"ns", "table"})));
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.eq((Object)initHeaders), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/config"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(ConfigResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/namespaces/ns/tables/table"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(LoadTableResponse.class), (Map)ArgumentMatchers.eq((Object)contextHeaders), (Consumer)ArgumentMatchers.any());
    }

    @Test
    public void testClientBearerToken() {
        this.testClientAuth("bearer-token", (Map<String, String>)ImmutableMap.of((Object)"token", (Object)"client-bearer-token", (Object)"credential", (Object)"user:secret", (Object)"urn:ietf:params:oauth:token-type:id_token", (Object)"id-token", (Object)"urn:ietf:params:oauth:token-type:access_token", (Object)"access-token", (Object)"urn:ietf:params:oauth:token-type:jwt", (Object)"jwt-token", (Object)"urn:ietf:params:oauth:token-type:saml2", (Object)"saml2-token", (Object)"urn:ietf:params:oauth:token-type:saml1", (Object)"saml1-token"), (Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)"Bearer client-bearer-token"));
    }

    @Test
    public void testClientCredential() {
        this.testClientAuth("bearer-token", (Map<String, String>)ImmutableMap.of((Object)"credential", (Object)"user:secret", (Object)"urn:ietf:params:oauth:token-type:id_token", (Object)"id-token", (Object)"urn:ietf:params:oauth:token-type:access_token", (Object)"access-token", (Object)"urn:ietf:params:oauth:token-type:jwt", (Object)"jwt-token", (Object)"urn:ietf:params:oauth:token-type:saml2", (Object)"saml2-token", (Object)"urn:ietf:params:oauth:token-type:saml1", (Object)"saml1-token"), (Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)"Bearer client-credentials-token:sub=user"));
    }

    @Test
    public void testClientIDToken() {
        this.testClientAuth("bearer-token", (Map<String, String>)ImmutableMap.of((Object)"urn:ietf:params:oauth:token-type:id_token", (Object)"id-token", (Object)"urn:ietf:params:oauth:token-type:access_token", (Object)"access-token", (Object)"urn:ietf:params:oauth:token-type:jwt", (Object)"jwt-token", (Object)"urn:ietf:params:oauth:token-type:saml2", (Object)"saml2-token", (Object)"urn:ietf:params:oauth:token-type:saml1", (Object)"saml1-token"), (Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)"Bearer token-exchange-token:sub=id-token,act=bearer-token"));
    }

    @Test
    public void testClientAccessToken() {
        this.testClientAuth("bearer-token", (Map<String, String>)ImmutableMap.of((Object)"urn:ietf:params:oauth:token-type:access_token", (Object)"access-token", (Object)"urn:ietf:params:oauth:token-type:jwt", (Object)"jwt-token", (Object)"urn:ietf:params:oauth:token-type:saml2", (Object)"saml2-token", (Object)"urn:ietf:params:oauth:token-type:saml1", (Object)"saml1-token"), (Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)"Bearer token-exchange-token:sub=access-token,act=bearer-token"));
    }

    @Test
    public void testClientJWTToken() {
        this.testClientAuth("bearer-token", (Map<String, String>)ImmutableMap.of((Object)"urn:ietf:params:oauth:token-type:jwt", (Object)"jwt-token", (Object)"urn:ietf:params:oauth:token-type:saml2", (Object)"saml2-token", (Object)"urn:ietf:params:oauth:token-type:saml1", (Object)"saml1-token"), (Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)"Bearer token-exchange-token:sub=jwt-token,act=bearer-token"));
    }

    @Test
    public void testClientSAML2Token() {
        this.testClientAuth("bearer-token", (Map<String, String>)ImmutableMap.of((Object)"urn:ietf:params:oauth:token-type:saml2", (Object)"saml2-token", (Object)"urn:ietf:params:oauth:token-type:saml1", (Object)"saml1-token"), (Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)"Bearer token-exchange-token:sub=saml2-token,act=bearer-token"));
    }

    @Test
    public void testClientSAML1Token() {
        this.testClientAuth("bearer-token", (Map<String, String>)ImmutableMap.of((Object)"urn:ietf:params:oauth:token-type:saml1", (Object)"saml1-token"), (Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)"Bearer token-exchange-token:sub=saml1-token,act=bearer-token"));
    }

    private void testClientAuth(String catalogToken, Map<String, String> credentials, Map<String, String> expectedHeaders) {
        ImmutableMap catalogHeaders = ImmutableMap.of((Object)"Authorization", (Object)("Bearer " + catalogToken));
        RESTCatalogAdapter adapter = (RESTCatalogAdapter)Mockito.spy((Object)new RESTCatalogAdapter((Catalog)this.backendCatalog));
        SessionCatalog.SessionContext context = new SessionCatalog.SessionContext(UUID.randomUUID().toString(), "user", credentials, (Map)ImmutableMap.of());
        RESTCatalog catalog = new RESTCatalog(context, config -> adapter);
        catalog.initialize("prod", (Map)ImmutableMap.of((Object)"uri", (Object)"ignored", (Object)"token", (Object)catalogToken));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)catalog.tableExists(TableIdentifier.of((String[])new String[]{"ns", "table"})));
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/config"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(ConfigResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
        if (!credentials.containsKey("token")) {
            ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
        }
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/namespaces/ns/tables/table"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(LoadTableResponse.class), (Map)ArgumentMatchers.eq(expectedHeaders), (Consumer)ArgumentMatchers.any());
    }

    @Test
    public void testTableBearerToken() {
        this.testTableAuth("catalog", (Map<String, String>)ImmutableMap.of((Object)"urn:ietf:params:oauth:token-type:id_token", (Object)"id-token"), (Map<String, String>)ImmutableMap.of((Object)"token", (Object)"table-bearer-token"), (Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)"Bearer token-exchange-token:sub=id-token,act=catalog"), (Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)"Bearer table-bearer-token"));
    }

    @Test
    public void testTableIDToken() {
        this.testTableAuth("catalog", (Map<String, String>)ImmutableMap.of((Object)"urn:ietf:params:oauth:token-type:id_token", (Object)"id-token"), (Map<String, String>)ImmutableMap.of((Object)"urn:ietf:params:oauth:token-type:id_token", (Object)"table-id-token"), (Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)"Bearer token-exchange-token:sub=id-token,act=catalog"), (Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)"Bearer token-exchange-token:sub=table-id-token,act=token-exchange-token:sub=id-token,act=catalog"));
    }

    @Test
    public void testTableCredential() {
        this.testTableAuth("catalog", (Map<String, String>)ImmutableMap.of((Object)"urn:ietf:params:oauth:token-type:id_token", (Object)"id-token"), (Map<String, String>)ImmutableMap.of((Object)"credential", (Object)"table-user:secret"), (Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)"Bearer token-exchange-token:sub=id-token,act=catalog"), (Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)"Bearer client-credentials-token:sub=table-user"));
    }

    @Test
    public void testSnapshotParams() {
        Assertions.assertThat((Map)RESTSessionCatalog.SnapshotMode.ALL.params()).isEqualTo((Object)ImmutableMap.of((Object)"snapshots", (Object)"all"));
        Assertions.assertThat((Map)RESTSessionCatalog.SnapshotMode.REFS.params()).isEqualTo((Object)ImmutableMap.of((Object)"snapshots", (Object)"refs"));
    }

    @Test
    public void testTableSnapshotLoading() {
        RESTCatalogAdapter adapter = (RESTCatalogAdapter)Mockito.spy((Object)new RESTCatalogAdapter((Catalog)this.backendCatalog));
        RESTCatalog catalog = new RESTCatalog(SessionCatalog.SessionContext.createEmpty(), config -> adapter);
        catalog.initialize("test", (Map)ImmutableMap.of((Object)"uri", (Object)"ignored", (Object)"io-impl", (Object)"org.apache.iceberg.inmemory.InMemoryFileIO", (Object)"snapshot-loading-mode", (Object)"refs"));
        Table table = catalog.createTable(TABLE, SCHEMA);
        table.newFastAppend().appendFile(DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withPath("/path/to/data-a.parquet").withFileSizeInBytes(10L).withRecordCount(2L).build()).commit();
        table.newFastAppend().appendFile(DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withPath("/path/to/data-b.parquet").withFileSizeInBytes(10L).withRecordCount(2L).build()).commit();
        ResourcePaths paths = ResourcePaths.forCatalogProperties((Map)Maps.newHashMap());
        Answer refsAnswer = invocation -> {
            LoadTableResponse originalResponse = (LoadTableResponse)invocation.callRealMethod();
            TableMetadata fullTableMetadata = originalResponse.tableMetadata();
            Set referencedSnapshotIds = fullTableMetadata.refs().values().stream().map(SnapshotRef::snapshotId).collect(Collectors.toSet());
            TableMetadata refsMetadata = fullTableMetadata.removeSnapshotsIf(s -> !referencedSnapshotIds.contains(s.snapshotId()));
            return LoadTableResponse.builder().withTableMetadata(refsMetadata).addAllConfig(originalResponse.config()).build();
        };
        ((RESTCatalogAdapter)Mockito.doAnswer((Answer)refsAnswer).when((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)paths.table(TABLE)), (Map)ArgumentMatchers.eq((Object)ImmutableMap.of((Object)"snapshots", (Object)"refs")), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(LoadTableResponse.class), (Map)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any());
        Table refsTables = catalog.loadTable(TABLE);
        Assertions.assertThat((Object)refsTables.currentSnapshot()).isEqualTo((Object)table.currentSnapshot());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter, (VerificationMode)Mockito.times((int)1))).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)paths.table(TABLE)), (Map)ArgumentMatchers.eq((Object)ImmutableMap.of((Object)"snapshots", (Object)"refs")), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(LoadTableResponse.class), (Map)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any());
        Assertions.assertThat((Iterable)refsTables.snapshots()).containsExactlyInAnyOrderElementsOf(table.snapshots());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter, (VerificationMode)Mockito.times((int)1))).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)paths.table(TABLE)), (Map)ArgumentMatchers.eq((Object)ImmutableMap.of((Object)"snapshots", (Object)"all")), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(LoadTableResponse.class), (Map)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @ValueSource(strings={"1", "2"})
    public void testTableSnapshotLoadingWithDivergedBranches(String formatVersion) {
        RESTCatalogAdapter adapter = (RESTCatalogAdapter)Mockito.spy((Object)new RESTCatalogAdapter((Catalog)this.backendCatalog));
        RESTCatalog catalog = new RESTCatalog(SessionCatalog.SessionContext.createEmpty(), config -> adapter);
        catalog.initialize("test", (Map)ImmutableMap.of((Object)"uri", (Object)"ignored", (Object)"io-impl", (Object)"org.apache.iceberg.inmemory.InMemoryFileIO", (Object)"snapshot-loading-mode", (Object)"refs"));
        Table table = catalog.createTable(TABLE, SCHEMA, PartitionSpec.unpartitioned(), (Map)ImmutableMap.of((Object)"format-version", (Object)formatVersion));
        table.newFastAppend().appendFile(DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withPath("/path/to/data-a.parquet").withFileSizeInBytes(10L).withRecordCount(2L).build()).commit();
        String branch = "divergedBranch";
        table.manageSnapshots().createBranch(branch, table.currentSnapshot().snapshotId()).commit();
        ((AppendFiles)table.newFastAppend().appendFile(DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withPath("/path/to/data-b.parquet").withFileSizeInBytes(10L).withRecordCount(2L).build()).toBranch(branch)).commit();
        ResourcePaths paths = ResourcePaths.forCatalogProperties((Map)Maps.newHashMap());
        Answer refsAnswer = invocation -> {
            LoadTableResponse originalResponse = (LoadTableResponse)invocation.callRealMethod();
            TableMetadata fullTableMetadata = originalResponse.tableMetadata();
            Set referencedSnapshotIds = fullTableMetadata.refs().values().stream().map(SnapshotRef::snapshotId).collect(Collectors.toSet());
            TableMetadata refsMetadata = fullTableMetadata.removeSnapshotsIf(s -> !referencedSnapshotIds.contains(s.snapshotId()));
            return LoadTableResponse.builder().withTableMetadata(refsMetadata).addAllConfig(originalResponse.config()).build();
        };
        ((RESTCatalogAdapter)Mockito.doAnswer((Answer)refsAnswer).when((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)paths.table(TABLE)), (Map)ArgumentMatchers.eq((Object)ImmutableMap.of((Object)"snapshots", (Object)"refs")), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(LoadTableResponse.class), (Map)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any());
        Table refsTables = catalog.loadTable(TABLE);
        Assertions.assertThat((Object)refsTables.currentSnapshot()).isEqualTo((Object)table.currentSnapshot());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter, (VerificationMode)Mockito.times((int)1))).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)paths.table(TABLE)), (Map)ArgumentMatchers.eq((Object)ImmutableMap.of((Object)"snapshots", (Object)"refs")), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(LoadTableResponse.class), (Map)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any());
        Assertions.assertThat((Iterable)catalog.loadTable(TABLE).snapshots()).containsExactlyInAnyOrderElementsOf(table.snapshots());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter, (VerificationMode)Mockito.times((int)1))).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)paths.table(TABLE)), (Map)ArgumentMatchers.eq((Object)ImmutableMap.of((Object)"snapshots", (Object)"all")), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(LoadTableResponse.class), (Map)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any());
        ((AppendFiles)catalog.loadTable(TABLE).newAppend().appendFile(DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withPath("/path/to/data-c.parquet").withFileSizeInBytes(10L).withRecordCount(2L).build()).toBranch(branch)).commit();
        Assertions.assertThat((Iterable)catalog.loadTable(TABLE).snapshots()).hasSizeGreaterThan(Lists.newArrayList((Iterable)table.snapshots()).size());
    }

    public void testTableAuth(String catalogToken, Map<String, String> credentials, Map<String, String> tableConfig, Map<String, String> expectedContextHeaders, Map<String, String> expectedTableHeaders) {
        TableIdentifier ident = TableIdentifier.of((String[])new String[]{"ns", "table"});
        ImmutableMap catalogHeaders = ImmutableMap.of((Object)"Authorization", (Object)("Bearer " + catalogToken));
        RESTCatalogAdapter adapter = (RESTCatalogAdapter)Mockito.spy((Object)new RESTCatalogAdapter((Catalog)this.backendCatalog));
        Answer addTableConfig = invocation -> {
            LoadTableResponse loadTable = (LoadTableResponse)invocation.callRealMethod();
            return LoadTableResponse.builder().withTableMetadata(loadTable.tableMetadata()).addAllConfig(loadTable.config()).addAllConfig(tableConfig).build();
        };
        ((RESTCatalogAdapter)Mockito.doAnswer((Answer)addTableConfig).when((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/namespaces/ns/tables"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(LoadTableResponse.class), (Map)ArgumentMatchers.eq(expectedContextHeaders), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.doAnswer((Answer)addTableConfig).when((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/namespaces/ns/tables/table"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(LoadTableResponse.class), (Map)ArgumentMatchers.eq(expectedContextHeaders), (Consumer)ArgumentMatchers.any());
        SessionCatalog.SessionContext context = new SessionCatalog.SessionContext(UUID.randomUUID().toString(), "user", credentials, (Map)ImmutableMap.of());
        RESTCatalog catalog = new RESTCatalog(context, config -> adapter);
        catalog.initialize("prod", (Map)ImmutableMap.of((Object)"uri", (Object)"ignored", (Object)"token", (Object)catalogToken));
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        Table table = catalog.createTable(ident, expectedSchema);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedSchema.asStruct(), (Object)table.schema().asStruct(), (String)"Schema should match");
        Table loaded = catalog.loadTable(ident);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedSchema.asStruct(), (Object)loaded.schema().asStruct(), (String)"Schema should match");
        loaded.refresh();
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/config"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(ConfigResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/namespaces/ns/tables"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(LoadTableResponse.class), (Map)ArgumentMatchers.eq(expectedContextHeaders), (Consumer)ArgumentMatchers.any());
        if (!tableConfig.containsKey("token")) {
            ((RESTCatalogAdapter)Mockito.verify((Object)adapter, (VerificationMode)Mockito.times((int)2))).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.eq(expectedContextHeaders), (Consumer)ArgumentMatchers.any());
        }
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/namespaces/ns/tables/table"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(LoadTableResponse.class), (Map)ArgumentMatchers.eq(expectedTableHeaders), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/namespaces/ns/tables/table"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(LoadTableResponse.class), (Map)ArgumentMatchers.eq(expectedContextHeaders), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/namespaces/ns/tables/table"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(LoadTableResponse.class), (Map)ArgumentMatchers.eq(expectedTableHeaders), (Consumer)ArgumentMatchers.any());
    }

    @Test
    public void testCatalogTokenRefresh() {
        ImmutableMap emptyHeaders = ImmutableMap.of();
        ImmutableMap catalogHeaders = ImmutableMap.of((Object)"Authorization", (Object)"Bearer client-credentials-token:sub=catalog");
        RESTCatalogAdapter adapter = (RESTCatalogAdapter)Mockito.spy((Object)new RESTCatalogAdapter((Catalog)this.backendCatalog));
        Answer addOneSecondExpiration = invocation -> {
            OAuthTokenResponse response = (OAuthTokenResponse)invocation.callRealMethod();
            return OAuthTokenResponse.builder().withToken(response.token()).withTokenType(response.tokenType()).withIssuedTokenType(response.issuedTokenType()).addScopes(response.scopes()).setExpirationInSeconds(1).build();
        };
        ((RESTCatalogAdapter)Mockito.doAnswer((Answer)addOneSecondExpiration).when((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any());
        ImmutableMap contextCredentials = ImmutableMap.of();
        SessionCatalog.SessionContext context = new SessionCatalog.SessionContext(UUID.randomUUID().toString(), "user", (Map)contextCredentials, (Map)ImmutableMap.of());
        RESTCatalog catalog = new RESTCatalog(context, config -> adapter);
        catalog.initialize("prod", (Map)ImmutableMap.of((Object)"uri", (Object)"ignored", (Object)"credential", (Object)"catalog:secret"));
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> TestRESTCatalog.lambda$testCatalogTokenRefresh$20(adapter, (Map)emptyHeaders, (Map)catalogHeaders));
    }

    @Test
    public void testCatalogRefreshedTokenIsUsed() {
        ImmutableMap emptyHeaders = ImmutableMap.of();
        ImmutableMap catalogHeaders = ImmutableMap.of((Object)"Authorization", (Object)"Bearer client-credentials-token:sub=catalog");
        RESTCatalogAdapter adapter = (RESTCatalogAdapter)Mockito.spy((Object)new RESTCatalogAdapter((Catalog)this.backendCatalog));
        Answer addOneSecondExpiration = invocation -> {
            OAuthTokenResponse response = (OAuthTokenResponse)invocation.callRealMethod();
            return OAuthTokenResponse.builder().withToken(response.token()).withTokenType(response.tokenType()).withIssuedTokenType(response.issuedTokenType()).addScopes(response.scopes()).setExpirationInSeconds(1).build();
        };
        ((RESTCatalogAdapter)Mockito.doAnswer((Answer)addOneSecondExpiration).when((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any());
        ImmutableMap contextCredentials = ImmutableMap.of();
        SessionCatalog.SessionContext context = new SessionCatalog.SessionContext(UUID.randomUUID().toString(), "user", (Map)contextCredentials, (Map)ImmutableMap.of());
        RESTCatalog catalog = new RESTCatalog(context, config -> adapter);
        catalog.initialize("prod", (Map)ImmutableMap.of((Object)"uri", (Object)"ignored", (Object)"credential", (Object)"catalog:secret"));
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> TestRESTCatalog.lambda$testCatalogRefreshedTokenIsUsed$23(catalog, adapter, (Map)emptyHeaders, (Map)catalogHeaders));
    }

    @Test
    public void testCatalogWithCustomMetricsReporter() throws IOException {
        this.restCatalog = new RESTCatalog(new SessionCatalog.SessionContext(UUID.randomUUID().toString(), "user", (Map)ImmutableMap.of((Object)"credential", (Object)"user:12345"), (Map)ImmutableMap.of()), config -> HTTPClient.builder((Map)config).uri((String)config.get("uri")).build());
        this.restCatalog.setConf((Object)new Configuration());
        this.restCatalog.initialize("prod", (Map)ImmutableMap.of((Object)"uri", (Object)this.httpServer.getURI().toString(), (Object)"credential", (Object)"catalog:12345", (Object)"metrics-reporter-impl", (Object)CustomMetricsReporter.class.getName()));
        this.restCatalog.buildTable(TABLE, SCHEMA).create();
        Table table = this.restCatalog.loadTable(TABLE);
        table.newFastAppend().appendFile(DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withPath("/path/to/data-a.parquet").withFileSizeInBytes(10L).withRecordCount(2L).build()).commit();
        try (CloseableIterable tasks = table.newScan().planFiles();){
            Assertions.assertThat((Iterator)tasks.iterator()).hasNext();
        }
        Assertions.assertThat((int)CustomMetricsReporter.COUNTER.get()).isEqualTo(2);
    }

    @Test
    public void testCatalogExpiredBearerTokenRefreshWithoutCredential() {
        String token = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiaWF0IjoxNTE2MjM5MDIyLCJleHAiOjF9.gQADTbdEv-rpDWKSkGLbmafyB5UUjTdm9B_1izpuZ6E";
        RESTCatalogAdapter adapter = (RESTCatalogAdapter)Mockito.spy((Object)new RESTCatalogAdapter((Catalog)this.backendCatalog));
        ImmutableMap contextCredentials = ImmutableMap.of((Object)"token", (Object)token);
        SessionCatalog.SessionContext context = new SessionCatalog.SessionContext(UUID.randomUUID().toString(), "user", (Map)contextCredentials, (Map)ImmutableMap.of());
        RESTCatalog catalog = new RESTCatalog(context, config -> adapter);
        catalog.initialize("prod", (Map)ImmutableMap.of((Object)"uri", (Object)"ignored", (Object)"token", (Object)token));
    }

    @Test
    public void testCatalogExpiredBearerTokenIsRefreshedWithCredential() {
        String token = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiaWF0IjoxNTE2MjM5MDIyLCJleHAiOjF9.gQADTbdEv-rpDWKSkGLbmafyB5UUjTdm9B_1izpuZ6E";
        ImmutableMap emptyHeaders = ImmutableMap.of();
        ImmutableMap catalogHeaders = ImmutableMap.of((Object)"Authorization", (Object)"Bearer client-credentials-token:sub=catalog");
        RESTCatalogAdapter adapter = (RESTCatalogAdapter)Mockito.spy((Object)new RESTCatalogAdapter((Catalog)this.backendCatalog));
        String credential = "catalog:12345";
        ImmutableMap contextCredentials = ImmutableMap.of((Object)"token", (Object)token);
        SessionCatalog.SessionContext context = new SessionCatalog.SessionContext(UUID.randomUUID().toString(), "user", (Map)contextCredentials, (Map)ImmutableMap.of());
        RESTCatalog catalog = new RESTCatalog(context, config -> adapter);
        catalog.initialize("prod", (Map)ImmutableMap.of((Object)"uri", (Object)"ignored", (Object)"credential", (Object)credential));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)catalog.tableExists(TableIdentifier.of((String[])new String[]{"ns", "table"})));
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.eq((Object)emptyHeaders), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/config"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(ConfigResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
        ImmutableMap firstRefreshRequest = ImmutableMap.of((Object)"grant_type", (Object)"urn:ietf:params:oauth:grant-type:token-exchange", (Object)"subject_token", (Object)token, (Object)"subject_token_type", (Object)"urn:ietf:params:oauth:token-type:access_token", (Object)"scope", (Object)"catalog");
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), Mockito.argThat(((Map)firstRefreshRequest)::equals), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.eq((Object)OAuth2Util.basicAuthHeaders((String)credential)), (Consumer)ArgumentMatchers.any());
        ImmutableMap secondRefreshRequest = ImmutableMap.of((Object)"grant_type", (Object)"urn:ietf:params:oauth:grant-type:token-exchange", (Object)"subject_token", (Object)token, (Object)"subject_token_type", (Object)"urn:ietf:params:oauth:token-type:access_token", (Object)"scope", (Object)"catalog");
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), Mockito.argThat(((Map)secondRefreshRequest)::equals), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.eq((Object)OAuth2Util.basicAuthHeaders((String)credential)), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/namespaces/ns/tables/table"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(LoadTableResponse.class), (Map)ArgumentMatchers.eq((Object)ImmutableMap.of((Object)"Authorization", (Object)("Bearer token-exchange-token:sub=" + token))), (Consumer)ArgumentMatchers.any());
    }

    @Test
    public void testCatalogValidBearerTokenIsNotRefreshed() {
        String token = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiaWF0IjoxNTE2MjM5MDIyLCJleHAiOjE5OTk5OTk5OTk5fQ._3k92KJi2NTyTG6V1s2mzJ__GiQtL36DnzsZSkBdYPw";
        ImmutableMap catalogHeaders = ImmutableMap.of((Object)"Authorization", (Object)("Bearer " + token));
        RESTCatalogAdapter adapter = (RESTCatalogAdapter)Mockito.spy((Object)new RESTCatalogAdapter((Catalog)this.backendCatalog));
        String credential = "catalog:12345";
        ImmutableMap contextCredentials = ImmutableMap.of((Object)"token", (Object)token, (Object)"credential", (Object)credential);
        SessionCatalog.SessionContext context = new SessionCatalog.SessionContext(UUID.randomUUID().toString(), "user", (Map)contextCredentials, (Map)ImmutableMap.of());
        RESTCatalog catalog = new RESTCatalog(context, config -> adapter);
        catalog.initialize("prod", (Map)ImmutableMap.of((Object)"uri", (Object)"ignored", (Object)"token", (Object)token));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)catalog.tableExists(TableIdentifier.of((String[])new String[]{"ns", "table"})));
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/config"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(ConfigResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/namespaces/ns/tables/table"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(LoadTableResponse.class), (Map)ArgumentMatchers.eq((Object)OAuth2Util.authHeaders((String)token)), (Consumer)ArgumentMatchers.any());
    }

    @Test
    public void testCatalogTokenRefreshFailsAndUsesCredentialForRefresh() {
        ImmutableMap emptyHeaders = ImmutableMap.of();
        ImmutableMap catalogHeaders = ImmutableMap.of((Object)"Authorization", (Object)"Bearer client-credentials-token:sub=catalog");
        String credential = "catalog:secret";
        Map basicHeaders = OAuth2Util.basicAuthHeaders((String)credential);
        RESTCatalogAdapter adapter = (RESTCatalogAdapter)Mockito.spy((Object)new RESTCatalogAdapter((Catalog)this.backendCatalog));
        Answer addOneSecondExpiration = invocation -> {
            OAuthTokenResponse response = (OAuthTokenResponse)invocation.callRealMethod();
            return OAuthTokenResponse.builder().withToken(response.token()).withTokenType(response.tokenType()).withIssuedTokenType(response.issuedTokenType()).addScopes(response.scopes()).setExpirationInSeconds(1).build();
        };
        ((RESTCatalogAdapter)Mockito.doAnswer((Answer)addOneSecondExpiration).when((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any());
        ImmutableMap firstRefreshRequest = ImmutableMap.of((Object)"grant_type", (Object)"urn:ietf:params:oauth:grant-type:token-exchange", (Object)"subject_token", (Object)"client-credentials-token:sub=catalog", (Object)"subject_token_type", (Object)"urn:ietf:params:oauth:token-type:access_token", (Object)"scope", (Object)"catalog");
        ((RESTCatalogAdapter)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("token expired")}).when((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), Mockito.argThat(((Map)firstRefreshRequest)::equals), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
        ImmutableMap contextCredentials = ImmutableMap.of();
        SessionCatalog.SessionContext context = new SessionCatalog.SessionContext(UUID.randomUUID().toString(), "user", (Map)contextCredentials, (Map)ImmutableMap.of());
        AuthSessionUtil.setTokenRefreshNumRetries(1);
        RESTCatalog catalog = new RESTCatalog(context, config -> adapter);
        catalog.initialize("prod", (Map)ImmutableMap.of((Object)"uri", (Object)"ignored", (Object)"credential", (Object)credential));
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> TestRESTCatalog.lambda$testCatalogTokenRefreshFailsAndUsesCredentialForRefresh$30(catalog, adapter, (Map)emptyHeaders, (Map)catalogHeaders, (Map)firstRefreshRequest, basicHeaders));
    }

    @Test
    public void testCatalogWithCustomTokenScope() {
        ImmutableMap emptyHeaders = ImmutableMap.of();
        ImmutableMap catalogHeaders = ImmutableMap.of((Object)"Authorization", (Object)"Bearer client-credentials-token:sub=catalog");
        RESTCatalogAdapter adapter = (RESTCatalogAdapter)Mockito.spy((Object)new RESTCatalogAdapter((Catalog)this.backendCatalog));
        Answer addOneSecondExpiration = invocation -> {
            OAuthTokenResponse response = (OAuthTokenResponse)invocation.callRealMethod();
            return OAuthTokenResponse.builder().withToken(response.token()).withTokenType(response.tokenType()).withIssuedTokenType(response.issuedTokenType()).addScopes(response.scopes()).setExpirationInSeconds(1).build();
        };
        ((RESTCatalogAdapter)Mockito.doAnswer((Answer)addOneSecondExpiration).when((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any());
        ImmutableMap contextCredentials = ImmutableMap.of();
        SessionCatalog.SessionContext context = new SessionCatalog.SessionContext(UUID.randomUUID().toString(), "user", (Map)contextCredentials, (Map)ImmutableMap.of());
        RESTCatalog catalog = new RESTCatalog(context, config -> adapter);
        String scope = "custom_catalog_scope";
        catalog.initialize("prod", (Map)ImmutableMap.of((Object)"uri", (Object)"ignored", (Object)"credential", (Object)"catalog:secret", (Object)"scope", (Object)scope));
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> TestRESTCatalog.lambda$testCatalogWithCustomTokenScope$33(adapter, (Map)emptyHeaders, (Map)catalogHeaders, scope));
    }

    public void testCatalogTokenRefreshDisabledWithToken() {
        String token = "some-token";
        ImmutableMap catalogHeaders = ImmutableMap.of((Object)"Authorization", (Object)("Bearer " + token));
        RESTCatalogAdapter adapter = (RESTCatalogAdapter)Mockito.spy((Object)new RESTCatalogAdapter((Catalog)this.backendCatalog));
        Answer addOneSecondExpiration = invocation -> {
            OAuthTokenResponse response = (OAuthTokenResponse)invocation.callRealMethod();
            return OAuthTokenResponse.builder().withToken(response.token()).withTokenType(response.tokenType()).withIssuedTokenType(response.issuedTokenType()).addScopes(response.scopes()).setExpirationInSeconds(1).build();
        };
        ((RESTCatalogAdapter)Mockito.doAnswer((Answer)addOneSecondExpiration).when((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any());
        ImmutableMap contextCredentials = ImmutableMap.of();
        SessionCatalog.SessionContext context = new SessionCatalog.SessionContext(UUID.randomUUID().toString(), "user", (Map)contextCredentials, (Map)ImmutableMap.of());
        RESTCatalog catalog = new RESTCatalog(context, config -> adapter);
        catalog.initialize("prod", (Map)ImmutableMap.of((Object)"uri", (Object)"ignored", (Object)"token", (Object)token, (Object)"token-refresh-enabled", (Object)"false"));
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/config"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(ConfigResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
    }

    @Test
    public void testCatalogTokenRefreshDisabledWithCredential() {
        ImmutableMap catalogHeaders = ImmutableMap.of((Object)"Authorization", (Object)"Bearer client-credentials-token:sub=catalog");
        RESTCatalogAdapter adapter = (RESTCatalogAdapter)Mockito.spy((Object)new RESTCatalogAdapter((Catalog)this.backendCatalog));
        SessionCatalog.SessionContext context = new SessionCatalog.SessionContext(UUID.randomUUID().toString(), "user", (Map)ImmutableMap.of(), (Map)ImmutableMap.of());
        RESTCatalog catalog = new RESTCatalog(context, config -> adapter);
        catalog.initialize("prod", (Map)ImmutableMap.of((Object)"uri", (Object)"ignored", (Object)"credential", (Object)"catalog:12345", (Object)"token-refresh-enabled", (Object)"false"));
        ImmutableMap fetchTokenFromCredential = ImmutableMap.of((Object)"grant_type", (Object)"client_credentials", (Object)"client_id", (Object)"catalog", (Object)"client_secret", (Object)"12345", (Object)"scope", (Object)"catalog");
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), Mockito.argThat(((Map)fetchTokenFromCredential)::equals), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.eq((Object)ImmutableMap.of()), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/config"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(ConfigResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
    }

    private static /* synthetic */ void lambda$testCatalogWithCustomTokenScope$33(RESTCatalogAdapter adapter, Map emptyHeaders, Map catalogHeaders, String scope) throws Throwable {
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.eq((Object)emptyHeaders), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/config"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(ConfigResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
        ImmutableMap firstRefreshRequest = ImmutableMap.of((Object)"grant_type", (Object)"urn:ietf:params:oauth:grant-type:token-exchange", (Object)"subject_token", (Object)"client-credentials-token:sub=catalog", (Object)"subject_token_type", (Object)"urn:ietf:params:oauth:token-type:access_token", (Object)"scope", (Object)scope);
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), Mockito.argThat(((Map)firstRefreshRequest)::equals), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
    }

    private static /* synthetic */ void lambda$testCatalogTokenRefreshFailsAndUsesCredentialForRefresh$30(RESTCatalog catalog, RESTCatalogAdapter adapter, Map emptyHeaders, Map catalogHeaders, Map firstRefreshRequest, Map basicHeaders) throws Throwable {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)catalog.tableExists(TableIdentifier.of((String[])new String[]{"ns", "table"})));
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.eq((Object)emptyHeaders), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/config"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(ConfigResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter, (VerificationMode)Mockito.times((int)2))).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), Mockito.argThat(firstRefreshRequest::equals), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), Mockito.argThat(firstRefreshRequest::equals), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.eq((Object)basicHeaders), (Consumer)ArgumentMatchers.any());
        ImmutableMap refreshedCatalogHeader = ImmutableMap.of((Object)"Authorization", (Object)"Bearer token-exchange-token:sub=client-credentials-token:sub=catalog");
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/namespaces/ns/tables/table"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(LoadTableResponse.class), (Map)ArgumentMatchers.eq((Object)refreshedCatalogHeader), (Consumer)ArgumentMatchers.any());
    }

    private static /* synthetic */ void lambda$testCatalogRefreshedTokenIsUsed$23(RESTCatalog catalog, RESTCatalogAdapter adapter, Map emptyHeaders, Map catalogHeaders) throws Throwable {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)catalog.tableExists(TableIdentifier.of((String[])new String[]{"ns", "table"})));
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.eq((Object)emptyHeaders), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/config"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(ConfigResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
        ImmutableMap firstRefreshRequest = ImmutableMap.of((Object)"grant_type", (Object)"urn:ietf:params:oauth:grant-type:token-exchange", (Object)"subject_token", (Object)"client-credentials-token:sub=catalog", (Object)"subject_token_type", (Object)"urn:ietf:params:oauth:token-type:access_token", (Object)"scope", (Object)"catalog");
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), Mockito.argThat(((Map)firstRefreshRequest)::equals), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
        ImmutableMap refreshedCatalogHeader = ImmutableMap.of((Object)"Authorization", (Object)"Bearer token-exchange-token:sub=client-credentials-token:sub=catalog");
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/namespaces/ns/tables/table"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(LoadTableResponse.class), (Map)ArgumentMatchers.eq((Object)refreshedCatalogHeader), (Consumer)ArgumentMatchers.any());
    }

    private static /* synthetic */ void lambda$testCatalogTokenRefresh$20(RESTCatalogAdapter adapter, Map emptyHeaders, Map catalogHeaders) throws Throwable {
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.eq((Object)emptyHeaders), (Consumer)ArgumentMatchers.any());
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.GET))), (String)ArgumentMatchers.eq((Object)"v1/config"), (Map)ArgumentMatchers.any(), ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(ConfigResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
        ImmutableMap firstRefreshRequest = ImmutableMap.of((Object)"grant_type", (Object)"urn:ietf:params:oauth:grant-type:token-exchange", (Object)"subject_token", (Object)"client-credentials-token:sub=catalog", (Object)"subject_token_type", (Object)"urn:ietf:params:oauth:token-type:access_token", (Object)"scope", (Object)"catalog");
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), Mockito.argThat(((Map)firstRefreshRequest)::equals), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.eq((Object)catalogHeaders), (Consumer)ArgumentMatchers.any());
        ImmutableMap secondRefreshRequest = ImmutableMap.of((Object)"grant_type", (Object)"urn:ietf:params:oauth:grant-type:token-exchange", (Object)"subject_token", (Object)"token-exchange-token:sub=client-credentials-token:sub=catalog", (Object)"subject_token_type", (Object)"urn:ietf:params:oauth:token-type:access_token", (Object)"scope", (Object)"catalog");
        ImmutableMap secondRefreshHeaders = ImmutableMap.of((Object)"Authorization", (Object)"Bearer token-exchange-token:sub=client-credentials-token:sub=catalog");
        ((RESTCatalogAdapter)Mockito.verify((Object)adapter)).execute((RESTCatalogAdapter.HTTPMethod)((Object)ArgumentMatchers.eq((Object)((Object)RESTCatalogAdapter.HTTPMethod.POST))), (String)ArgumentMatchers.eq((Object)"v1/oauth/tokens"), (Map)ArgumentMatchers.any(), Mockito.argThat(((Map)secondRefreshRequest)::equals), (Class)ArgumentMatchers.eq(OAuthTokenResponse.class), (Map)ArgumentMatchers.eq((Object)secondRefreshHeaders), (Consumer)ArgumentMatchers.any());
    }

    public static class CustomMetricsReporter
    implements MetricsReporter {
        static final AtomicInteger COUNTER = new AtomicInteger(0);

        public void report(MetricsReport report) {
            COUNTER.incrementAndGet();
        }
    }
}

