/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.iceberg.IcebergBuild;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.rest.ErrorHandler;
import org.apache.iceberg.rest.HTTPClient;
import org.apache.iceberg.rest.HttpMethod;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.RESTObjectMapper;
import org.apache.iceberg.rest.RESTRequest;
import org.apache.iceberg.rest.RESTResponse;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.rest.responses.ErrorResponseParser;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.RequestDefinition;

public class TestHTTPClient {
    private static final int PORT = 1080;
    private static final String BEARER_AUTH_TOKEN = "auth_token";
    private static final String URI = String.format("http://127.0.0.1:%d", 1080);
    private static final ObjectMapper MAPPER = RESTObjectMapper.mapper();
    private static String icebergBuildGitCommitShort;
    private static String icebergBuildFullVersion;
    private static ClientAndServer mockServer;
    private static RESTClient restClient;

    @BeforeClass
    public static void beforeClass() {
        mockServer = ClientAndServer.startClientAndServer((Integer[])new Integer[]{1080});
        restClient = HTTPClient.builder((Map)ImmutableMap.of()).uri(URI).build();
        icebergBuildGitCommitShort = IcebergBuild.gitCommitShortId();
        icebergBuildFullVersion = IcebergBuild.fullVersion();
    }

    @AfterClass
    public static void stopServer() throws IOException {
        mockServer.stop();
        restClient.close();
    }

    @Test
    public void testPostSuccess() throws Exception {
        TestHTTPClient.testHttpMethodOnSuccess(HttpMethod.POST);
    }

    @Test
    public void testPostFailure() throws Exception {
        TestHTTPClient.testHttpMethodOnFailure(HttpMethod.POST);
    }

    @Test
    public void testGetSuccess() throws Exception {
        TestHTTPClient.testHttpMethodOnSuccess(HttpMethod.GET);
    }

    @Test
    public void testGetFailure() throws Exception {
        TestHTTPClient.testHttpMethodOnFailure(HttpMethod.GET);
    }

    @Test
    public void testDeleteSuccess() throws Exception {
        TestHTTPClient.testHttpMethodOnSuccess(HttpMethod.DELETE);
    }

    @Test
    public void testDeleteFailure() throws Exception {
        TestHTTPClient.testHttpMethodOnFailure(HttpMethod.DELETE);
    }

    @Test
    public void testHeadSuccess() throws JsonProcessingException {
        TestHTTPClient.testHttpMethodOnSuccess(HttpMethod.HEAD);
    }

    @Test
    public void testHeadFailure() throws JsonProcessingException {
        TestHTTPClient.testHttpMethodOnFailure(HttpMethod.HEAD);
    }

    @Test
    public void testDynamicHttpRequestInterceptorLoading() {
        ImmutableMap properties = ImmutableMap.of((Object)"key", (Object)"val");
        HttpRequestInterceptor interceptor = HTTPClient.loadInterceptorDynamically((String)TestHttpRequestInterceptor.class.getName(), (Map)properties);
        Assertions.assertThat((Object)interceptor).isInstanceOf(TestHttpRequestInterceptor.class);
        Assertions.assertThat((Map)((TestHttpRequestInterceptor)interceptor).properties).isEqualTo((Object)properties);
    }

    public static void testHttpMethodOnSuccess(HttpMethod method) throws JsonProcessingException {
        Item body = new Item(0L, "hank");
        int statusCode = 200;
        ErrorHandler onError = (ErrorHandler)Mockito.mock(ErrorHandler.class);
        ((ErrorHandler)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Failure response")}).when((Object)onError)).accept((Object)((ErrorResponse)ArgumentMatchers.any()));
        String path = TestHTTPClient.addRequestTestCaseAndGetPath(method, body, statusCode);
        Item successResponse = TestHTTPClient.doExecuteRequest(method, path, body, onError, h -> {
            MapAssert cfr_ignored_0 = (MapAssert)Assertions.assertThat((Map)h).isNotEmpty();
        });
        if (method.usesRequestBody()) {
            Assert.assertEquals((String)("On a successful " + (Object)((Object)method) + ", the correct response body should be returned"), (Object)successResponse, (Object)body);
        }
        ((ErrorHandler)Mockito.verify((Object)onError, (VerificationMode)Mockito.never())).accept((Object)((ErrorResponse)ArgumentMatchers.any()));
    }

    public static void testHttpMethodOnFailure(HttpMethod method) throws JsonProcessingException {
        Item body = new Item(0L, "hank");
        int statusCode = 404;
        ErrorHandler onError = (ErrorHandler)Mockito.mock(ErrorHandler.class);
        ((ErrorHandler)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException(String.format("Called error handler for method %s due to status code: %d", new Object[]{method, statusCode}))}).when((Object)onError)).accept((Object)((ErrorResponse)ArgumentMatchers.any()));
        String path = TestHTTPClient.addRequestTestCaseAndGetPath(method, body, statusCode);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestHTTPClient.doExecuteRequest(method, path, body, onError, h -> {})).isInstanceOf(RuntimeException.class)).hasMessage(String.format("Called error handler for method %s due to status code: %d", new Object[]{method, statusCode}));
        ((ErrorHandler)Mockito.verify((Object)onError)).accept((Object)((ErrorResponse)ArgumentMatchers.any()));
    }

    private static String addRequestTestCaseAndGetPath(HttpMethod method, Item body, int statusCode) throws JsonProcessingException {
        boolean isSuccess = statusCode == 200;
        String pathName = isSuccess ? "success" : "failure";
        String path = String.format("%s_%s", new Object[]{method, pathName});
        String asJson = body != null ? MAPPER.writeValueAsString((Object)body) : null;
        org.mockserver.model.HttpRequest mockRequest = org.mockserver.model.HttpRequest.request((String)("/" + path)).withMethod(method.name().toUpperCase(Locale.ROOT)).withHeader("Authorization", new String[]{"Bearer auth_token"}).withHeader("X-Client-Version", new String[]{icebergBuildFullVersion}).withHeader("X-Client-Git-Commit-Short", new String[]{icebergBuildGitCommitShort});
        if (method.usesRequestBody()) {
            mockRequest = mockRequest.withBody(asJson);
        }
        HttpResponse mockResponse = HttpResponse.response().withStatusCode(Integer.valueOf(statusCode));
        if (method.usesResponseBody()) {
            if (isSuccess) {
                mockResponse = mockResponse.withBody(asJson);
            } else {
                ErrorResponse response = ErrorResponse.builder().responseCode(Integer.valueOf(statusCode)).withMessage("Not found").build();
                mockResponse = mockResponse.withBody(ErrorResponseParser.toJson((ErrorResponse)response));
            }
        }
        mockServer.when((RequestDefinition)mockRequest).respond(mockResponse);
        return path;
    }

    private static Item doExecuteRequest(HttpMethod method, String path, Item body, ErrorHandler onError, Consumer<Map<String, String>> responseHeaders) {
        ImmutableMap headers = ImmutableMap.of((Object)"Authorization", (Object)"Bearer auth_token");
        switch (method) {
            case POST: {
                return (Item)restClient.post(path, (RESTRequest)body, Item.class, (Map)headers, (Consumer)onError, responseHeaders);
            }
            case GET: {
                return (Item)restClient.get(path, Item.class, (Map)headers, (Consumer)onError);
            }
            case HEAD: {
                restClient.head(path, (Map)headers, (Consumer)onError);
                return null;
            }
            case DELETE: {
                return (Item)restClient.delete(path, Item.class, () -> TestHTTPClient.lambda$doExecuteRequest$3((Map)headers), (Consumer)onError);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid method: %s", new Object[]{method}));
    }

    private static /* synthetic */ Map lambda$doExecuteRequest$3(Map headers) {
        return headers;
    }

    public static class TestHttpRequestInterceptor
    implements HttpRequestInterceptor {
        private Map<String, String> properties;

        public void initialize(Map<String, String> props) {
            this.properties = props;
        }

        public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        }
    }

    public static class Item
    implements RESTRequest,
    RESTResponse {
        private Long id;
        private String data;

        public Item() {
        }

        public Item(Long id, String data) {
            this.id = id;
            this.data = data;
        }

        public void validate() {
        }

        public int hashCode() {
            return Objects.hash(this.id, this.data);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            return Objects.equals(this.id, item.id) && Objects.equals(this.data, item.data);
        }
    }
}

