/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashSet;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.rest.RESTMessage;
import org.apache.iceberg.rest.RESTObjectMapper;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public abstract class RequestResponseTestBase<T extends RESTMessage> {
    private static final ObjectMapper MAPPER = RESTObjectMapper.mapper();

    public static ObjectMapper mapper() {
        return MAPPER;
    }

    public abstract String[] allFieldsFromSpec();

    public abstract T createExampleInstance();

    public abstract void assertEquals(T var1, T var2);

    public abstract T deserialize(String var1) throws JsonProcessingException;

    public String serialize(T object) throws JsonProcessingException {
        return MAPPER.writeValueAsString(object);
    }

    @Test
    public void testHasOnlyKnownFields() {
        HashSet fieldsFromSpec = Sets.newHashSet();
        Collections.addAll(fieldsFromSpec, this.allFieldsFromSpec());
        try {
            JsonNode node = (JsonNode)RequestResponseTestBase.mapper().readValue(this.serialize(this.createExampleInstance()), JsonNode.class);
            for (String field : fieldsFromSpec) {
                Assert.assertTrue((String)("Should have field: " + field), (boolean)node.has(field));
            }
            for (String field : () -> ((JsonNode)node).fieldNames()) {
                Assert.assertTrue((String)("Should not have field: " + field), (boolean)fieldsFromSpec.contains(field));
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    protected void assertRoundTripSerializesEquallyFrom(String json, T expected) throws JsonProcessingException {
        T actual = this.deserialize(json);
        this.assertEquals(actual, expected);
        Assertions.assertThat((String)this.serialize(expected)).isEqualTo(json);
    }
}

