/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.iceberg.exceptions.RESTException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.io.CharStreams;
import org.apache.iceberg.rest.RESTCatalogAdapter;
import org.apache.iceberg.rest.RESTObjectMapper;
import org.apache.iceberg.rest.RESTResponse;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTCatalogServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(RESTCatalogServlet.class);
    private final RESTCatalogAdapter restCatalogAdapter;
    private final Map<String, String> responseHeaders = ImmutableMap.of((Object)"Content-Type", (Object)ContentType.APPLICATION_JSON.getMimeType());

    public RESTCatalogServlet(RESTCatalogAdapter restCatalogAdapter) {
        this.restCatalogAdapter = restCatalogAdapter;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.execute(ServletRequestContext.from(request), response);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.execute(ServletRequestContext.from(request), response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.execute(ServletRequestContext.from(request), response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.execute(ServletRequestContext.from(request), response);
    }

    protected void execute(ServletRequestContext context, HttpServletResponse response) throws IOException {
        response.setStatus(200);
        this.responseHeaders.forEach((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1));
        if (context.error().isPresent()) {
            response.setStatus(400);
            RESTObjectMapper.mapper().writeValue((Writer)response.getWriter(), (Object)context.error().get());
            return;
        }
        try {
            RESTResponse responseBody = this.restCatalogAdapter.execute(context.method(), context.path(), context.queryParams(), context.body(), context.route().responseClass(), context.headers(), this.handle(response));
            if (responseBody != null) {
                RESTObjectMapper.mapper().writeValue((Writer)response.getWriter(), (Object)responseBody);
            }
        }
        catch (RESTException e) {
            LOG.error("Error processing REST request", (Throwable)e);
            response.setStatus(500);
        }
        catch (Exception e) {
            LOG.error("Unexpected exception when processing REST request", (Throwable)e);
            response.setStatus(500);
        }
    }

    protected Consumer<ErrorResponse> handle(HttpServletResponse response) {
        return errorResponse -> {
            response.setStatus(errorResponse.code().intValue());
            try {
                RESTObjectMapper.mapper().writeValue((Writer)response.getWriter(), errorResponse);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public static class ServletRequestContext {
        private RESTCatalogAdapter.HTTPMethod method;
        private RESTCatalogAdapter.Route route;
        private String path;
        private Map<String, String> headers;
        private Map<String, String> queryParams;
        private Object body;
        private ErrorResponse errorResponse;

        private ServletRequestContext(ErrorResponse errorResponse) {
            this.errorResponse = errorResponse;
        }

        private ServletRequestContext(RESTCatalogAdapter.HTTPMethod method, RESTCatalogAdapter.Route route, String path, Map<String, String> headers, Map<String, String> queryParams, Object body) {
            this.method = method;
            this.route = route;
            this.path = path;
            this.headers = headers;
            this.queryParams = queryParams;
            this.body = body;
        }

        static ServletRequestContext from(HttpServletRequest request) throws IOException {
            String path;
            RESTCatalogAdapter.HTTPMethod method = RESTCatalogAdapter.HTTPMethod.valueOf(request.getMethod());
            Pair<RESTCatalogAdapter.Route, Map<String, String>> routeContext = RESTCatalogAdapter.Route.from(method, path = request.getRequestURI().substring(1));
            if (routeContext == null) {
                return new ServletRequestContext(ErrorResponse.builder().responseCode(Integer.valueOf(400)).withType("BadRequestException").withMessage(String.format("No route for request: %s %s", new Object[]{method, path})).build());
            }
            RESTCatalogAdapter.Route route = (RESTCatalogAdapter.Route)((Object)routeContext.first());
            Object requestBody = null;
            if (route.requestClass() != null) {
                requestBody = RESTObjectMapper.mapper().readValue((Reader)request.getReader(), route.requestClass());
            } else if (route == RESTCatalogAdapter.Route.TOKENS) {
                try (InputStreamReader reader = new InputStreamReader((InputStream)request.getInputStream());){
                    requestBody = RESTUtil.decodeFormData((String)CharStreams.toString((Readable)reader));
                }
            }
            Map<String, String> queryParams = request.getParameterMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((String[])e.getValue())[0]));
            Map<String, String> headers = Collections.list(request.getHeaderNames()).stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)));
            return new ServletRequestContext(method, route, path, headers, queryParams, requestBody);
        }

        public RESTCatalogAdapter.HTTPMethod method() {
            return this.method;
        }

        public RESTCatalogAdapter.Route route() {
            return this.route;
        }

        public String path() {
            return this.path;
        }

        public Map<String, String> headers() {
            return this.headers;
        }

        public Map<String, String> queryParams() {
            return this.queryParams;
        }

        public Object body() {
            return this.body;
        }

        public Optional<ErrorResponse> error() {
            return Optional.ofNullable(this.errorResponse);
        }
    }
}

