/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.ForbiddenException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchIcebergTableException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NotAuthorizedException;
import org.apache.iceberg.exceptions.RESTException;
import org.apache.iceberg.exceptions.UnprocessableEntityException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.rest.CatalogHandlers;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.RESTRequest;
import org.apache.iceberg.rest.RESTResponse;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.ReportMetricsRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ConfigResponse;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.OAuthTokenResponse;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.PropertyUtil;

public class RESTCatalogAdapter
implements RESTClient {
    private static final Splitter SLASH = Splitter.on((char)'/');
    private static final Map<Class<? extends Exception>, Integer> EXCEPTION_ERROR_CODES = ImmutableMap.builder().put(IllegalArgumentException.class, (Object)400).put(ValidationException.class, (Object)400).put(NamespaceNotEmptyException.class, (Object)400).put(NotAuthorizedException.class, (Object)401).put(ForbiddenException.class, (Object)403).put(NoSuchNamespaceException.class, (Object)404).put(NoSuchTableException.class, (Object)404).put(NoSuchIcebergTableException.class, (Object)404).put(UnsupportedOperationException.class, (Object)406).put(AlreadyExistsException.class, (Object)409).put(CommitFailedException.class, (Object)409).put(UnprocessableEntityException.class, (Object)422).put(CommitStateUnknownException.class, (Object)500).buildOrThrow();
    private final Catalog catalog;
    private final SupportsNamespaces asNamespaceCatalog;

    public RESTCatalogAdapter(Catalog catalog) {
        this.catalog = catalog;
        this.asNamespaceCatalog = catalog instanceof SupportsNamespaces ? (SupportsNamespaces)catalog : null;
    }

    public <T extends RESTResponse> T handleRequest(Route route, Map<String, String> vars, Object body, Class<T> responseType) {
        switch (route) {
            case TOKENS: {
                String grantType;
                Map request = RESTCatalogAdapter.castRequest(Map.class, body);
                switch (grantType = (String)request.get("grant_type")) {
                    case "client_credentials": {
                        return RESTCatalogAdapter.castResponse(responseType, OAuthTokenResponse.builder().withToken("client-credentials-token:sub=" + (String)request.get("client_id")).withIssuedTokenType("urn:ietf:params:oauth:token-type:access_token").withTokenType("Bearer").build());
                    }
                    case "urn:ietf:params:oauth:grant-type:token-exchange": {
                        String actor = (String)request.get("actor_token");
                        String token = String.format("token-exchange-token:sub=%s%s", request.get("subject_token"), actor != null ? ",act=" + actor : "");
                        return RESTCatalogAdapter.castResponse(responseType, OAuthTokenResponse.builder().withToken(token).withIssuedTokenType("urn:ietf:params:oauth:token-type:access_token").withTokenType("Bearer").build());
                    }
                }
                throw new UnsupportedOperationException("Unsupported grant_type: " + grantType);
            }
            case CONFIG: {
                return RESTCatalogAdapter.castResponse(responseType, ConfigResponse.builder().build());
            }
            case LIST_NAMESPACES: {
                if (this.asNamespaceCatalog == null) break;
                Namespace ns = vars.containsKey("parent") ? Namespace.of((String[])((String[])RESTUtil.NAMESPACE_SPLITTER.splitToStream((CharSequence)vars.get("parent")).toArray(String[]::new))) : Namespace.empty();
                return RESTCatalogAdapter.castResponse(responseType, CatalogHandlers.listNamespaces((SupportsNamespaces)this.asNamespaceCatalog, (Namespace)ns));
            }
            case CREATE_NAMESPACE: {
                if (this.asNamespaceCatalog == null) break;
                CreateNamespaceRequest request = RESTCatalogAdapter.castRequest(CreateNamespaceRequest.class, body);
                return RESTCatalogAdapter.castResponse(responseType, CatalogHandlers.createNamespace((SupportsNamespaces)this.asNamespaceCatalog, (CreateNamespaceRequest)request));
            }
            case LOAD_NAMESPACE: {
                if (this.asNamespaceCatalog == null) break;
                Namespace namespace = RESTCatalogAdapter.namespaceFromPathVars(vars);
                return RESTCatalogAdapter.castResponse(responseType, CatalogHandlers.loadNamespace((SupportsNamespaces)this.asNamespaceCatalog, (Namespace)namespace));
            }
            case DROP_NAMESPACE: {
                if (this.asNamespaceCatalog == null) break;
                CatalogHandlers.dropNamespace((SupportsNamespaces)this.asNamespaceCatalog, (Namespace)RESTCatalogAdapter.namespaceFromPathVars(vars));
                return null;
            }
            case UPDATE_NAMESPACE: {
                if (this.asNamespaceCatalog == null) break;
                Namespace namespace = RESTCatalogAdapter.namespaceFromPathVars(vars);
                UpdateNamespacePropertiesRequest request = RESTCatalogAdapter.castRequest(UpdateNamespacePropertiesRequest.class, body);
                return RESTCatalogAdapter.castResponse(responseType, CatalogHandlers.updateNamespaceProperties((SupportsNamespaces)this.asNamespaceCatalog, (Namespace)namespace, (UpdateNamespacePropertiesRequest)request));
            }
            case LIST_TABLES: {
                Namespace namespace = RESTCatalogAdapter.namespaceFromPathVars(vars);
                return RESTCatalogAdapter.castResponse(responseType, CatalogHandlers.listTables((Catalog)this.catalog, (Namespace)namespace));
            }
            case CREATE_TABLE: {
                Namespace namespace = RESTCatalogAdapter.namespaceFromPathVars(vars);
                CreateTableRequest request = RESTCatalogAdapter.castRequest(CreateTableRequest.class, body);
                request.validate();
                if (request.stageCreate()) {
                    return RESTCatalogAdapter.castResponse(responseType, CatalogHandlers.stageTableCreate((Catalog)this.catalog, (Namespace)namespace, (CreateTableRequest)request));
                }
                return RESTCatalogAdapter.castResponse(responseType, CatalogHandlers.createTable((Catalog)this.catalog, (Namespace)namespace, (CreateTableRequest)request));
            }
            case DROP_TABLE: {
                if (PropertyUtil.propertyAsBoolean(vars, (String)"purgeRequested", (boolean)false)) {
                    CatalogHandlers.purgeTable((Catalog)this.catalog, (TableIdentifier)RESTCatalogAdapter.identFromPathVars(vars));
                } else {
                    CatalogHandlers.dropTable((Catalog)this.catalog, (TableIdentifier)RESTCatalogAdapter.identFromPathVars(vars));
                }
                return null;
            }
            case LOAD_TABLE: {
                TableIdentifier ident = RESTCatalogAdapter.identFromPathVars(vars);
                return RESTCatalogAdapter.castResponse(responseType, CatalogHandlers.loadTable((Catalog)this.catalog, (TableIdentifier)ident));
            }
            case UPDATE_TABLE: {
                TableIdentifier ident = RESTCatalogAdapter.identFromPathVars(vars);
                UpdateTableRequest request = RESTCatalogAdapter.castRequest(UpdateTableRequest.class, body);
                return RESTCatalogAdapter.castResponse(responseType, CatalogHandlers.updateTable((Catalog)this.catalog, (TableIdentifier)ident, (UpdateTableRequest)request));
            }
            case RENAME_TABLE: {
                RenameTableRequest request = RESTCatalogAdapter.castRequest(RenameTableRequest.class, body);
                CatalogHandlers.renameTable((Catalog)this.catalog, (RenameTableRequest)request);
                return null;
            }
            case REPORT_METRICS: {
                RESTCatalogAdapter.castRequest(ReportMetricsRequest.class, body);
                return null;
            }
        }
        return null;
    }

    public <T extends RESTResponse> T execute(HTTPMethod method, String path, Map<String, String> queryParams, Object body, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        ErrorResponse.Builder errorBuilder = ErrorResponse.builder();
        Pair<Route, Map<String, String>> routeAndVars = Route.from(method, path);
        if (routeAndVars != null) {
            try {
                ImmutableMap.Builder vars = ImmutableMap.builder();
                if (queryParams != null) {
                    vars.putAll(queryParams);
                }
                vars.putAll((Map)routeAndVars.second());
                return this.handleRequest((Route)((Object)routeAndVars.first()), (Map<String, String>)vars.build(), body, responseType);
            }
            catch (RuntimeException e) {
                RESTCatalogAdapter.configureResponseFromException(e, errorBuilder);
            }
        } else {
            errorBuilder.responseCode(Integer.valueOf(400)).withType("BadRequestException").withMessage(String.format("No route for request: %s %s", new Object[]{method, path}));
        }
        ErrorResponse error = errorBuilder.build();
        errorHandler.accept(error);
        throw new RESTException("Unhandled error: %s", new Object[]{error});
    }

    public <T extends RESTResponse> T delete(String path, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return this.execute(HTTPMethod.DELETE, path, null, null, responseType, headers, errorHandler);
    }

    public <T extends RESTResponse> T delete(String path, Map<String, String> queryParams, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return this.execute(HTTPMethod.DELETE, path, queryParams, null, responseType, headers, errorHandler);
    }

    public <T extends RESTResponse> T post(String path, RESTRequest body, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return this.execute(HTTPMethod.POST, path, null, body, responseType, headers, errorHandler);
    }

    public <T extends RESTResponse> T get(String path, Map<String, String> queryParams, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return this.execute(HTTPMethod.GET, path, queryParams, null, responseType, headers, errorHandler);
    }

    public void head(String path, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        this.execute(HTTPMethod.HEAD, path, null, null, null, headers, errorHandler);
    }

    public <T extends RESTResponse> T postForm(String path, Map<String, String> formData, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return this.execute(HTTPMethod.POST, path, null, formData, responseType, headers, errorHandler);
    }

    public void close() throws IOException {
    }

    public static <T> T castRequest(Class<T> requestType, Object request) {
        if (requestType.isInstance(request)) {
            return requestType.cast(request);
        }
        throw new BadRequestType(requestType, request);
    }

    public static <T extends RESTResponse> T castResponse(Class<T> responseType, Object response) {
        if (responseType.isInstance(response)) {
            return (T)((RESTResponse)responseType.cast(response));
        }
        throw new BadResponseType(responseType, response);
    }

    public static void configureResponseFromException(Exception exc, ErrorResponse.Builder errorBuilder) {
        errorBuilder.responseCode(EXCEPTION_ERROR_CODES.getOrDefault(exc.getClass(), 500)).withType(exc.getClass().getSimpleName()).withMessage(exc.getMessage()).withStackTrace((Throwable)exc);
    }

    private static Namespace namespaceFromPathVars(Map<String, String> pathVars) {
        return RESTUtil.decodeNamespace((String)pathVars.get("namespace"));
    }

    private static TableIdentifier identFromPathVars(Map<String, String> pathVars) {
        return TableIdentifier.of((Namespace)RESTCatalogAdapter.namespaceFromPathVars(pathVars), (String)RESTUtil.decodeString((String)pathVars.get("table")));
    }

    private static class BadRequestType
    extends RuntimeException {
        private BadRequestType(Class<?> requestType, Object request) {
            super(String.format("Invalid request object, not a %s: %s", requestType.getName(), request));
        }
    }

    private static class BadResponseType
    extends RuntimeException {
        private BadResponseType(Class<?> responseType, Object response) {
            super(String.format("Invalid response object, not a %s: %s", responseType.getName(), response));
        }
    }

    static enum Route {
        TOKENS(HTTPMethod.POST, "v1/oauth/tokens", null, OAuthTokenResponse.class),
        CONFIG(HTTPMethod.GET, "v1/config", null, ConfigResponse.class),
        LIST_NAMESPACES(HTTPMethod.GET, "v1/namespaces", null, ListNamespacesResponse.class),
        CREATE_NAMESPACE(HTTPMethod.POST, "v1/namespaces", CreateNamespaceRequest.class, CreateNamespaceResponse.class),
        LOAD_NAMESPACE(HTTPMethod.GET, "v1/namespaces/{namespace}", null, GetNamespaceResponse.class),
        DROP_NAMESPACE(HTTPMethod.DELETE, "v1/namespaces/{namespace}"),
        UPDATE_NAMESPACE(HTTPMethod.POST, "v1/namespaces/{namespace}/properties", UpdateNamespacePropertiesRequest.class, UpdateNamespacePropertiesResponse.class),
        LIST_TABLES(HTTPMethod.GET, "v1/namespaces/{namespace}/tables", null, ListTablesResponse.class),
        CREATE_TABLE(HTTPMethod.POST, "v1/namespaces/{namespace}/tables", CreateTableRequest.class, LoadTableResponse.class),
        LOAD_TABLE(HTTPMethod.GET, "v1/namespaces/{namespace}/tables/{table}", null, LoadTableResponse.class),
        UPDATE_TABLE(HTTPMethod.POST, "v1/namespaces/{namespace}/tables/{table}", UpdateTableRequest.class, LoadTableResponse.class),
        DROP_TABLE(HTTPMethod.DELETE, "v1/namespaces/{namespace}/tables/{table}"),
        RENAME_TABLE(HTTPMethod.POST, "v1/tables/rename", RenameTableRequest.class, null),
        REPORT_METRICS(HTTPMethod.POST, "v1/namespaces/{namespace}/tables/{table}/metrics", ReportMetricsRequest.class, null);

        private final HTTPMethod method;
        private final int requiredLength;
        private final Map<Integer, String> requirements;
        private final Map<Integer, String> variables;
        private final Class<? extends RESTRequest> requestClass;
        private final Class<? extends RESTResponse> responseClass;

        private Route(HTTPMethod method, String pattern) {
            this(method, pattern, null, null);
        }

        private Route(HTTPMethod method, String pattern, Class<? extends RESTRequest> requestClass, Class<? extends RESTResponse> responseClass) {
            this.method = method;
            List parts = SLASH.splitToList((CharSequence)pattern);
            ImmutableMap.Builder requirementsBuilder = ImmutableMap.builder();
            ImmutableMap.Builder variablesBuilder = ImmutableMap.builder();
            for (int pos = 0; pos < parts.size(); ++pos) {
                String part = (String)parts.get(pos);
                if (part.startsWith("{") && part.endsWith("}")) {
                    variablesBuilder.put((Object)pos, (Object)part.substring(1, part.length() - 1));
                    continue;
                }
                requirementsBuilder.put((Object)pos, (Object)part);
            }
            this.requestClass = requestClass;
            this.responseClass = responseClass;
            this.requiredLength = parts.size();
            this.requirements = requirementsBuilder.build();
            this.variables = variablesBuilder.build();
        }

        private boolean matches(HTTPMethod requestMethod, List<String> requestPath) {
            return this.method == requestMethod && this.requiredLength == requestPath.size() && this.requirements.entrySet().stream().allMatch(requirement -> ((String)requirement.getValue()).equalsIgnoreCase((String)requestPath.get((Integer)requirement.getKey())));
        }

        private Map<String, String> variables(List<String> requestPath) {
            ImmutableMap.Builder vars = ImmutableMap.builder();
            this.variables.forEach((key, value) -> vars.put(value, (Object)((String)requestPath.get((int)key))));
            return vars.build();
        }

        public static Pair<Route, Map<String, String>> from(HTTPMethod method, String path) {
            List parts = SLASH.splitToList((CharSequence)path);
            for (Route candidate : Route.values()) {
                if (!candidate.matches(method, parts)) continue;
                return Pair.of((Object)((Object)candidate), candidate.variables(parts));
            }
            return null;
        }

        public Class<? extends RESTRequest> requestClass() {
            return this.requestClass;
        }

        public Class<? extends RESTResponse> responseClass() {
            return this.responseClass;
        }
    }

    static enum HTTPMethod {
        GET,
        HEAD,
        POST,
        DELETE;

    }
}

