/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.puffin;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.inmemory.InMemoryOutputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.puffin.Blob;
import org.apache.iceberg.puffin.BlobMetadata;
import org.apache.iceberg.puffin.Puffin;
import org.apache.iceberg.puffin.PuffinCompressionCodec;
import org.apache.iceberg.puffin.PuffinFormatTestUtil;
import org.apache.iceberg.puffin.PuffinWriter;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestPuffinWriter {
    @Test
    public void testEmptyFooterCompressed() {
        InMemoryOutputFile outputFile = new InMemoryOutputFile();
        PuffinWriter writer = Puffin.write((OutputFile)outputFile).compressFooter().build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((PuffinWriter)writer).footerSize()).isInstanceOf(IllegalStateException.class)).hasMessage("Footer not written yet");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((PuffinWriter)writer).finish()).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Unsupported codec: LZ4");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((PuffinWriter)writer).close()).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Unsupported codec: LZ4");
    }

    @Test
    public void testEmptyFooterUncompressed() throws Exception {
        InMemoryOutputFile outputFile = new InMemoryOutputFile();
        PuffinWriter writer = Puffin.write((OutputFile)outputFile).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((PuffinWriter)writer).footerSize()).isInstanceOf(IllegalStateException.class)).hasMessage("Footer not written yet");
        writer.finish();
        Assertions.assertThat((long)writer.footerSize()).isEqualTo(28L);
        writer.close();
        Assertions.assertThat((byte[])outputFile.toByteArray()).isEqualTo((Object)PuffinFormatTestUtil.readTestResource("v1/empty-puffin-uncompressed.bin"));
        Assertions.assertThat((long)writer.footerSize()).isEqualTo(28L);
        Assertions.assertThat((List)writer.writtenBlobsMetadata()).isEmpty();
    }

    @Test
    public void testImplicitFinish() throws Exception {
        InMemoryOutputFile outputFile = new InMemoryOutputFile();
        PuffinWriter writer = Puffin.write((OutputFile)outputFile).build();
        writer.close();
        Assertions.assertThat((byte[])outputFile.toByteArray()).isEqualTo((Object)PuffinFormatTestUtil.readTestResource("v1/empty-puffin-uncompressed.bin"));
        Assertions.assertThat((long)writer.footerSize()).isEqualTo(28L);
    }

    @Test
    public void testWriteMetricDataUncompressed() throws Exception {
        this.testWriteMetric(PuffinCompressionCodec.NONE, "v1/sample-metric-data-uncompressed.bin");
    }

    @Test
    public void testWriteMetricDataCompressedZstd() throws Exception {
        this.testWriteMetric(PuffinCompressionCodec.ZSTD, "v1/sample-metric-data-compressed-zstd.bin");
    }

    private void testWriteMetric(PuffinCompressionCodec compression, String expectedResource) throws Exception {
        InMemoryOutputFile outputFile = new InMemoryOutputFile();
        try (PuffinWriter writer = Puffin.write((OutputFile)outputFile).createdBy("Test 1234").build();){
            writer.add(new Blob("some-blob", (List)ImmutableList.of((Object)1), 2L, 1L, ByteBuffer.wrap("abcdefghi".getBytes(StandardCharsets.UTF_8)), compression, (Map)ImmutableMap.of()));
            byte[] bytes = "xxx some blob \u0000 binary data \ud83e\udd2f that is not very very very very very very long, is it? xxx".getBytes(StandardCharsets.UTF_8);
            writer.add(new Blob("some-other-blob", (List)ImmutableList.of((Object)2), 2L, 1L, ByteBuffer.wrap(bytes, 4, bytes.length - 8), compression, (Map)ImmutableMap.of()));
            Assertions.assertThat((List)writer.writtenBlobsMetadata()).hasSize(2);
            BlobMetadata firstMetadata = (BlobMetadata)writer.writtenBlobsMetadata().get(0);
            Assertions.assertThat((String)firstMetadata.type()).isEqualTo("some-blob");
            Assertions.assertThat((List)firstMetadata.inputFields()).isEqualTo((Object)ImmutableList.of((Object)1));
            Assertions.assertThat((Map)firstMetadata.properties()).isEqualTo((Object)ImmutableMap.of());
            BlobMetadata secondMetadata = (BlobMetadata)writer.writtenBlobsMetadata().get(1);
            Assertions.assertThat((String)secondMetadata.type()).isEqualTo("some-other-blob");
            Assertions.assertThat((List)secondMetadata.inputFields()).isEqualTo((Object)ImmutableList.of((Object)2));
            Assertions.assertThat((Map)secondMetadata.properties()).isEqualTo((Object)ImmutableMap.of());
        }
        byte[] expected = PuffinFormatTestUtil.readTestResource(expectedResource);
        Assertions.assertThat((byte[])outputFile.toByteArray()).isEqualTo((Object)expected);
    }
}

