/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.puffin;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.iceberg.inmemory.InMemoryInputFile;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.puffin.BlobMetadata;
import org.apache.iceberg.puffin.FileMetadata;
import org.apache.iceberg.puffin.Puffin;
import org.apache.iceberg.puffin.PuffinCompressionCodec;
import org.apache.iceberg.puffin.PuffinFormatTestUtil;
import org.apache.iceberg.puffin.PuffinReader;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.apache.iceberg.util.ByteBuffers;
import org.apache.iceberg.util.Pair;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.junit.Test;

public class TestPuffinReader {
    @Test
    public void testEmptyFooterUncompressed() throws Exception {
        this.testEmpty("v1/empty-puffin-uncompressed.bin", 28L);
    }

    @Test
    public void testEmptyWithUnknownFooterSize() throws Exception {
        this.testEmpty("v1/empty-puffin-uncompressed.bin", null);
    }

    private void testEmpty(String resourceName, @Nullable Long footerSize) throws Exception {
        InMemoryInputFile inputFile = new InMemoryInputFile(PuffinFormatTestUtil.readTestResource(resourceName));
        Puffin.ReadBuilder readBuilder = Puffin.read((InputFile)inputFile).withFileSize(inputFile.getLength());
        if (footerSize != null) {
            readBuilder = readBuilder.withFooterSize(footerSize.longValue());
        }
        try (PuffinReader reader = readBuilder.build();){
            FileMetadata fileMetadata = reader.fileMetadata();
            ((MapAssert)Assertions.assertThat((Map)fileMetadata.properties()).as("file properties", new Object[0])).isEqualTo((Object)ImmutableMap.of());
            ((ListAssert)Assertions.assertThat((List)fileMetadata.blobs()).as("blob list", new Object[0])).isEmpty();
        }
    }

    @Test
    public void testWrongFooterSize() throws Exception {
        String resourceName = "v1/sample-metric-data-compressed-zstd.bin";
        long footerSize = 314L;
        this.testWrongFooterSize(resourceName, footerSize - 1L, "Invalid file: expected magic at offset");
        this.testWrongFooterSize(resourceName, footerSize + 1L, "Invalid file: expected magic at offset");
        this.testWrongFooterSize(resourceName, footerSize - 10L, "Invalid file: expected magic at offset");
        this.testWrongFooterSize(resourceName, footerSize + 10L, "Invalid file: expected magic at offset");
        this.testWrongFooterSize(resourceName, footerSize - 10000L, "Invalid footer size");
        this.testWrongFooterSize(resourceName, footerSize + 10000L, "Invalid footer size");
    }

    private void testWrongFooterSize(String resourceName, long wrongFooterSize, String expectedMessagePrefix) throws Exception {
        InMemoryInputFile inputFile = new InMemoryInputFile(PuffinFormatTestUtil.readTestResource(resourceName));
        Puffin.ReadBuilder builder = Puffin.read((InputFile)inputFile).withFileSize(inputFile.getLength()).withFooterSize(wrongFooterSize);
        Assertions.assertThatThrownBy(() -> {
            PuffinReader reader = builder.build();
            Throwable throwable = null;
            try {
                reader.fileMetadata();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader != null) {
                    TestPuffinReader.$closeResource(throwable, (AutoCloseable)reader);
                }
            }
        }).hasMessageStartingWith(expectedMessagePrefix);
    }

    @Test
    public void testReadMetricDataUncompressed() throws Exception {
        this.testReadMetricData("v1/sample-metric-data-uncompressed.bin", PuffinCompressionCodec.NONE);
    }

    @Test
    public void testReadMetricDataCompressedZstd() throws Exception {
        this.testReadMetricData("v1/sample-metric-data-compressed-zstd.bin", PuffinCompressionCodec.ZSTD);
    }

    private void testReadMetricData(String resourceName, PuffinCompressionCodec expectedCodec) throws Exception {
        InMemoryInputFile inputFile = new InMemoryInputFile(PuffinFormatTestUtil.readTestResource(resourceName));
        try (PuffinReader reader = Puffin.read((InputFile)inputFile).build();){
            FileMetadata fileMetadata = reader.fileMetadata();
            ((MapAssert)Assertions.assertThat((Map)fileMetadata.properties()).as("file properties", new Object[0])).isEqualTo((Object)ImmutableMap.of((Object)"created-by", (Object)"Test 1234"));
            ((ListAssert)Assertions.assertThat((List)fileMetadata.blobs()).as("blob list", new Object[0])).hasSize(2);
            BlobMetadata firstBlob = (BlobMetadata)fileMetadata.blobs().get(0);
            ((AbstractStringAssert)Assertions.assertThat((String)firstBlob.type()).as("type", new Object[0])).isEqualTo("some-blob");
            ((ListAssert)Assertions.assertThat((List)firstBlob.inputFields()).as("columns", new Object[0])).isEqualTo((Object)ImmutableList.of((Object)1));
            ((AbstractLongAssert)Assertions.assertThat((long)firstBlob.offset()).as("offset", new Object[0])).isEqualTo(4L);
            ((AbstractStringAssert)Assertions.assertThat((String)firstBlob.compressionCodec()).as("compression codec", new Object[0])).isEqualTo(expectedCodec.codecName());
            BlobMetadata secondBlob = (BlobMetadata)fileMetadata.blobs().get(1);
            ((AbstractStringAssert)Assertions.assertThat((String)secondBlob.type()).as("type", new Object[0])).isEqualTo("some-other-blob");
            ((ListAssert)Assertions.assertThat((List)secondBlob.inputFields()).as("columns", new Object[0])).isEqualTo((Object)ImmutableList.of((Object)2));
            ((AbstractLongAssert)Assertions.assertThat((long)secondBlob.offset()).as("offset", new Object[0])).isEqualTo(firstBlob.offset() + firstBlob.length());
            ((AbstractStringAssert)Assertions.assertThat((String)secondBlob.compressionCodec()).as("compression codec", new Object[0])).isEqualTo(expectedCodec.codecName());
            Map read = (Map)Streams.stream((Iterable)reader.readAll((List)ImmutableList.of((Object)firstBlob, (Object)secondBlob))).collect(ImmutableMap.toImmutableMap(Pair::first, pair -> ByteBuffers.toByteArray((ByteBuffer)((ByteBuffer)pair.second()))));
            ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)read).as("read", new Object[0])).containsOnlyKeys((Object[])new BlobMetadata[]{firstBlob, secondBlob})).containsEntry((Object)firstBlob, (Object)"abcdefghi".getBytes(StandardCharsets.UTF_8))).containsEntry((Object)secondBlob, (Object)"some blob \u0000 binary data \ud83e\udd2f that is not very very very very very very long, is it?".getBytes(StandardCharsets.UTF_8));
        }
    }

    @Test
    public void testValidateFooterSizeValue() throws Exception {
        InMemoryInputFile inputFile = new InMemoryInputFile(PuffinFormatTestUtil.readTestResource("v1/sample-metric-data-compressed-zstd.bin"));
        try (PuffinReader reader = Puffin.read((InputFile)inputFile).withFooterSize(314L).build();){
            Assertions.assertThat((Map)reader.fileMetadata().properties()).isEqualTo((Object)ImmutableMap.of((Object)"created-by", (Object)"Test 1234"));
        }
    }
}

