/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.puffin;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.iceberg.puffin.PuffinFormat;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestPuffinFormat {
    @Test
    public void testWriteIntegerLittleEndian() throws Exception {
        this.testWriteIntegerLittleEndian(0, this.bytes(0, 0, 0, 0));
        this.testWriteIntegerLittleEndian(42, this.bytes(42, 0, 0, 0));
        this.testWriteIntegerLittleEndian(0x7FFFFFFA, this.bytes(250, 255, 255, 127));
        this.testWriteIntegerLittleEndian(-7, this.bytes(249, 255, 255, 255));
    }

    private void testWriteIntegerLittleEndian(int value, byte[] expected) throws Exception {
        ByteBuffer buffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(value);
        buffer.flip();
        byte[] written = new byte[4];
        buffer.get(written);
        Preconditions.checkState((boolean)Arrays.equals(written, expected), (Object)"Invalid expected value");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PuffinFormat.writeIntegerLittleEndian((OutputStream)outputStream, (int)value);
        Assertions.assertThat((byte[])outputStream.toByteArray()).isEqualTo((Object)expected);
    }

    @Test
    public void testReadIntegerLittleEndian() {
        this.testReadIntegerLittleEndian(this.bytes(0, 0, 0, 0), 0, 0);
        this.testReadIntegerLittleEndian(this.bytes(42, 0, 0, 0), 0, 42);
        this.testReadIntegerLittleEndian(this.bytes(13, 42, 0, 0, 0, 14), 1, 42);
        this.testReadIntegerLittleEndian(this.bytes(13, 250, 255, 255, 127, 14), 1, 0x7FFFFFFA);
        this.testReadIntegerLittleEndian(this.bytes(13, 249, 255, 255, 255, 14), 1, -7);
    }

    private void testReadIntegerLittleEndian(byte[] input, int offset, int expected) {
        Preconditions.checkArgument((expected == ByteBuffer.wrap((byte[])input.clone(), offset, input.length - offset).order(ByteOrder.LITTLE_ENDIAN).getInt() ? 1 : 0) != 0, (Object)"Invalid expected value");
        Assertions.assertThat((int)PuffinFormat.readIntegerLittleEndian((byte[])input, (int)offset)).isEqualTo(expected);
    }

    private byte[] bytes(int ... unsignedBytes) {
        byte[] bytes = new byte[unsignedBytes.length];
        for (int i = 0; i < unsignedBytes.length; ++i) {
            int value = unsignedBytes[i];
            Preconditions.checkArgument((0 <= value && value <= 255 ? 1 : 0) != 0, (String)"Invalid value: %s", (int)value);
            bytes[i] = (byte)value;
        }
        return bytes;
    }
}

