/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.puffin;

import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.puffin.BlobMetadata;
import org.apache.iceberg.puffin.FileMetadata;
import org.apache.iceberg.puffin.FileMetadataParser;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestFileMetadataParser {
    @Test
    public void testInvalidJson() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FileMetadataParser.fromJson((String)null)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("argument \"content\" is null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FileMetadataParser.fromJson((String)"")).isInstanceOf(UncheckedIOException.class)).hasMessageContaining("No content to map due to end-of-input");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FileMetadataParser.fromJson((String)"{")).isInstanceOf(UncheckedIOException.class)).hasMessageContaining("Unexpected end-of-input: expected close marker for Object");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FileMetadataParser.fromJson((String)"{\"blobs\": []")).isInstanceOf(UncheckedIOException.class)).hasMessageContaining("Unexpected end-of-input: expected close marker for Object");
    }

    @Test
    public void testMinimalFileMetadata() {
        this.testJsonSerialization(new FileMetadata((List)ImmutableList.of(), (Map)ImmutableMap.of()), "{\n  \"blobs\" : [ ]\n}");
    }

    @Test
    public void testFileProperties() {
        this.testJsonSerialization(new FileMetadata((List)ImmutableList.of(), (Map)ImmutableMap.of((Object)"a property", (Object)"a property value")), "{\n  \"blobs\" : [ ],\n  \"properties\" : {\n    \"a property\" : \"a property value\"\n  }\n}");
        this.testJsonSerialization(new FileMetadata((List)ImmutableList.of(), (Map)ImmutableMap.of((Object)"a property", (Object)"a property value", (Object)"another one", (Object)"also with value")), "{\n  \"blobs\" : [ ],\n  \"properties\" : {\n    \"a property\" : \"a property value\",\n    \"another one\" : \"also with value\"\n  }\n}");
    }

    @Test
    public void testMissingBlobs() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FileMetadataParser.fromJson((String)"{\"properties\": {}}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing field: blobs");
    }

    @Test
    public void testBadBlobs() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FileMetadataParser.fromJson((String)"{\"blobs\": {}}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse blobs from non-array: {}");
    }

    @Test
    public void testBlobMetadata() {
        this.testJsonSerialization(new FileMetadata((List)ImmutableList.of((Object)new BlobMetadata("type-a", (List)ImmutableList.of((Object)1), 14L, 3L, 4L, 16L, null, (Map)ImmutableMap.of()), (Object)new BlobMetadata("type-bbb", (List)ImmutableList.of((Object)2, (Object)3, (Object)4), 77L, 4L, 21474836470000L, 79834L, null, (Map)ImmutableMap.of())), (Map)ImmutableMap.of()), "{\n  \"blobs\" : [ {\n    \"type\" : \"type-a\",\n    \"fields\" : [ 1 ],\n    \"snapshot-id\" : 14,\n    \"sequence-number\" : 3,\n    \"offset\" : 4,\n    \"length\" : 16\n  }, {\n    \"type\" : \"type-bbb\",\n    \"fields\" : [ 2, 3, 4 ],\n    \"snapshot-id\" : 77,\n    \"sequence-number\" : 4,\n    \"offset\" : 21474836470000,\n    \"length\" : 79834\n  } ]\n}");
    }

    @Test
    public void testBlobProperties() {
        this.testJsonSerialization(new FileMetadata((List)ImmutableList.of((Object)new BlobMetadata("type-a", (List)ImmutableList.of((Object)1), 14L, 3L, 4L, 16L, null, (Map)ImmutableMap.of((Object)"some key", (Object)"some value"))), (Map)ImmutableMap.of()), "{\n  \"blobs\" : [ {\n    \"type\" : \"type-a\",\n    \"fields\" : [ 1 ],\n    \"snapshot-id\" : 14,\n    \"sequence-number\" : 3,\n    \"offset\" : 4,\n    \"length\" : 16,\n    \"properties\" : {\n      \"some key\" : \"some value\"\n    }\n  } ]\n}");
    }

    @Test
    public void testFieldNumberOutOfRange() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FileMetadataParser.fromJson((String)"{\n  \"blobs\" : [ {\n    \"type\" : \"type-a\",\n    \"fields\" : [ 2147483648 ],\n    \"offset\" : 4,\n    \"length\" : 16\n  } ]\n}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse integer from non-int value in fields: 2147483648");
    }

    private void testJsonSerialization(FileMetadata fileMetadata, String json) {
        Assertions.assertThat((String)FileMetadataParser.toJson((FileMetadata)fileMetadata, (boolean)true)).isEqualTo(json);
        FileMetadata parsed = FileMetadataParser.fromJson((String)json);
        Assertions.assertThat((String)FileMetadataParser.toJson((FileMetadata)parsed, (boolean)true)).isEqualTo(json);
    }
}

