/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.metrics.TimerResult;
import org.apache.iceberg.metrics.TimerResultParser;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestTimerResultParser {
    @Test
    public void nullTimer() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TimerResultParser.fromJson((JsonNode)null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse timer from null object");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TimerResultParser.toJson(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid timer: null");
    }

    @Test
    public void missingFields() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TimerResultParser.fromJson((String)"{}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing long: count");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TimerResultParser.fromJson((String)"{\"count\":44}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing string: time-unit");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TimerResultParser.fromJson((String)"{\"count\":44,\"time-unit\":\"hours\"}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing long: total-duration");
    }

    @Test
    public void extraFields() {
        Assertions.assertThat((Object)TimerResultParser.fromJson((String)"{\"count\":44,\"time-unit\":\"hours\",\"total-duration\":24,\"extra\": \"value\"}")).isEqualTo((Object)TimerResult.of((TimeUnit)TimeUnit.HOURS, (Duration)Duration.ofHours(24L), (long)44L));
    }

    @Test
    public void unsupportedDuration() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TimerResultParser.fromJson((String)"{\"count\":44,\"time-unit\":\"hours\",\"total-duration\":\"xx\"}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to a long value: total-duration: \"xx\"");
    }

    @Test
    public void unsupportedTimeUnit() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TimerResultParser.fromJson((String)"{\"count\":44,\"time-unit\":\"unknown\",\"total-duration\":24}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid time unit: unknown");
    }

    @Test
    public void invalidCount() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TimerResultParser.fromJson((String)"{\"count\":\"illegal\",\"time-unit\":\"hours\",\"total-duration\":24}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to a long value: count: \"illegal\"");
    }

    @Test
    public void roundTripSerde() {
        TimerResult timer = TimerResult.of((TimeUnit)TimeUnit.HOURS, (Duration)Duration.ofHours(23L), (long)44L);
        String json = TimerResultParser.toJson((TimerResult)timer);
        Assertions.assertThat((Object)TimerResultParser.fromJson((String)json)).isEqualTo((Object)timer);
        Assertions.assertThat((String)json).isEqualTo("{\"count\":44,\"time-unit\":\"hours\",\"total-duration\":23}");
    }

    @Test
    public void toDuration() {
        Assertions.assertThat((Duration)TimerResultParser.toDuration((long)5L, (TimeUnit)TimeUnit.NANOSECONDS)).isEqualTo((Object)Duration.ofNanos(5L));
        Assertions.assertThat((Duration)TimerResultParser.toDuration((long)5L, (TimeUnit)TimeUnit.MICROSECONDS)).isEqualTo((Object)Duration.of(5L, ChronoUnit.MICROS));
        Assertions.assertThat((Duration)TimerResultParser.toDuration((long)5L, (TimeUnit)TimeUnit.MILLISECONDS)).isEqualTo((Object)Duration.ofMillis(5L));
        Assertions.assertThat((Duration)TimerResultParser.toDuration((long)5L, (TimeUnit)TimeUnit.SECONDS)).isEqualTo((Object)Duration.ofSeconds(5L));
        Assertions.assertThat((Duration)TimerResultParser.toDuration((long)5L, (TimeUnit)TimeUnit.MINUTES)).isEqualTo((Object)Duration.ofMinutes(5L));
        Assertions.assertThat((Duration)TimerResultParser.toDuration((long)5L, (TimeUnit)TimeUnit.HOURS)).isEqualTo((Object)Duration.ofHours(5L));
        Assertions.assertThat((Duration)TimerResultParser.toDuration((long)5L, (TimeUnit)TimeUnit.DAYS)).isEqualTo((Object)Duration.ofDays(5L));
    }

    @Test
    public void fromDuration() {
        Assertions.assertThat((long)TimerResultParser.fromDuration((Duration)Duration.ofNanos(5L), (TimeUnit)TimeUnit.NANOSECONDS)).isEqualTo(5L);
        Assertions.assertThat((long)TimerResultParser.fromDuration((Duration)Duration.of(5L, ChronoUnit.MICROS), (TimeUnit)TimeUnit.MICROSECONDS)).isEqualTo(5L);
        Assertions.assertThat((long)TimerResultParser.fromDuration((Duration)Duration.ofMillis(5L), (TimeUnit)TimeUnit.MILLISECONDS)).isEqualTo(5L);
        Assertions.assertThat((long)TimerResultParser.fromDuration((Duration)Duration.ofSeconds(5L), (TimeUnit)TimeUnit.SECONDS)).isEqualTo(5L);
        Assertions.assertThat((long)TimerResultParser.fromDuration((Duration)Duration.ofMinutes(5L), (TimeUnit)TimeUnit.MINUTES)).isEqualTo(5L);
        Assertions.assertThat((long)TimerResultParser.fromDuration((Duration)Duration.ofHours(5L), (TimeUnit)TimeUnit.HOURS)).isEqualTo(5L);
        Assertions.assertThat((long)TimerResultParser.fromDuration((Duration)Duration.ofDays(5L), (TimeUnit)TimeUnit.DAYS)).isEqualTo(5L);
    }
}

