/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.metrics.DefaultMetricsContext;
import org.apache.iceberg.metrics.ImmutableScanReport;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.metrics.ScanMetrics;
import org.apache.iceberg.metrics.ScanMetricsResult;
import org.apache.iceberg.metrics.ScanReport;
import org.apache.iceberg.metrics.ScanReportParser;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestScanReportParser {
    @Test
    public void nullScanReport() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScanReportParser.fromJson((JsonNode)null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse scan report from null object");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScanReportParser.toJson(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid scan report: null");
    }

    @Test
    public void missingFields() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScanReportParser.fromJson((String)"{}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing string: table-name");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScanReportParser.fromJson((String)"{\"table-name\":\"roundTripTableName\"}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing long: snapshot-id");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScanReportParser.fromJson((String)"{\"table-name\":\"roundTripTableName\",\"snapshot-id\":23,\"filter\":true}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing int: schema-id");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScanReportParser.fromJson((String)"{\"table-name\":\"roundTripTableName\",\"snapshot-id\":23,\"filter\":true,\"schema-id\" : 4,\"projected-field-ids\" : [ 1, 2, 3 ],\"projected-field-names\" : [ \"c1\", \"c2\", \"c3\" ]}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing field: metrics");
    }

    @Test
    public void extraFields() {
        ScanMetrics scanMetrics = ScanMetrics.of((MetricsContext)new DefaultMetricsContext());
        scanMetrics.totalPlanningDuration().record(10L, TimeUnit.MINUTES);
        scanMetrics.resultDataFiles().increment(5L);
        scanMetrics.resultDeleteFiles().increment(5L);
        scanMetrics.scannedDataManifests().increment(5L);
        scanMetrics.skippedDataManifests().increment(5L);
        scanMetrics.totalFileSizeInBytes().increment(1024L);
        scanMetrics.totalDataManifests().increment(5L);
        scanMetrics.totalFileSizeInBytes().increment(45L);
        scanMetrics.totalDeleteFileSizeInBytes().increment(23L);
        scanMetrics.skippedDataFiles().increment(3L);
        scanMetrics.skippedDeleteFiles().increment(3L);
        scanMetrics.scannedDeleteManifests().increment(3L);
        scanMetrics.skippedDeleteManifests().increment(3L);
        scanMetrics.indexedDeleteFiles().increment(10L);
        scanMetrics.positionalDeleteFiles().increment(6L);
        scanMetrics.equalityDeleteFiles().increment(4L);
        String tableName = "roundTripTableName";
        ImmutableScanReport scanReport = ImmutableScanReport.builder().tableName(tableName).schemaId(4).addProjectedFieldIds(new int[]{1, 2, 3}).addProjectedFieldNames(new String[]{"c1", "c2", "c3"}).snapshotId(23L).filter((Expression)Expressions.alwaysTrue()).scanMetrics(ScanMetricsResult.fromScanMetrics((ScanMetrics)scanMetrics)).build();
        Assertions.assertThat((Object)ScanReportParser.fromJson((String)"{\"table-name\":\"roundTripTableName\",\"snapshot-id\":23,\"filter\":true,\"schema-id\": 4,\"projected-field-ids\": [ 1, 2, 3 ],\"projected-field-names\": [ \"c1\", \"c2\", \"c3\" ],\"metrics\":{\"total-planning-duration\":{\"count\":1,\"time-unit\":\"nanoseconds\",\"total-duration\":600000000000},\"result-data-files\":{\"unit\":\"count\",\"value\":5},\"result-delete-files\":{\"unit\":\"count\",\"value\":5},\"total-data-manifests\":{\"unit\":\"count\",\"value\":5},\"total-delete-manifests\":{\"unit\":\"count\",\"value\":0},\"scanned-data-manifests\":{\"unit\":\"count\",\"value\":5},\"skipped-data-manifests\":{\"unit\":\"count\",\"value\":5},\"total-file-size-in-bytes\":{\"unit\":\"bytes\",\"value\":1069},\"total-delete-file-size-in-bytes\":{\"unit\":\"bytes\",\"value\":23},\"skipped-data-files\":{\"unit\":\"count\",\"value\":3},\"skipped-delete-files\":{\"unit\":\"count\",\"value\":3},\"scanned-delete-manifests\":{\"unit\":\"count\",\"value\":3},\"skipped-delete-manifests\":{\"unit\":\"count\",\"value\":3},\"indexed-delete-files\":{\"unit\":\"count\",\"value\":10},\"equality-delete-files\":{\"unit\":\"count\",\"value\":4},\"positional-delete-files\":{\"unit\":\"count\",\"value\":6},\"extra-metric\":\"extra-val\"},\"extra\":\"extraVal\"}")).isEqualTo((Object)scanReport);
    }

    @Test
    public void invalidTableName() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScanReportParser.fromJson((String)"{\"table-name\":23}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to a string value: table-name: 23");
    }

    @Test
    public void invalidSnapshotId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScanReportParser.fromJson((String)"{\"table-name\":\"roundTripTableName\",\"snapshot-id\":\"invalid\"}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to a long value: snapshot-id: \"invalid\"");
    }

    @Test
    public void invalidExpressionFilter() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScanReportParser.fromJson((String)"{\"table-name\":\"roundTripTableName\",\"snapshot-id\":23,\"filter\":23,\"projection\":23}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse expression from non-object: 23");
    }

    @Test
    public void invalidSchema() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScanReportParser.fromJson((String)"{\"table-name\":\"roundTripTableName\",\"snapshot-id\":23,\"filter\":true,\"schema-id\":\"23\"}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to an integer value: schema-id: \"23\"");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScanReportParser.fromJson((String)"{\"table-name\":\"roundTripTableName\",\"snapshot-id\":23,\"filter\":true,\"schema-id\":23,\"projected-field-ids\": [\"1\"],\"metrics\":{}}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse integer from non-int value in projected-field-ids: \"1\"");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScanReportParser.fromJson((String)"{\"table-name\":\"roundTripTableName\",\"snapshot-id\":23,\"filter\":true,\"schema-id\":23,\"projected-field-ids\": [1],\"projected-field-names\": [1],\"metrics\":{}}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse string from non-text value in projected-field-names: 1");
    }

    @Test
    public void roundTripSerde() {
        ScanMetrics scanMetrics = ScanMetrics.of((MetricsContext)new DefaultMetricsContext());
        scanMetrics.totalPlanningDuration().record(10L, TimeUnit.MINUTES);
        scanMetrics.resultDataFiles().increment(5L);
        scanMetrics.resultDeleteFiles().increment(5L);
        scanMetrics.scannedDataManifests().increment(5L);
        scanMetrics.skippedDataManifests().increment(5L);
        scanMetrics.totalFileSizeInBytes().increment(1024L);
        scanMetrics.totalDataManifests().increment(5L);
        scanMetrics.totalFileSizeInBytes().increment(45L);
        scanMetrics.totalDeleteFileSizeInBytes().increment(23L);
        scanMetrics.skippedDataFiles().increment(3L);
        scanMetrics.skippedDeleteFiles().increment(3L);
        scanMetrics.scannedDeleteManifests().increment(3L);
        scanMetrics.skippedDeleteManifests().increment(3L);
        scanMetrics.indexedDeleteFiles().increment(10L);
        scanMetrics.positionalDeleteFiles().increment(6L);
        scanMetrics.equalityDeleteFiles().increment(4L);
        String tableName = "roundTripTableName";
        ImmutableScanReport scanReport = ImmutableScanReport.builder().tableName(tableName).schemaId(4).addProjectedFieldIds(new int[]{1, 2, 3}).addProjectedFieldNames(new String[]{"c1", "c2", "c3"}).filter((Expression)Expressions.alwaysTrue()).snapshotId(23L).scanMetrics(ScanMetricsResult.fromScanMetrics((ScanMetrics)scanMetrics)).build();
        String expectedJson = "{\n  \"table-name\" : \"roundTripTableName\",\n  \"snapshot-id\" : 23,\n  \"filter\" : true,\n  \"schema-id\" : 4,\n  \"projected-field-ids\" : [ 1, 2, 3 ],\n  \"projected-field-names\" : [ \"c1\", \"c2\", \"c3\" ],\n  \"metrics\" : {\n    \"total-planning-duration\" : {\n      \"count\" : 1,\n      \"time-unit\" : \"nanoseconds\",\n      \"total-duration\" : 600000000000\n    },\n    \"result-data-files\" : {\n      \"unit\" : \"count\",\n      \"value\" : 5\n    },\n    \"result-delete-files\" : {\n      \"unit\" : \"count\",\n      \"value\" : 5\n    },\n    \"total-data-manifests\" : {\n      \"unit\" : \"count\",\n      \"value\" : 5\n    },\n    \"total-delete-manifests\" : {\n      \"unit\" : \"count\",\n      \"value\" : 0\n    },\n    \"scanned-data-manifests\" : {\n      \"unit\" : \"count\",\n      \"value\" : 5\n    },\n    \"skipped-data-manifests\" : {\n      \"unit\" : \"count\",\n      \"value\" : 5\n    },\n    \"total-file-size-in-bytes\" : {\n      \"unit\" : \"bytes\",\n      \"value\" : 1069\n    },\n    \"total-delete-file-size-in-bytes\" : {\n      \"unit\" : \"bytes\",\n      \"value\" : 23\n    },\n    \"skipped-data-files\" : {\n      \"unit\" : \"count\",\n      \"value\" : 3\n    },\n    \"skipped-delete-files\" : {\n      \"unit\" : \"count\",\n      \"value\" : 3\n    },\n    \"scanned-delete-manifests\" : {\n      \"unit\" : \"count\",\n      \"value\" : 3\n    },\n    \"skipped-delete-manifests\" : {\n      \"unit\" : \"count\",\n      \"value\" : 3\n    },\n    \"indexed-delete-files\" : {\n      \"unit\" : \"count\",\n      \"value\" : 10\n    },\n    \"equality-delete-files\" : {\n      \"unit\" : \"count\",\n      \"value\" : 4\n    },\n    \"positional-delete-files\" : {\n      \"unit\" : \"count\",\n      \"value\" : 6\n    }\n  }\n}";
        String json = ScanReportParser.toJson((ScanReport)scanReport, (boolean)true);
        Assertions.assertThat((Object)ScanReportParser.fromJson((String)json)).isEqualTo((Object)scanReport);
        Assertions.assertThat((String)json).isEqualTo(expectedJson);
    }

    @Test
    public void roundTripSerdeWithNoopMetrics() {
        String tableName = "roundTripTableName";
        ImmutableScanReport scanReport = ImmutableScanReport.builder().tableName(tableName).schemaId(4).addProjectedFieldIds(new int[]{1, 2, 3}).addProjectedFieldNames(new String[]{"c1", "c2", "c3"}).snapshotId(23L).filter((Expression)Expressions.alwaysTrue()).scanMetrics(ScanMetricsResult.fromScanMetrics((ScanMetrics)ScanMetrics.noop())).build();
        String expectedJson = "{\n  \"table-name\" : \"roundTripTableName\",\n  \"snapshot-id\" : 23,\n  \"filter\" : true,\n  \"schema-id\" : 4,\n  \"projected-field-ids\" : [ 1, 2, 3 ],\n  \"projected-field-names\" : [ \"c1\", \"c2\", \"c3\" ],\n  \"metrics\" : { }\n}";
        String json = ScanReportParser.toJson((ScanReport)scanReport, (boolean)true);
        Assertions.assertThat((Object)ScanReportParser.fromJson((String)json)).isEqualTo((Object)scanReport);
        Assertions.assertThat((String)json).isEqualTo(expectedJson);
    }

    @Test
    public void roundTripSerdeWithEmptyFieldIdsAndNames() {
        String tableName = "roundTripTableName";
        ImmutableScanReport scanReport = ImmutableScanReport.builder().tableName(tableName).schemaId(4).snapshotId(23L).filter((Expression)Expressions.alwaysTrue()).scanMetrics(ScanMetricsResult.fromScanMetrics((ScanMetrics)ScanMetrics.noop())).build();
        String expectedJson = "{\n  \"table-name\" : \"roundTripTableName\",\n  \"snapshot-id\" : 23,\n  \"filter\" : true,\n  \"schema-id\" : 4,\n  \"projected-field-ids\" : [ ],\n  \"projected-field-names\" : [ ],\n  \"metrics\" : { }\n}";
        String json = ScanReportParser.toJson((ScanReport)scanReport, (boolean)true);
        Assertions.assertThat((Object)ScanReportParser.fromJson((String)json)).isEqualTo((Object)scanReport);
        Assertions.assertThat((String)json).isEqualTo(expectedJson);
    }

    @Test
    public void roundTripSerdeWithMetadata() {
        String tableName = "roundTripTableName";
        ImmutableScanReport scanReport = ImmutableScanReport.builder().tableName(tableName).schemaId(4).snapshotId(23L).filter((Expression)Expressions.alwaysTrue()).scanMetrics(ScanMetricsResult.fromScanMetrics((ScanMetrics)ScanMetrics.noop())).metadata((Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2")).build();
        String expectedJson = "{\n  \"table-name\" : \"roundTripTableName\",\n  \"snapshot-id\" : 23,\n  \"filter\" : true,\n  \"schema-id\" : 4,\n  \"projected-field-ids\" : [ ],\n  \"projected-field-names\" : [ ],\n  \"metrics\" : { },\n  \"metadata\" : {\n    \"k1\" : \"v1\",\n    \"k2\" : \"v2\"\n  }\n}";
        String json = ScanReportParser.toJson((ScanReport)scanReport, (boolean)true);
        Assertions.assertThat((Object)ScanReportParser.fromJson((String)json)).isEqualTo((Object)scanReport);
        Assertions.assertThat((String)json).isEqualTo(expectedJson);
    }
}

