/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.metrics.DefaultMetricsContext;
import org.apache.iceberg.metrics.ImmutableScanReport;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.metrics.ScanMetrics;
import org.apache.iceberg.metrics.ScanMetricsResult;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestScanReport {
    @Test
    public void missingFields() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ImmutableScanReport.builder().build()).isInstanceOf(IllegalStateException.class)).hasMessage("Cannot build ScanReport, some of required attributes are not set [tableName, snapshotId, filter, schemaId, scanMetrics]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ImmutableScanReport.builder().tableName("x").build()).isInstanceOf(IllegalStateException.class)).hasMessage("Cannot build ScanReport, some of required attributes are not set [snapshotId, filter, schemaId, scanMetrics]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ImmutableScanReport.builder().tableName("x").filter((Expression)Expressions.alwaysTrue()).build()).isInstanceOf(IllegalStateException.class)).hasMessage("Cannot build ScanReport, some of required attributes are not set [snapshotId, schemaId, scanMetrics]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ImmutableScanReport.builder().tableName("x").filter((Expression)Expressions.alwaysTrue()).snapshotId(23L).build()).isInstanceOf(IllegalStateException.class)).hasMessage("Cannot build ScanReport, some of required attributes are not set [schemaId, scanMetrics]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ImmutableScanReport.builder().tableName("x").filter((Expression)Expressions.alwaysTrue()).snapshotId(23L).schemaId(4).addProjectedFieldIds(new int[]{1, 2}).addProjectedFieldNames(new String[]{"c1", "c2"}).build()).isInstanceOf(IllegalStateException.class)).hasMessage("Cannot build ScanReport, some of required attributes are not set [scanMetrics]");
    }

    @Test
    public void fromEmptyScanMetrics() {
        String tableName = "x";
        int schemaId = 4;
        List<Integer> fieldIds = Arrays.asList(1, 2);
        List<String> fieldNames = Arrays.asList("c1", "c2");
        ImmutableScanReport scanReport = ImmutableScanReport.builder().tableName(tableName).snapshotId(23L).filter((Expression)Expressions.alwaysTrue()).schemaId(schemaId).projectedFieldIds(fieldIds).projectedFieldNames(fieldNames).scanMetrics(ScanMetricsResult.fromScanMetrics((ScanMetrics)ScanMetrics.noop())).build();
        Assertions.assertThat((String)scanReport.tableName()).isEqualTo(tableName);
        Assertions.assertThat((int)scanReport.schemaId()).isEqualTo(schemaId);
        Assertions.assertThat((List)scanReport.projectedFieldIds()).isEqualTo(fieldIds);
        Assertions.assertThat((List)scanReport.projectedFieldNames()).isEqualTo(fieldNames);
        Assertions.assertThat((Object)scanReport.filter()).isEqualTo((Object)Expressions.alwaysTrue());
        Assertions.assertThat((long)scanReport.snapshotId()).isEqualTo(23L);
        Assertions.assertThat((Object)scanReport.scanMetrics().totalPlanningDuration()).isNull();
        Assertions.assertThat((Object)scanReport.scanMetrics().resultDataFiles()).isNull();
        Assertions.assertThat((Object)scanReport.scanMetrics().resultDeleteFiles()).isNull();
        Assertions.assertThat((Object)scanReport.scanMetrics().totalDataManifests()).isNull();
        Assertions.assertThat((Object)scanReport.scanMetrics().totalDeleteManifests()).isNull();
        Assertions.assertThat((Object)scanReport.scanMetrics().scannedDataManifests()).isNull();
        Assertions.assertThat((Object)scanReport.scanMetrics().skippedDataManifests()).isNull();
        Assertions.assertThat((Object)scanReport.scanMetrics().totalFileSizeInBytes()).isNull();
        Assertions.assertThat((Object)scanReport.scanMetrics().totalDeleteFileSizeInBytes()).isNull();
    }

    @Test
    public void fromScanMetrics() {
        ScanMetrics scanMetrics = ScanMetrics.of((MetricsContext)new DefaultMetricsContext());
        scanMetrics.totalPlanningDuration().record(10L, TimeUnit.MINUTES);
        scanMetrics.resultDataFiles().increment(5L);
        scanMetrics.resultDeleteFiles().increment(5L);
        scanMetrics.scannedDataManifests().increment(5L);
        scanMetrics.totalFileSizeInBytes().increment(1024L);
        scanMetrics.totalDataManifests().increment(5L);
        String tableName = "x";
        int schemaId = 4;
        List<Integer> fieldIds = Arrays.asList(1, 2);
        List<String> fieldNames = Arrays.asList("c1", "c2");
        ImmutableScanReport scanReport = ImmutableScanReport.builder().tableName(tableName).snapshotId(23L).filter((Expression)Expressions.alwaysTrue()).schemaId(schemaId).projectedFieldIds(fieldIds).projectedFieldNames(fieldNames).scanMetrics(ScanMetricsResult.fromScanMetrics((ScanMetrics)scanMetrics)).build();
        Assertions.assertThat((String)scanReport.tableName()).isEqualTo(tableName);
        Assertions.assertThat((int)scanReport.schemaId()).isEqualTo(schemaId);
        Assertions.assertThat((List)scanReport.projectedFieldIds()).isEqualTo(fieldIds);
        Assertions.assertThat((List)scanReport.projectedFieldNames()).isEqualTo(fieldNames);
        Assertions.assertThat((Object)scanReport.filter()).isEqualTo((Object)Expressions.alwaysTrue());
        Assertions.assertThat((long)scanReport.snapshotId()).isEqualTo(23L);
        Assertions.assertThat((Duration)scanReport.scanMetrics().totalPlanningDuration().totalDuration()).isEqualTo((Object)Duration.ofMinutes(10L));
        Assertions.assertThat((long)scanReport.scanMetrics().resultDataFiles().value()).isEqualTo(5L);
        Assertions.assertThat((long)scanReport.scanMetrics().resultDeleteFiles().value()).isEqualTo(5L);
        Assertions.assertThat((long)scanReport.scanMetrics().scannedDataManifests().value()).isEqualTo(5L);
        Assertions.assertThat((long)scanReport.scanMetrics().totalDataManifests().value()).isEqualTo(5L);
        Assertions.assertThat((long)scanReport.scanMetrics().totalFileSizeInBytes().value()).isEqualTo(1024L);
    }

    @Test
    public void nullScanMetrics() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScanMetrics.of(null)).isInstanceOf(NullPointerException.class)).hasMessage("metricsContext");
    }
}

