/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.metrics.CounterResult;
import org.apache.iceberg.metrics.DefaultMetricsContext;
import org.apache.iceberg.metrics.ImmutableScanMetricsResult;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.metrics.ScanMetrics;
import org.apache.iceberg.metrics.ScanMetricsResult;
import org.apache.iceberg.metrics.ScanMetricsResultParser;
import org.apache.iceberg.metrics.TimerResult;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestScanMetricsResultParser {
    @Test
    public void nullMetrics() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScanMetricsResultParser.fromJson((JsonNode)null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse scan metrics from null object");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScanMetricsResultParser.toJson(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid scan metrics: null");
    }

    @Test
    public void missingFields() {
        Assertions.assertThat((Object)ScanMetricsResultParser.fromJson((String)"{}")).isEqualTo((Object)ImmutableScanMetricsResult.builder().build());
        ImmutableScanMetricsResult scanMetricsResult = ImmutableScanMetricsResult.builder().totalPlanningDuration(TimerResult.of((TimeUnit)TimeUnit.HOURS, (Duration)Duration.ofHours(10L), (long)3L)).build();
        Assertions.assertThat((Object)ScanMetricsResultParser.fromJson((String)"{\"total-planning-duration\":{\"count\":3,\"time-unit\":\"hours\",\"total-duration\":10}}")).isEqualTo((Object)scanMetricsResult);
        scanMetricsResult = scanMetricsResult.withResultDataFiles(CounterResult.of((MetricsContext.Unit)MetricsContext.Unit.COUNT, (long)5L));
        Assertions.assertThat((Object)ScanMetricsResultParser.fromJson((String)"{\"total-planning-duration\":{\"count\":3,\"time-unit\":\"hours\",\"total-duration\":10},\"result-data-files\":{\"unit\":\"count\",\"value\":5}}")).isEqualTo((Object)scanMetricsResult);
        scanMetricsResult = scanMetricsResult.withResultDeleteFiles(CounterResult.of((MetricsContext.Unit)MetricsContext.Unit.COUNT, (long)5L));
        Assertions.assertThat((Object)ScanMetricsResultParser.fromJson((String)"{\"total-planning-duration\":{\"count\":3,\"time-unit\":\"hours\",\"total-duration\":10},\"result-data-files\":{\"unit\":\"count\",\"value\":5},\"result-delete-files\":{\"unit\":\"count\",\"value\":5}}")).isEqualTo((Object)scanMetricsResult);
        scanMetricsResult = scanMetricsResult.withTotalDataManifests(CounterResult.of((MetricsContext.Unit)MetricsContext.Unit.COUNT, (long)5L));
        Assertions.assertThat((Object)ScanMetricsResultParser.fromJson((String)"{\"total-planning-duration\":{\"count\":3,\"time-unit\":\"hours\",\"total-duration\":10},\"result-data-files\":{\"unit\":\"count\",\"value\":5},\"result-delete-files\":{\"unit\":\"count\",\"value\":5},\"total-data-manifests\":{\"unit\":\"count\",\"value\":5}}")).isEqualTo((Object)scanMetricsResult);
        scanMetricsResult = scanMetricsResult.withTotalDeleteManifests(CounterResult.of((MetricsContext.Unit)MetricsContext.Unit.COUNT, (long)0L));
        Assertions.assertThat((Object)ScanMetricsResultParser.fromJson((String)"{\"total-planning-duration\":{\"count\":3,\"time-unit\":\"hours\",\"total-duration\":10},\"result-data-files\":{\"unit\":\"count\",\"value\":5},\"result-delete-files\":{\"unit\":\"count\",\"value\":5},\"total-data-manifests\":{\"unit\":\"count\",\"value\":5},\"total-delete-manifests\":{\"unit\":\"count\",\"value\":0}}")).isEqualTo((Object)scanMetricsResult);
        scanMetricsResult = scanMetricsResult.withScannedDataManifests(CounterResult.of((MetricsContext.Unit)MetricsContext.Unit.COUNT, (long)5L));
        Assertions.assertThat((Object)ScanMetricsResultParser.fromJson((String)"{\"total-planning-duration\":{\"count\":3,\"time-unit\":\"hours\",\"total-duration\":10},\"result-data-files\":{\"unit\":\"count\",\"value\":5},\"result-delete-files\":{\"unit\":\"count\",\"value\":5},\"total-data-manifests\":{\"unit\":\"count\",\"value\":5},\"total-delete-manifests\":{\"unit\":\"count\",\"value\":0},\"scanned-data-manifests\":{\"unit\":\"count\",\"value\":5}}")).isEqualTo((Object)scanMetricsResult);
        scanMetricsResult = scanMetricsResult.withSkippedDataManifests(CounterResult.of((MetricsContext.Unit)MetricsContext.Unit.COUNT, (long)5L));
        Assertions.assertThat((Object)ScanMetricsResultParser.fromJson((String)"{\"total-planning-duration\":{\"count\":3,\"time-unit\":\"hours\",\"total-duration\":10},\"result-data-files\":{\"unit\":\"count\",\"value\":5},\"result-delete-files\":{\"unit\":\"count\",\"value\":5},\"total-data-manifests\":{\"unit\":\"count\",\"value\":5},\"total-delete-manifests\":{\"unit\":\"count\",\"value\":0},\"scanned-data-manifests\":{\"unit\":\"count\",\"value\":5},\"skipped-data-manifests\":{\"unit\":\"count\",\"value\":5}}")).isEqualTo((Object)scanMetricsResult);
        scanMetricsResult = scanMetricsResult.withTotalFileSizeInBytes(CounterResult.of((MetricsContext.Unit)MetricsContext.Unit.BYTES, (long)1069L));
        Assertions.assertThat((Object)ScanMetricsResultParser.fromJson((String)"{\"total-planning-duration\":{\"count\":3,\"time-unit\":\"hours\",\"total-duration\":10},\"result-data-files\":{\"unit\":\"count\",\"value\":5},\"result-delete-files\":{\"unit\":\"count\",\"value\":5},\"total-data-manifests\":{\"unit\":\"count\",\"value\":5},\"total-delete-manifests\":{\"unit\":\"count\",\"value\":0},\"scanned-data-manifests\":{\"unit\":\"count\",\"value\":5},\"skipped-data-manifests\":{\"unit\":\"count\",\"value\":5},\"total-file-size-in-bytes\":{\"unit\":\"bytes\",\"value\":1069}}")).isEqualTo((Object)scanMetricsResult);
        scanMetricsResult = scanMetricsResult.withTotalDeleteFileSizeInBytes(CounterResult.of((MetricsContext.Unit)MetricsContext.Unit.BYTES, (long)1023L));
        Assertions.assertThat((Object)ScanMetricsResultParser.fromJson((String)"{\"total-planning-duration\":{\"count\":3,\"time-unit\":\"hours\",\"total-duration\":10},\"result-data-files\":{\"unit\":\"count\",\"value\":5},\"result-delete-files\":{\"unit\":\"count\",\"value\":5},\"total-data-manifests\":{\"unit\":\"count\",\"value\":5},\"total-delete-manifests\":{\"unit\":\"count\",\"value\":0},\"scanned-data-manifests\":{\"unit\":\"count\",\"value\":5},\"skipped-data-manifests\":{\"unit\":\"count\",\"value\":5},\"total-file-size-in-bytes\":{\"unit\":\"bytes\",\"value\":1069},\"total-delete-file-size-in-bytes\":{\"unit\":\"bytes\",\"value\":1023}}")).isEqualTo((Object)scanMetricsResult);
        scanMetricsResult = scanMetricsResult.withSkippedDataFiles(CounterResult.of((MetricsContext.Unit)MetricsContext.Unit.COUNT, (long)23L));
        Assertions.assertThat((Object)ScanMetricsResultParser.fromJson((String)"{\"total-planning-duration\":{\"count\":3,\"time-unit\":\"hours\",\"total-duration\":10},\"result-data-files\":{\"unit\":\"count\",\"value\":5},\"result-delete-files\":{\"unit\":\"count\",\"value\":5},\"total-data-manifests\":{\"unit\":\"count\",\"value\":5},\"total-delete-manifests\":{\"unit\":\"count\",\"value\":0},\"scanned-data-manifests\":{\"unit\":\"count\",\"value\":5},\"skipped-data-manifests\":{\"unit\":\"count\",\"value\":5},\"total-file-size-in-bytes\":{\"unit\":\"bytes\",\"value\":1069},\"total-delete-file-size-in-bytes\":{\"unit\":\"bytes\",\"value\":1023},\"skipped-data-files\":{\"unit\":\"count\",\"value\":23}}")).isEqualTo((Object)scanMetricsResult);
    }

    @Test
    public void extraFields() {
        ScanMetrics scanMetrics = ScanMetrics.of((MetricsContext)new DefaultMetricsContext());
        scanMetrics.totalPlanningDuration().record(10L, TimeUnit.MINUTES);
        scanMetrics.resultDataFiles().increment(5L);
        scanMetrics.resultDeleteFiles().increment(5L);
        scanMetrics.scannedDataManifests().increment(5L);
        scanMetrics.skippedDataManifests().increment(5L);
        scanMetrics.totalFileSizeInBytes().increment(1024L);
        scanMetrics.totalDataManifests().increment(5L);
        scanMetrics.totalFileSizeInBytes().increment(45L);
        scanMetrics.totalDeleteFileSizeInBytes().increment(23L);
        scanMetrics.skippedDataFiles().increment(3L);
        scanMetrics.skippedDeleteFiles().increment(3L);
        scanMetrics.scannedDeleteManifests().increment(3L);
        scanMetrics.skippedDeleteManifests().increment(3L);
        scanMetrics.indexedDeleteFiles().increment(10L);
        scanMetrics.positionalDeleteFiles().increment(6L);
        scanMetrics.equalityDeleteFiles().increment(4L);
        ScanMetricsResult scanMetricsResult = ScanMetricsResult.fromScanMetrics((ScanMetrics)scanMetrics);
        Assertions.assertThat((Object)ScanMetricsResultParser.fromJson((String)"{\"total-planning-duration\":{\"count\":1,\"time-unit\":\"nanoseconds\",\"total-duration\":600000000000},\"result-data-files\":{\"unit\":\"count\",\"value\":5},\"result-delete-files\":{\"unit\":\"count\",\"value\":5},\"total-data-manifests\":{\"unit\":\"count\",\"value\":5},\"total-delete-manifests\":{\"unit\":\"count\",\"value\":0},\"scanned-data-manifests\":{\"unit\":\"count\",\"value\":5},\"skipped-data-manifests\":{\"unit\":\"count\",\"value\":5},\"total-file-size-in-bytes\":{\"unit\":\"bytes\",\"value\":1069},\"total-delete-file-size-in-bytes\":{\"unit\":\"bytes\",\"value\":23},\"skipped-data-files\":{\"unit\":\"count\",\"value\":3},\"skipped-delete-files\":{\"unit\":\"count\",\"value\":3},\"scanned-delete-manifests\":{\"unit\":\"count\",\"value\":3},\"skipped-delete-manifests\":{\"unit\":\"count\",\"value\":3},\"indexed-delete-files\":{\"unit\":\"count\",\"value\":10},\"equality-delete-files\":{\"unit\":\"count\",\"value\":4},\"positional-delete-files\":{\"unit\":\"count\",\"value\":6},\"extra\": \"value\",\"extra2\":23}")).isEqualTo((Object)scanMetricsResult);
    }

    @Test
    public void invalidTimer() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScanMetricsResultParser.fromJson((String)"{\"total-planning-duration\":{\"unit\":\"count\",\"value\":5}}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse timer from 'total-planning-duration': Missing field 'count'");
    }

    @Test
    public void invalidCounter() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScanMetricsResultParser.fromJson((String)"{\"total-planning-duration\":{\"count\":1,\"time-unit\":\"nanoseconds\",\"total-duration\":600000000000},\"result-data-files\":{\"count\":1,\"time-unit\":\"nanoseconds\",\"total-duration\":600000000000}}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse counter from 'result-data-files': Missing field 'unit'");
    }

    @Test
    public void roundTripSerde() {
        ScanMetrics scanMetrics = ScanMetrics.of((MetricsContext)new DefaultMetricsContext());
        scanMetrics.totalPlanningDuration().record(10L, TimeUnit.DAYS);
        scanMetrics.resultDataFiles().increment(5L);
        scanMetrics.resultDeleteFiles().increment(5L);
        scanMetrics.scannedDataManifests().increment(5L);
        scanMetrics.skippedDataManifests().increment(5L);
        scanMetrics.totalFileSizeInBytes().increment(1024L);
        scanMetrics.totalDataManifests().increment(5L);
        scanMetrics.totalFileSizeInBytes().increment(45L);
        scanMetrics.totalDeleteFileSizeInBytes().increment(23L);
        scanMetrics.skippedDataFiles().increment(3L);
        scanMetrics.skippedDeleteFiles().increment(3L);
        scanMetrics.scannedDeleteManifests().increment(3L);
        scanMetrics.skippedDeleteManifests().increment(3L);
        scanMetrics.indexedDeleteFiles().increment(10L);
        scanMetrics.positionalDeleteFiles().increment(6L);
        scanMetrics.equalityDeleteFiles().increment(4L);
        ScanMetricsResult scanMetricsResult = ScanMetricsResult.fromScanMetrics((ScanMetrics)scanMetrics);
        String expectedJson = "{\n  \"total-planning-duration\" : {\n    \"count\" : 1,\n    \"time-unit\" : \"nanoseconds\",\n    \"total-duration\" : 864000000000000\n  },\n  \"result-data-files\" : {\n    \"unit\" : \"count\",\n    \"value\" : 5\n  },\n  \"result-delete-files\" : {\n    \"unit\" : \"count\",\n    \"value\" : 5\n  },\n  \"total-data-manifests\" : {\n    \"unit\" : \"count\",\n    \"value\" : 5\n  },\n  \"total-delete-manifests\" : {\n    \"unit\" : \"count\",\n    \"value\" : 0\n  },\n  \"scanned-data-manifests\" : {\n    \"unit\" : \"count\",\n    \"value\" : 5\n  },\n  \"skipped-data-manifests\" : {\n    \"unit\" : \"count\",\n    \"value\" : 5\n  },\n  \"total-file-size-in-bytes\" : {\n    \"unit\" : \"bytes\",\n    \"value\" : 1069\n  },\n  \"total-delete-file-size-in-bytes\" : {\n    \"unit\" : \"bytes\",\n    \"value\" : 23\n  },\n  \"skipped-data-files\" : {\n    \"unit\" : \"count\",\n    \"value\" : 3\n  },\n  \"skipped-delete-files\" : {\n    \"unit\" : \"count\",\n    \"value\" : 3\n  },\n  \"scanned-delete-manifests\" : {\n    \"unit\" : \"count\",\n    \"value\" : 3\n  },\n  \"skipped-delete-manifests\" : {\n    \"unit\" : \"count\",\n    \"value\" : 3\n  },\n  \"indexed-delete-files\" : {\n    \"unit\" : \"count\",\n    \"value\" : 10\n  },\n  \"equality-delete-files\" : {\n    \"unit\" : \"count\",\n    \"value\" : 4\n  },\n  \"positional-delete-files\" : {\n    \"unit\" : \"count\",\n    \"value\" : 6\n  }\n}";
        String json = ScanMetricsResultParser.toJson((ScanMetricsResult)scanMetricsResult, (boolean)true);
        Assertions.assertThat((Object)ScanMetricsResultParser.fromJson((String)json)).isEqualTo((Object)scanMetricsResult);
        Assertions.assertThat((String)json).isEqualTo(expectedJson);
    }

    @Test
    public void roundTripSerdeNoopScanMetrics() {
        ScanMetricsResult scanMetricsResult = ScanMetricsResult.fromScanMetrics((ScanMetrics)ScanMetrics.noop());
        String expectedJson = "{ }";
        String json = ScanMetricsResultParser.toJson((ScanMetricsResult)scanMetricsResult, (boolean)true);
        System.out.println(json);
        Assertions.assertThat((String)json).isEqualTo(expectedJson);
        Assertions.assertThat((Object)ScanMetricsResultParser.fromJson((String)json)).isEqualTo((Object)ImmutableScanMetricsResult.builder().build());
    }
}

