/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.metrics.LoggingMetricsReporter;
import org.apache.iceberg.metrics.MetricsReport;
import org.apache.iceberg.metrics.MetricsReporter;
import org.apache.iceberg.metrics.MetricsReporters;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMetricsReporters {
    @Test
    public void combineWithNullReporter() {
        MetricsReporter reporter = report -> {};
        Assertions.assertThat((Object)MetricsReporters.combine(null, null)).isNull();
        Assertions.assertThat((Object)MetricsReporters.combine(null, (MetricsReporter)reporter)).isSameAs((Object)reporter);
        Assertions.assertThat((Object)MetricsReporters.combine((MetricsReporter)reporter, null)).isSameAs((Object)reporter);
    }

    @Test
    public void combineSameInstances() {
        LoggingMetricsReporter reporter = LoggingMetricsReporter.instance();
        Assertions.assertThat((Object)MetricsReporters.combine((MetricsReporter)reporter, (MetricsReporter)reporter)).isSameAs((Object)reporter);
    }

    @Test
    public void combineSameClassButDifferentInstances() {
        LoggingMetricsReporter first = LoggingMetricsReporter.instance();
        LoggingMetricsReporter second = new LoggingMetricsReporter();
        MetricsReporter combined = MetricsReporters.combine((MetricsReporter)first, (MetricsReporter)second);
        Assertions.assertThat((Object)combined).isInstanceOf(MetricsReporters.CompositeMetricsReporter.class);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)((MetricsReporters.CompositeMetricsReporter)combined).reporters()).hasSize(2)).containsExactlyInAnyOrder((Object[])new MetricsReporter[]{first, second});
    }

    @Test
    public void combineSimpleReporters() {
        MetricsReporter first = report -> {};
        MetricsReporter second = report -> {};
        MetricsReporter combined = MetricsReporters.combine((MetricsReporter)first, (MetricsReporter)second);
        Assertions.assertThat((Object)combined).isInstanceOf(MetricsReporters.CompositeMetricsReporter.class);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)((MetricsReporters.CompositeMetricsReporter)combined).reporters()).hasSize(2)).containsExactlyInAnyOrder((Object[])new MetricsReporter[]{first, second});
    }

    @Test
    public void combineComposites() {
        MetricsReporter one = report -> {};
        MetricsReporter two = report -> {};
        MetricsReporter firstComposite = MetricsReporters.combine((MetricsReporter)one, (MetricsReporter)LoggingMetricsReporter.instance());
        MetricsReporter secondComposite = MetricsReporters.combine((MetricsReporter)two, (MetricsReporter)LoggingMetricsReporter.instance());
        MetricsReporter combined = MetricsReporters.combine((MetricsReporter)firstComposite, (MetricsReporter)two);
        Assertions.assertThat((Object)combined).isInstanceOf(MetricsReporters.CompositeMetricsReporter.class);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)((MetricsReporters.CompositeMetricsReporter)combined).reporters()).hasSize(3)).containsExactlyInAnyOrder((Object[])new MetricsReporter[]{one, two, LoggingMetricsReporter.instance()});
        combined = MetricsReporters.combine((MetricsReporter)firstComposite, (MetricsReporter)secondComposite);
        Assertions.assertThat((Object)combined).isInstanceOf(MetricsReporters.CompositeMetricsReporter.class);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)((MetricsReporters.CompositeMetricsReporter)combined).reporters()).hasSize(3)).containsExactlyInAnyOrder((Object[])new MetricsReporter[]{one, two, LoggingMetricsReporter.instance()});
    }

    @Test
    public void reportWithMultipleMetricsReporters() {
        AtomicInteger counter = new AtomicInteger();
        MetricsReporter combined = MetricsReporters.combine(report -> counter.incrementAndGet(), report -> counter.incrementAndGet());
        combined.report(new MetricsReport(){});
        Assertions.assertThat((Object)combined).isInstanceOf(MetricsReporters.CompositeMetricsReporter.class);
        Assertions.assertThat((Collection)((MetricsReporters.CompositeMetricsReporter)combined).reporters()).hasSize(2);
        Assertions.assertThat((int)counter.get()).isEqualTo(2);
    }

    @Test
    public void reportWithMultipleMetricsReportersOneFails() {
        AtomicInteger counter = new AtomicInteger();
        MetricsReporter combined = MetricsReporters.combine((MetricsReporter)MetricsReporters.combine(report -> counter.incrementAndGet(), report -> {
            throw new RuntimeException("invalid report");
        }), report -> counter.incrementAndGet());
        combined.report(new MetricsReport(){});
        Assertions.assertThat((Object)combined).isInstanceOf(MetricsReporters.CompositeMetricsReporter.class);
        Assertions.assertThat((Collection)((MetricsReporters.CompositeMetricsReporter)combined).reporters()).hasSize(3);
        Assertions.assertThat((int)counter.get()).isEqualTo(2);
    }
}

