/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.metrics.CounterResult;
import org.apache.iceberg.metrics.CounterResultParser;
import org.apache.iceberg.metrics.MetricsContext;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestCounterResultParser {
    @Test
    public void nullCounter() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CounterResultParser.fromJson((JsonNode)null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse counter from null object");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CounterResultParser.toJson(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid counter: null");
    }

    @Test
    public void missingFields() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CounterResultParser.fromJson((String)"{}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing string: unit");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CounterResultParser.fromJson((String)"{\"unit\":\"bytes\"}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing long: value");
    }

    @Test
    public void extraFields() {
        Assertions.assertThat((Object)CounterResultParser.fromJson((String)"{\"unit\":\"bytes\",\"value\":23,\"extra\": \"value\"}")).isEqualTo((Object)CounterResult.of((MetricsContext.Unit)MetricsContext.Unit.BYTES, (long)23L));
    }

    @Test
    public void unsupportedUnit() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CounterResultParser.fromJson((String)"{\"unit\":\"unknown\",\"value\":23}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid unit: unknown");
    }

    @Test
    public void invalidValue() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CounterResultParser.fromJson((String)"{\"unit\":\"count\",\"value\":\"illegal\"}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to a long value: value: \"illegal\"");
    }

    @Test
    public void roundTripSerde() {
        CounterResult counter = CounterResult.of((MetricsContext.Unit)MetricsContext.Unit.BYTES, (long)Long.MAX_VALUE);
        String json = CounterResultParser.toJson((CounterResult)counter);
        Assertions.assertThat((Object)CounterResultParser.fromJson((String)json)).isEqualTo((Object)counter);
        Assertions.assertThat((String)json).isEqualTo("{\"unit\":\"bytes\",\"value\":9223372036854775807}");
    }
}

