/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.metrics.CommitMetrics;
import org.apache.iceberg.metrics.CommitMetricsResult;
import org.apache.iceberg.metrics.CommitReport;
import org.apache.iceberg.metrics.CommitReportParser;
import org.apache.iceberg.metrics.DefaultMetricsContext;
import org.apache.iceberg.metrics.ImmutableCommitReport;
import org.apache.iceberg.metrics.MetricsContext;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestCommitReportParser {
    @Test
    public void nullCommitReport() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CommitReportParser.fromJson((JsonNode)null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse commit report from null object");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CommitReportParser.toJson(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid commit report: null");
    }

    @Test
    public void missingFields() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CommitReportParser.fromJson((String)"{}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing string: table-name");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CommitReportParser.fromJson((String)"{\"table-name\":\"roundTripTableName\"}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing long: snapshot-id");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CommitReportParser.fromJson((String)"{\"table-name\":\"roundTripTableName\",\"snapshot-id\":23}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing long: sequence-number");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CommitReportParser.fromJson((String)"{\"table-name\":\"roundTripTableName\",\"snapshot-id\":23,\"sequence-number\":24}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing string: operation");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CommitReportParser.fromJson((String)"{\"table-name\":\"roundTripTableName\",\"snapshot-id\":23,\"sequence-number\":24, \"operation\": \"DELETE\"}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse missing field: metrics");
    }

    @Test
    public void invalidTableName() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CommitReportParser.fromJson((String)"{\"table-name\":23}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to a string value: table-name: 23");
    }

    @Test
    public void invalidSnapshotId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CommitReportParser.fromJson((String)"{\"table-name\":\"roundTripTableName\",\"snapshot-id\":\"invalid\"}")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse to a long value: snapshot-id: \"invalid\"");
    }

    @Test
    public void roundTripSerde() {
        CommitMetrics commitMetrics = CommitMetrics.of((MetricsContext)new DefaultMetricsContext());
        commitMetrics.totalDuration().record(100L, TimeUnit.SECONDS);
        commitMetrics.attempts().increment(4);
        ImmutableMap snapshotSummary = ImmutableMap.builder().put((Object)"added-data-files", (Object)"1").put((Object)"deleted-data-files", (Object)"2").put((Object)"total-data-files", (Object)"3").put((Object)"added-delete-files", (Object)"4").put((Object)"added-equality-delete-files", (Object)"5").put((Object)"added-position-delete-files", (Object)"6").put((Object)"removed-position-delete-files", (Object)"7").put((Object)"removed-equality-delete-files", (Object)"8").put((Object)"removed-delete-files", (Object)"9").put((Object)"total-delete-files", (Object)"10").put((Object)"added-records", (Object)"11").put((Object)"deleted-records", (Object)"12").put((Object)"total-records", (Object)"13").put((Object)"added-files-size", (Object)"14").put((Object)"removed-files-size", (Object)"15").put((Object)"total-files-size", (Object)"16").put((Object)"added-position-deletes", (Object)"17").put((Object)"added-equality-deletes", (Object)"18").put((Object)"removed-position-deletes", (Object)"19").put((Object)"removed-equality-deletes", (Object)"20").put((Object)"total-position-deletes", (Object)"21").put((Object)"total-equality-deletes", (Object)"22").build();
        String tableName = "roundTripTableName";
        ImmutableCommitReport commitReport = ImmutableCommitReport.builder().tableName(tableName).snapshotId(23L).operation("DELETE").sequenceNumber(4L).commitMetrics(CommitMetricsResult.from((CommitMetrics)commitMetrics, (Map)snapshotSummary)).build();
        String expectedJson = "{\n  \"table-name\" : \"roundTripTableName\",\n  \"snapshot-id\" : 23,\n  \"sequence-number\" : 4,\n  \"operation\" : \"DELETE\",\n  \"metrics\" : {\n    \"total-duration\" : {\n      \"count\" : 1,\n      \"time-unit\" : \"nanoseconds\",\n      \"total-duration\" : 100000000000\n    },\n    \"attempts\" : {\n      \"unit\" : \"count\",\n      \"value\" : 4\n    },\n    \"added-data-files\" : {\n      \"unit\" : \"count\",\n      \"value\" : 1\n    },\n    \"removed-data-files\" : {\n      \"unit\" : \"count\",\n      \"value\" : 2\n    },\n    \"total-data-files\" : {\n      \"unit\" : \"count\",\n      \"value\" : 3\n    },\n    \"added-delete-files\" : {\n      \"unit\" : \"count\",\n      \"value\" : 4\n    },\n    \"added-equality-delete-files\" : {\n      \"unit\" : \"count\",\n      \"value\" : 5\n    },\n    \"added-positional-delete-files\" : {\n      \"unit\" : \"count\",\n      \"value\" : 6\n    },\n    \"removed-delete-files\" : {\n      \"unit\" : \"count\",\n      \"value\" : 9\n    },\n    \"removed-positional-delete-files\" : {\n      \"unit\" : \"count\",\n      \"value\" : 7\n    },\n    \"removed-equality-delete-files\" : {\n      \"unit\" : \"count\",\n      \"value\" : 8\n    },\n    \"total-delete-files\" : {\n      \"unit\" : \"count\",\n      \"value\" : 10\n    },\n    \"added-records\" : {\n      \"unit\" : \"count\",\n      \"value\" : 11\n    },\n    \"removed-records\" : {\n      \"unit\" : \"count\",\n      \"value\" : 12\n    },\n    \"total-records\" : {\n      \"unit\" : \"count\",\n      \"value\" : 13\n    },\n    \"added-files-size-bytes\" : {\n      \"unit\" : \"bytes\",\n      \"value\" : 14\n    },\n    \"removed-files-size-bytes\" : {\n      \"unit\" : \"bytes\",\n      \"value\" : 15\n    },\n    \"total-files-size-bytes\" : {\n      \"unit\" : \"bytes\",\n      \"value\" : 16\n    },\n    \"added-positional-deletes\" : {\n      \"unit\" : \"count\",\n      \"value\" : 17\n    },\n    \"removed-positional-deletes\" : {\n      \"unit\" : \"count\",\n      \"value\" : 19\n    },\n    \"total-positional-deletes\" : {\n      \"unit\" : \"count\",\n      \"value\" : 21\n    },\n    \"added-equality-deletes\" : {\n      \"unit\" : \"count\",\n      \"value\" : 18\n    },\n    \"removed-equality-deletes\" : {\n      \"unit\" : \"count\",\n      \"value\" : 20\n    },\n    \"total-equality-deletes\" : {\n      \"unit\" : \"count\",\n      \"value\" : 22\n    }\n  }\n}";
        String json = CommitReportParser.toJson((CommitReport)commitReport, (boolean)true);
        Assertions.assertThat((Object)CommitReportParser.fromJson((String)json)).isEqualTo((Object)commitReport);
        Assertions.assertThat((String)json).isEqualTo(expectedJson);
    }

    @Test
    public void roundTripSerdeWithNoopMetrics() {
        String tableName = "roundTripTableName";
        ImmutableCommitReport commitReport = ImmutableCommitReport.builder().tableName(tableName).snapshotId(23L).operation("DELETE").sequenceNumber(4L).commitMetrics(CommitMetricsResult.from((CommitMetrics)CommitMetrics.noop(), (Map)org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap.of())).build();
        String expectedJson = "{\n  \"table-name\" : \"roundTripTableName\",\n  \"snapshot-id\" : 23,\n  \"sequence-number\" : 4,\n  \"operation\" : \"DELETE\",\n  \"metrics\" : { }\n}";
        String json = CommitReportParser.toJson((CommitReport)commitReport, (boolean)true);
        Assertions.assertThat((Object)CommitReportParser.fromJson((String)json)).isEqualTo((Object)commitReport);
        Assertions.assertThat((String)json).isEqualTo(expectedJson);
    }

    @Test
    public void roundTripSerdeWithMetadata() {
        String tableName = "roundTripTableName";
        ImmutableCommitReport commitReport = ImmutableCommitReport.builder().tableName(tableName).snapshotId(23L).operation("DELETE").sequenceNumber(4L).commitMetrics(CommitMetricsResult.from((CommitMetrics)CommitMetrics.noop(), (Map)org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap.of())).metadata((Map)org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2")).build();
        String expectedJson = "{\n  \"table-name\" : \"roundTripTableName\",\n  \"snapshot-id\" : 23,\n  \"sequence-number\" : 4,\n  \"operation\" : \"DELETE\",\n  \"metrics\" : { },\n  \"metadata\" : {\n    \"k1\" : \"v1\",\n    \"k2\" : \"v2\"\n  }\n}";
        String json = CommitReportParser.toJson((CommitReport)commitReport, (boolean)true);
        Assertions.assertThat((Object)CommitReportParser.fromJson((String)json)).isEqualTo((Object)commitReport);
        Assertions.assertThat((String)json).isEqualTo(expectedJson);
    }
}

