/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.SnapshotSummary;
import org.apache.iceberg.metrics.CommitMetrics;
import org.apache.iceberg.metrics.CommitMetricsResult;
import org.apache.iceberg.metrics.CommitMetricsResultParser;
import org.apache.iceberg.metrics.DefaultMetricsContext;
import org.apache.iceberg.metrics.ImmutableCommitMetricsResult;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestCommitMetricsResultParser {
    @Test
    public void nullMetrics() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CommitMetricsResultParser.fromJson((JsonNode)null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse commit metrics from null object");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CommitMetricsResultParser.toJson(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid commit metrics: null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CommitMetricsResult.from(null, (Map)ImmutableMap.of())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid commit metrics: null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CommitMetricsResult.from((CommitMetrics)CommitMetrics.of((MetricsContext)new DefaultMetricsContext()), null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid snapshot summary: null");
    }

    @Test
    public void invalidNumberInSnapshotSummary() {
        CommitMetricsResult result = CommitMetricsResult.from((CommitMetrics)CommitMetrics.of((MetricsContext)new DefaultMetricsContext()), (Map)ImmutableMap.of((Object)"added-data-files", (Object)"xyz"));
        Assertions.assertThat((Object)result.addedDataFiles()).isNull();
    }

    @Test
    public void roundTripSerde() {
        CommitMetrics commitMetrics = CommitMetrics.of((MetricsContext)new DefaultMetricsContext());
        commitMetrics.totalDuration().record(100L, TimeUnit.SECONDS);
        commitMetrics.attempts().increment(4);
        ImmutableMap snapshotSummary = ImmutableMap.builder().put((Object)"added-data-files", (Object)"1").put((Object)"deleted-data-files", (Object)"2").put((Object)"total-data-files", (Object)"3").put((Object)"added-delete-files", (Object)"4").put((Object)"added-equality-delete-files", (Object)"5").put((Object)"added-position-delete-files", (Object)"6").put((Object)"removed-position-delete-files", (Object)"7").put((Object)"removed-equality-delete-files", (Object)"8").put((Object)"removed-delete-files", (Object)"9").put((Object)"total-delete-files", (Object)"10").put((Object)"added-records", (Object)"11").put((Object)"deleted-records", (Object)"12").put((Object)"total-records", (Object)"13").put((Object)"added-files-size", (Object)"14").put((Object)"removed-files-size", (Object)"15").put((Object)"total-files-size", (Object)"16").put((Object)"added-position-deletes", (Object)"17").put((Object)"added-equality-deletes", (Object)"18").put((Object)"removed-position-deletes", (Object)"19").put((Object)"removed-equality-deletes", (Object)"20").put((Object)"total-position-deletes", (Object)"21").put((Object)"total-equality-deletes", (Object)"22").build();
        CommitMetricsResult result = CommitMetricsResult.from((CommitMetrics)commitMetrics, (Map)snapshotSummary);
        Assertions.assertThat((long)result.attempts().value()).isEqualTo(4L);
        Assertions.assertThat((Duration)result.totalDuration().totalDuration()).isEqualTo((Object)Duration.ofSeconds(100L));
        Assertions.assertThat((long)result.addedDataFiles().value()).isEqualTo(1L);
        Assertions.assertThat((long)result.removedDataFiles().value()).isEqualTo(2L);
        Assertions.assertThat((long)result.totalDataFiles().value()).isEqualTo(3L);
        Assertions.assertThat((long)result.addedDeleteFiles().value()).isEqualTo(4L);
        Assertions.assertThat((long)result.addedEqualityDeleteFiles().value()).isEqualTo(5L);
        Assertions.assertThat((long)result.addedPositionalDeleteFiles().value()).isEqualTo(6L);
        Assertions.assertThat((long)result.removedPositionalDeleteFiles().value()).isEqualTo(7L);
        Assertions.assertThat((long)result.removedEqualityDeleteFiles().value()).isEqualTo(8L);
        Assertions.assertThat((long)result.removedDeleteFiles().value()).isEqualTo(9L);
        Assertions.assertThat((long)result.totalDeleteFiles().value()).isEqualTo(10L);
        Assertions.assertThat((long)result.addedRecords().value()).isEqualTo(11L);
        Assertions.assertThat((long)result.removedRecords().value()).isEqualTo(12L);
        Assertions.assertThat((long)result.totalRecords().value()).isEqualTo(13L);
        Assertions.assertThat((long)result.addedFilesSizeInBytes().value()).isEqualTo(14L);
        Assertions.assertThat((long)result.removedFilesSizeInBytes().value()).isEqualTo(15L);
        Assertions.assertThat((long)result.totalFilesSizeInBytes().value()).isEqualTo(16L);
        Assertions.assertThat((long)result.addedPositionalDeletes().value()).isEqualTo(17L);
        Assertions.assertThat((long)result.addedEqualityDeletes().value()).isEqualTo(18L);
        Assertions.assertThat((long)result.removedPositionalDeletes().value()).isEqualTo(19L);
        Assertions.assertThat((long)result.removedEqualityDeletes().value()).isEqualTo(20L);
        Assertions.assertThat((long)result.totalPositionalDeletes().value()).isEqualTo(21L);
        Assertions.assertThat((long)result.totalEqualityDeletes().value()).isEqualTo(22L);
        String expectedJson = "{\n  \"total-duration\" : {\n    \"count\" : 1,\n    \"time-unit\" : \"nanoseconds\",\n    \"total-duration\" : 100000000000\n  },\n  \"attempts\" : {\n    \"unit\" : \"count\",\n    \"value\" : 4\n  },\n  \"added-data-files\" : {\n    \"unit\" : \"count\",\n    \"value\" : 1\n  },\n  \"removed-data-files\" : {\n    \"unit\" : \"count\",\n    \"value\" : 2\n  },\n  \"total-data-files\" : {\n    \"unit\" : \"count\",\n    \"value\" : 3\n  },\n  \"added-delete-files\" : {\n    \"unit\" : \"count\",\n    \"value\" : 4\n  },\n  \"added-equality-delete-files\" : {\n    \"unit\" : \"count\",\n    \"value\" : 5\n  },\n  \"added-positional-delete-files\" : {\n    \"unit\" : \"count\",\n    \"value\" : 6\n  },\n  \"removed-delete-files\" : {\n    \"unit\" : \"count\",\n    \"value\" : 9\n  },\n  \"removed-positional-delete-files\" : {\n    \"unit\" : \"count\",\n    \"value\" : 7\n  },\n  \"removed-equality-delete-files\" : {\n    \"unit\" : \"count\",\n    \"value\" : 8\n  },\n  \"total-delete-files\" : {\n    \"unit\" : \"count\",\n    \"value\" : 10\n  },\n  \"added-records\" : {\n    \"unit\" : \"count\",\n    \"value\" : 11\n  },\n  \"removed-records\" : {\n    \"unit\" : \"count\",\n    \"value\" : 12\n  },\n  \"total-records\" : {\n    \"unit\" : \"count\",\n    \"value\" : 13\n  },\n  \"added-files-size-bytes\" : {\n    \"unit\" : \"bytes\",\n    \"value\" : 14\n  },\n  \"removed-files-size-bytes\" : {\n    \"unit\" : \"bytes\",\n    \"value\" : 15\n  },\n  \"total-files-size-bytes\" : {\n    \"unit\" : \"bytes\",\n    \"value\" : 16\n  },\n  \"added-positional-deletes\" : {\n    \"unit\" : \"count\",\n    \"value\" : 17\n  },\n  \"removed-positional-deletes\" : {\n    \"unit\" : \"count\",\n    \"value\" : 19\n  },\n  \"total-positional-deletes\" : {\n    \"unit\" : \"count\",\n    \"value\" : 21\n  },\n  \"added-equality-deletes\" : {\n    \"unit\" : \"count\",\n    \"value\" : 18\n  },\n  \"removed-equality-deletes\" : {\n    \"unit\" : \"count\",\n    \"value\" : 20\n  },\n  \"total-equality-deletes\" : {\n    \"unit\" : \"count\",\n    \"value\" : 22\n  }\n}";
        String json = CommitMetricsResultParser.toJson((CommitMetricsResult)result, (boolean)true);
        Assertions.assertThat((Object)CommitMetricsResultParser.fromJson((String)json)).isEqualTo((Object)result);
        Assertions.assertThat((String)json).isEqualTo(expectedJson);
    }

    @Test
    public void roundTripSerdeNoopCommitMetrics() {
        CommitMetricsResult commitMetricsResult = CommitMetricsResult.from((CommitMetrics)CommitMetrics.noop(), (Map)SnapshotSummary.builder().build());
        String expectedJson = "{ }";
        String json = CommitMetricsResultParser.toJson((CommitMetricsResult)commitMetricsResult, (boolean)true);
        System.out.println(json);
        Assertions.assertThat((String)json).isEqualTo(expectedJson);
        Assertions.assertThat((Object)CommitMetricsResultParser.fromJson((String)json)).isEqualTo((Object)ImmutableCommitMetricsResult.builder().build());
    }
}

