/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mapping;

import org.apache.iceberg.Schema;
import org.apache.iceberg.mapping.MappedField;
import org.apache.iceberg.mapping.MappedFields;
import org.apache.iceberg.mapping.MappingUtil;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestNameMapping {
    @Test
    public void testFlatSchemaToMapping() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        MappedFields expected = MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)1, (String)"id"), MappedField.of((Integer)2, (String)"data")});
        NameMapping mapping = MappingUtil.create((Schema)schema);
        Assert.assertEquals((Object)expected, (Object)mapping.asMappedFields());
    }

    @Test
    public void testNestedStructSchemaToMapping() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)4, (String)"latitude", (Type)Types.FloatType.get()), Types.NestedField.required((int)5, (String)"longitude", (Type)Types.FloatType.get())}))});
        MappedFields expected = MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)1, (String)"id"), MappedField.of((Integer)2, (String)"data"), MappedField.of((Integer)3, (String)"location", (MappedFields)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)4, (String)"latitude"), MappedField.of((Integer)5, (String)"longitude")}))});
        NameMapping mapping = MappingUtil.create((Schema)schema);
        Assert.assertEquals((Object)expected, (Object)mapping.asMappedFields());
    }

    @Test
    public void testMapSchemaToMapping() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"map", (Type)Types.MapType.ofRequired((int)4, (int)5, (Type)Types.StringType.get(), (Type)Types.DoubleType.get()))});
        MappedFields expected = MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)1, (String)"id"), MappedField.of((Integer)2, (String)"data"), MappedField.of((Integer)3, (String)"map", (MappedFields)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)4, (String)"key"), MappedField.of((Integer)5, (String)"value")}))});
        NameMapping mapping = MappingUtil.create((Schema)schema);
        Assert.assertEquals((Object)expected, (Object)mapping.asMappedFields());
    }

    @Test
    public void testComplexKeyMapSchemaToMapping() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"map", (Type)Types.MapType.ofRequired((int)4, (int)5, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)6, (String)"x", (Type)Types.DoubleType.get()), Types.NestedField.required((int)7, (String)"y", (Type)Types.DoubleType.get())}), (Type)Types.DoubleType.get()))});
        MappedFields expected = MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)1, (String)"id"), MappedField.of((Integer)2, (String)"data"), MappedField.of((Integer)3, (String)"map", (MappedFields)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)4, (String)"key", (MappedFields)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)6, (String)"x"), MappedField.of((Integer)7, (String)"y")})), MappedField.of((Integer)5, (String)"value")}))});
        NameMapping mapping = MappingUtil.create((Schema)schema);
        Assert.assertEquals((Object)expected, (Object)mapping.asMappedFields());
    }

    @Test
    public void testComplexValueMapSchemaToMapping() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"map", (Type)Types.MapType.ofRequired((int)4, (int)5, (Type)Types.DoubleType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)6, (String)"x", (Type)Types.DoubleType.get()), Types.NestedField.required((int)7, (String)"y", (Type)Types.DoubleType.get())})))});
        MappedFields expected = MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)1, (String)"id"), MappedField.of((Integer)2, (String)"data"), MappedField.of((Integer)3, (String)"map", (MappedFields)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)4, (String)"key"), MappedField.of((Integer)5, (String)"value", (MappedFields)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)6, (String)"x"), MappedField.of((Integer)7, (String)"y")}))}))});
        NameMapping mapping = MappingUtil.create((Schema)schema);
        Assert.assertEquals((Object)expected, (Object)mapping.asMappedFields());
    }

    @Test
    public void testListSchemaToMapping() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"list", (Type)Types.ListType.ofRequired((int)4, (Type)Types.StringType.get()))});
        MappedFields expected = MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)1, (String)"id"), MappedField.of((Integer)2, (String)"data"), MappedField.of((Integer)3, (String)"list", (MappedFields)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)4, (String)"element")}))});
        NameMapping mapping = MappingUtil.create((Schema)schema);
        Assert.assertEquals((Object)expected, (Object)mapping.asMappedFields());
    }

    @Test
    public void testFailsDuplicateId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)1, (String)"data", (Type)Types.StringType.get())})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Multiple entries with same key: 1=id and 1=data");
    }

    @Test
    public void testFailsDuplicateName() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new NameMapping(MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)1, (String)"x"), MappedField.of((Integer)2, (String)"x")}))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Multiple entries with same key: x=2 and x=1");
    }

    @Test
    public void testAllowsDuplicateNamesInSeparateContexts() {
        new NameMapping(MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)1, (String)"x", (MappedFields)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)3, (String)"x")})), MappedField.of((Integer)2, (String)"y", (MappedFields)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)4, (String)"x")}))}));
    }

    @Test
    public void testMappingFindById() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"map", (Type)Types.MapType.ofRequired((int)4, (int)5, (Type)Types.DoubleType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)6, (String)"x", (Type)Types.DoubleType.get()), Types.NestedField.required((int)7, (String)"y", (Type)Types.DoubleType.get())}))), Types.NestedField.required((int)8, (String)"list", (Type)Types.ListType.ofRequired((int)9, (Type)Types.StringType.get())), Types.NestedField.required((int)10, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)11, (String)"latitude", (Type)Types.FloatType.get()), Types.NestedField.required((int)12, (String)"longitude", (Type)Types.FloatType.get())}))});
        NameMapping mapping = MappingUtil.create((Schema)schema);
        Assert.assertNull((String)"Should not return a field mapping for a missing ID", (Object)mapping.find(100));
        Assert.assertEquals((Object)MappedField.of((Integer)2, (String)"data"), (Object)mapping.find(2));
        Assert.assertEquals((Object)MappedField.of((Integer)6, (String)"x"), (Object)mapping.find(6));
        Assert.assertEquals((Object)MappedField.of((Integer)9, (String)"element"), (Object)mapping.find(9));
        Assert.assertEquals((Object)MappedField.of((Integer)11, (String)"latitude"), (Object)mapping.find(11));
        Assert.assertEquals((Object)MappedField.of((Integer)10, (String)"location", (MappedFields)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)11, (String)"latitude"), MappedField.of((Integer)12, (String)"longitude")})), (Object)mapping.find(10));
    }

    @Test
    public void testMappingFindByName() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"map", (Type)Types.MapType.ofRequired((int)4, (int)5, (Type)Types.DoubleType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)6, (String)"x", (Type)Types.DoubleType.get()), Types.NestedField.required((int)7, (String)"y", (Type)Types.DoubleType.get())}))), Types.NestedField.required((int)8, (String)"list", (Type)Types.ListType.ofRequired((int)9, (Type)Types.StringType.get())), Types.NestedField.required((int)10, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)11, (String)"latitude", (Type)Types.FloatType.get()), Types.NestedField.required((int)12, (String)"longitude", (Type)Types.FloatType.get())}))});
        NameMapping mapping = MappingUtil.create((Schema)schema);
        Assert.assertNull((String)"Should not return a field mapping for a nested name", (Object)mapping.find(new String[]{"element"}));
        Assert.assertNull((String)"Should not return a field mapping for a nested name", (Object)mapping.find(new String[]{"x"}));
        Assert.assertNull((String)"Should not return a field mapping for a nested name", (Object)mapping.find(new String[]{"key"}));
        Assert.assertNull((String)"Should not return a field mapping for a nested name", (Object)mapping.find(new String[]{"value"}));
        Assert.assertEquals((Object)MappedField.of((Integer)2, (String)"data"), (Object)mapping.find(new String[]{"data"}));
        Assert.assertEquals((Object)MappedField.of((Integer)6, (String)"x"), (Object)mapping.find(new String[]{"map", "value", "x"}));
        Assert.assertEquals((Object)MappedField.of((Integer)9, (String)"element"), (Object)mapping.find(new String[]{"list", "element"}));
        Assert.assertEquals((Object)MappedField.of((Integer)11, (String)"latitude"), (Object)mapping.find(new String[]{"location", "latitude"}));
        Assert.assertEquals((Object)MappedField.of((Integer)10, (String)"location", (MappedFields)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)11, (String)"latitude"), MappedField.of((Integer)12, (String)"longitude")})), (Object)mapping.find(new String[]{"location"}));
    }
}

