/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mapping;

import org.apache.iceberg.Schema;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.mapping.MappedField;
import org.apache.iceberg.mapping.MappedFields;
import org.apache.iceberg.mapping.MappingUtil;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestMappingUpdates
extends TableTestBase {
    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestMappingUpdates(int formatVersion) {
        super(formatVersion);
    }

    @Test
    public void testAddColumnMappingUpdate() {
        NameMapping mapping = MappingUtil.create((Schema)this.table.schema());
        this.table.updateProperties().set("schema.name-mapping.default", NameMappingParser.toJson((NameMapping)mapping)).commit();
        Assert.assertEquals((Object)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)1, (String)"id"), MappedField.of((Integer)2, (String)"data")}), (Object)mapping.asMappedFields());
        this.table.updateSchema().addColumn("ts", (Type)Types.TimestampType.withZone()).commit();
        NameMapping updated = NameMappingParser.fromJson((String)((String)this.table.properties().get("schema.name-mapping.default")));
        Assert.assertEquals((Object)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)1, (String)"id"), MappedField.of((Integer)2, (String)"data"), MappedField.of((Integer)3, (String)"ts")}), (Object)updated.asMappedFields());
    }

    @Test
    public void testAddNestedColumnMappingUpdate() {
        NameMapping mapping = MappingUtil.create((Schema)this.table.schema());
        this.table.updateProperties().set("schema.name-mapping.default", NameMappingParser.toJson((NameMapping)mapping)).commit();
        Assert.assertEquals((Object)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)1, (String)"id"), MappedField.of((Integer)2, (String)"data")}), (Object)mapping.asMappedFields());
        this.table.updateSchema().addColumn("point", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"x", (Type)Types.DoubleType.get()), Types.NestedField.required((int)2, (String)"y", (Type)Types.DoubleType.get())})).commit();
        NameMapping updated = NameMappingParser.fromJson((String)((String)this.table.properties().get("schema.name-mapping.default")));
        Assert.assertEquals((Object)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)1, (String)"id"), MappedField.of((Integer)2, (String)"data"), MappedField.of((Integer)3, (String)"point", (MappedFields)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)4, (String)"x"), MappedField.of((Integer)5, (String)"y")}))}), (Object)updated.asMappedFields());
        this.table.updateSchema().addColumn("point", "z", (Type)Types.DoubleType.get()).commit();
        NameMapping pointUpdated = NameMappingParser.fromJson((String)((String)this.table.properties().get("schema.name-mapping.default")));
        Assert.assertEquals((Object)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)1, (String)"id"), MappedField.of((Integer)2, (String)"data"), MappedField.of((Integer)3, (String)"point", (MappedFields)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)4, (String)"x"), MappedField.of((Integer)5, (String)"y"), MappedField.of((Integer)6, (String)"z")}))}), (Object)pointUpdated.asMappedFields());
    }

    @Test
    public void testRenameMappingUpdate() {
        NameMapping mapping = MappingUtil.create((Schema)this.table.schema());
        this.table.updateProperties().set("schema.name-mapping.default", NameMappingParser.toJson((NameMapping)mapping)).commit();
        Assert.assertEquals((Object)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)1, (String)"id"), MappedField.of((Integer)2, (String)"data")}), (Object)mapping.asMappedFields());
        this.table.updateSchema().renameColumn("id", "object_id").commit();
        NameMapping updated = NameMappingParser.fromJson((String)((String)this.table.properties().get("schema.name-mapping.default")));
        Assert.assertEquals((Object)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)1, (Iterable)ImmutableList.of((Object)"id", (Object)"object_id")), MappedField.of((Integer)2, (String)"data")}), (Object)updated.asMappedFields());
    }

    @Test
    public void testRenameNestedFieldMappingUpdate() {
        NameMapping mapping = MappingUtil.create((Schema)this.table.schema());
        this.table.updateProperties().set("schema.name-mapping.default", NameMappingParser.toJson((NameMapping)mapping)).commit();
        this.table.updateSchema().addColumn("point", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"x", (Type)Types.DoubleType.get()), Types.NestedField.required((int)2, (String)"y", (Type)Types.DoubleType.get())})).commit();
        NameMapping updated = NameMappingParser.fromJson((String)((String)this.table.properties().get("schema.name-mapping.default")));
        Assert.assertEquals((Object)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)1, (String)"id"), MappedField.of((Integer)2, (String)"data"), MappedField.of((Integer)3, (String)"point", (MappedFields)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)4, (String)"x"), MappedField.of((Integer)5, (String)"y")}))}), (Object)updated.asMappedFields());
        this.table.updateSchema().renameColumn("point.x", "X").renameColumn("point.y", "Y").commit();
        NameMapping pointUpdated = NameMappingParser.fromJson((String)((String)this.table.properties().get("schema.name-mapping.default")));
        Assert.assertEquals((Object)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)1, (String)"id"), MappedField.of((Integer)2, (String)"data"), MappedField.of((Integer)3, (String)"point", (MappedFields)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)4, (Iterable)ImmutableList.of((Object)"x", (Object)"X")), MappedField.of((Integer)5, (Iterable)ImmutableList.of((Object)"y", (Object)"Y"))}))}), (Object)pointUpdated.asMappedFields());
    }

    @Test
    public void testRenameComplexFieldMappingUpdate() {
        NameMapping mapping = MappingUtil.create((Schema)this.table.schema());
        this.table.updateProperties().set("schema.name-mapping.default", NameMappingParser.toJson((NameMapping)mapping)).commit();
        this.table.updateSchema().addColumn("point", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"x", (Type)Types.DoubleType.get()), Types.NestedField.required((int)2, (String)"y", (Type)Types.DoubleType.get())})).commit();
        NameMapping updated = NameMappingParser.fromJson((String)((String)this.table.properties().get("schema.name-mapping.default")));
        Assert.assertEquals((Object)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)1, (String)"id"), MappedField.of((Integer)2, (String)"data"), MappedField.of((Integer)3, (String)"point", (MappedFields)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)4, (String)"x"), MappedField.of((Integer)5, (String)"y")}))}), (Object)updated.asMappedFields());
        this.table.updateSchema().renameColumn("point", "p2").commit();
        NameMapping pointUpdated = NameMappingParser.fromJson((String)((String)this.table.properties().get("schema.name-mapping.default")));
        Assert.assertEquals((Object)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)1, (String)"id"), MappedField.of((Integer)2, (String)"data"), MappedField.of((Integer)3, (Iterable)ImmutableList.of((Object)"point", (Object)"p2"), (MappedFields)MappedFields.of((MappedField[])new MappedField[]{MappedField.of((Integer)4, (String)"x"), MappedField.of((Integer)5, (String)"y")}))}), (Object)pointUpdated.asMappedFields());
    }
}

