/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.jdbc;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.iceberg.jdbc.JdbcUtil;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestJdbcUtil {
    @Test
    public void testFilterAndRemovePrefix() {
        HashMap input = Maps.newHashMap();
        input.put("warehouse", "/tmp/warehouse");
        input.put("user", "foo");
        input.put("jdbc.user", "bar");
        input.put("jdbc.pass", "secret");
        input.put("jdbc.jdbc.abcxyz", "abcxyz");
        Properties expected = new Properties();
        expected.put("user", "bar");
        expected.put("pass", "secret");
        expected.put("jdbc.abcxyz", "abcxyz");
        Properties actual = JdbcUtil.filterAndRemovePrefix((Map)input, (String)"jdbc.");
        Assertions.assertThat((Map)expected).isEqualTo((Object)actual);
    }
}

