/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.jdbc;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.catalog.CatalogTests;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.jdbc.JdbcCatalog;
import org.apache.iceberg.jdbc.JdbcTableOperations;
import org.apache.iceberg.jdbc.JdbcUtil;
import org.apache.iceberg.metrics.MetricsReport;
import org.apache.iceberg.metrics.MetricsReporter;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestJdbcCatalog
extends CatalogTests<JdbcCatalog> {
    static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
    static final PartitionSpec PARTITION_SPEC = PartitionSpec.builderFor((Schema)SCHEMA).bucket("data", 16).build();
    static Configuration conf = new Configuration();
    private static JdbcCatalog catalog;
    private static String warehouseLocation;
    @TempDir
    java.nio.file.Path tableDir;

    @Override
    protected JdbcCatalog catalog() {
        return catalog;
    }

    @Override
    protected boolean supportsNamespaceProperties() {
        return true;
    }

    @Override
    protected boolean supportsNestedNamespaces() {
        return true;
    }

    protected List<String> metadataVersionFiles(String location) {
        return Stream.of(new File(location).listFiles()).filter(file -> !file.isDirectory()).map(File::getName).filter(fileName -> fileName.endsWith("metadata.json")).collect(Collectors.toList());
    }

    protected List<String> manifestFiles(String location) {
        return Stream.of(new File(location).listFiles()).filter(file -> !file.isDirectory()).map(File::getName).filter(fileName -> fileName.endsWith(".avro")).collect(Collectors.toList());
    }

    @BeforeEach
    public void setupTable() throws Exception {
        catalog = this.initCatalog("test_jdbc_catalog", Maps.newHashMap());
    }

    private JdbcCatalog initCatalog(String catalogName, Map<String, String> props) {
        HashMap properties = Maps.newHashMap();
        properties.put("uri", "jdbc:sqlite:file::memory:?ic" + UUID.randomUUID().toString().replace("-", ""));
        properties.put("jdbc.username", "user");
        properties.put("jdbc.password", "password");
        warehouseLocation = this.tableDir.toAbsolutePath().toString();
        properties.put("warehouse", warehouseLocation);
        properties.putAll(props);
        JdbcCatalog jdbcCatalog = new JdbcCatalog();
        jdbcCatalog.setConf((Object)conf);
        jdbcCatalog.initialize(catalogName, (Map)properties);
        return jdbcCatalog;
    }

    @Test
    public void testInitialize() {
        HashMap properties = Maps.newHashMap();
        properties.put("warehouse", this.tableDir.toAbsolutePath().toString());
        properties.put("uri", "jdbc:sqlite:file::memory:?icebergDB");
        JdbcCatalog jdbcCatalog = new JdbcCatalog();
        jdbcCatalog.setConf((Object)conf);
        jdbcCatalog.initialize("test_jdbc_catalog", (Map)properties);
        jdbcCatalog.initialize("test_jdbc_catalog", (Map)properties);
        jdbcCatalog.initialize("test_jdbc_catalog", (Map)properties);
    }

    @Test
    public void testCreateTableBuilder() {
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl"});
        Table table = catalog.buildTable(tableIdent, SCHEMA).withPartitionSpec(PARTITION_SPEC).withProperties(null).withProperty("key1", "value1").withProperties((Map)ImmutableMap.of((Object)"key2", (Object)"value2")).create();
        Assert.assertEquals((Object)SCHEMA.toString(), (Object)table.schema().toString());
        Assert.assertEquals((long)1L, (long)table.spec().fields().size());
        Assert.assertEquals((Object)"value1", table.properties().get("key1"));
        Assert.assertEquals((Object)"value2", table.properties().get("key2"));
    }

    @Test
    public void testCreateTableTxnBuilder() {
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl"});
        Transaction txn = catalog.buildTable(tableIdent, SCHEMA).withPartitionSpec(null).withProperty("key1", "testval1").createTransaction();
        txn.commitTransaction();
        Table table = catalog.loadTable(tableIdent);
        Assert.assertEquals((Object)SCHEMA.toString(), (Object)table.schema().toString());
        Assert.assertTrue((boolean)table.spec().isUnpartitioned());
        Assert.assertEquals((Object)"testval1", table.properties().get("key1"));
    }

    @Test
    public void testReplaceTxnBuilder() {
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl"});
        DataFile fileA = DataFiles.builder((PartitionSpec)PARTITION_SPEC).withPath("/path/to/data-a.parquet").withFileSizeInBytes(0L).withPartitionPath("data_bucket=0").withRecordCount(2L).build();
        Transaction createTxn = catalog.buildTable(tableIdent, SCHEMA).withPartitionSpec(PARTITION_SPEC).withProperty("key1", "value1").createOrReplaceTransaction();
        createTxn.newAppend().appendFile(fileA).commit();
        createTxn.commitTransaction();
        Table table = catalog.loadTable(tableIdent);
        Assert.assertNotNull((Object)table.currentSnapshot());
        Transaction replaceTxn = catalog.buildTable(tableIdent, SCHEMA).withProperty("key2", "value2").replaceTransaction();
        replaceTxn.commitTransaction();
        table = catalog.loadTable(tableIdent);
        Assert.assertNull((Object)table.currentSnapshot());
        PartitionSpec v1Expected = PartitionSpec.builderFor((Schema)table.schema()).alwaysNull("data", "data_bucket").withSpecId(1).build();
        Assert.assertEquals((String)"Table should have a spec with one void field", (Object)v1Expected, (Object)table.spec());
        Assert.assertEquals((Object)"value1", table.properties().get("key1"));
        Assert.assertEquals((Object)"value2", table.properties().get("key2"));
    }

    @Test
    public void testCreateTableDefaultSortOrder() {
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl"});
        Table table = catalog.createTable(tableIdent, SCHEMA, PARTITION_SPEC);
        SortOrder sortOrder = table.sortOrder();
        Assert.assertEquals((String)"Order ID must match", (long)0L, (long)sortOrder.orderId());
        Assert.assertTrue((String)"Order must unsorted", (boolean)sortOrder.isUnsorted());
    }

    @Test
    public void testCreateTableCustomSortOrder() {
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl"});
        SortOrder order = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).asc("id", NullOrder.NULLS_FIRST)).build();
        Table table = catalog.buildTable(tableIdent, SCHEMA).withPartitionSpec(PARTITION_SPEC).withSortOrder(order).create();
        SortOrder sortOrder = table.sortOrder();
        Assert.assertEquals((String)"Order ID must match", (long)1L, (long)sortOrder.orderId());
        Assert.assertEquals((String)"Order must have 1 field", (long)1L, (long)sortOrder.fields().size());
        Assert.assertEquals((String)"Direction must match ", (Object)SortDirection.ASC, (Object)((SortField)sortOrder.fields().get(0)).direction());
        Assert.assertEquals((String)"Null order must match ", (Object)NullOrder.NULLS_FIRST, (Object)((SortField)sortOrder.fields().get(0)).nullOrder());
        Transform transform = Transforms.identity();
        Assert.assertEquals((String)"Transform must match", (Object)transform, (Object)((SortField)sortOrder.fields().get(0)).transform());
    }

    @Test
    public void testBasicCatalog() throws Exception {
        TableIdentifier testTable = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl"});
        catalog.createTable(testTable, SCHEMA, PartitionSpec.unpartitioned());
        String metaLocation = catalog.defaultWarehouseLocation(testTable);
        FileSystem fs = Util.getFs((Path)new Path(metaLocation), (Configuration)conf);
        Assert.assertTrue((boolean)fs.isDirectory(new Path(metaLocation)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.createTable(testTable, SCHEMA, PartitionSpec.unpartitioned())).isInstanceOf(AlreadyExistsException.class)).hasMessage("Table already exists: db.ns1.ns2.tbl");
        catalog.dropTable(testTable);
    }

    @Test
    public void testCreateAndDropTableWithoutNamespace() throws Exception {
        TableIdentifier testTable = TableIdentifier.of((String[])new String[]{"tbl"});
        Table table = catalog.createTable(testTable, SCHEMA, PartitionSpec.unpartitioned());
        Assert.assertEquals((Object)table.schema().toString(), (Object)SCHEMA.toString());
        Assert.assertEquals((Object)(catalog.name() + ".tbl"), (Object)table.name());
        String metaLocation = catalog.defaultWarehouseLocation(testTable);
        FileSystem fs = Util.getFs((Path)new Path(metaLocation), (Configuration)conf);
        Assert.assertTrue((boolean)fs.isDirectory(new Path(metaLocation)));
        catalog.dropTable(testTable, true);
    }

    @Test
    public void testDefaultWarehouseLocation() throws Exception {
        TableIdentifier testTable = TableIdentifier.of((String[])new String[]{"tbl"});
        TableIdentifier testTable2 = TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"ns"}), (String)"tbl");
        Assert.assertEquals((Object)catalog.defaultWarehouseLocation(testTable), (Object)(warehouseLocation + "/" + testTable.name()));
        Assert.assertEquals((Object)catalog.defaultWarehouseLocation(testTable2), (Object)(warehouseLocation + "/" + testTable2.namespace() + "/" + testTable2.name()));
    }

    @Test
    public void testConcurrentCommit() throws IOException {
        TableIdentifier tableIdentifier = TableIdentifier.of((String[])new String[]{"db", "table"});
        Table table = catalog.createTable(tableIdentifier, SCHEMA, PartitionSpec.unpartitioned());
        String data = this.tableDir.resolve("data.parquet").toAbsolutePath().toString();
        Files.write(Paths.get(data, new String[0]), (Iterable<? extends CharSequence>)Lists.newArrayList(), StandardCharsets.UTF_8, new OpenOption[0]);
        DataFile dataFile = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withPath(data).withFileSizeInBytes(10L).withRecordCount(1L).build();
        table.newAppend().appendFile(dataFile).commit();
        Assert.assertEquals((long)1L, (long)table.history().size());
        catalog.dropTable(tableIdentifier);
        data = this.tableDir.resolve("data2.parquet").toAbsolutePath().toString();
        Files.write(Paths.get(data, new String[0]), (Iterable<? extends CharSequence>)Lists.newArrayList(), StandardCharsets.UTF_8, new OpenOption[0]);
        DataFile dataFile2 = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withPath(data).withFileSizeInBytes(10L).withRecordCount(1L).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> table.newAppend().appendFile(dataFile2).commit()).isInstanceOf(NoSuchTableException.class)).hasMessage("Failed to load table db.table from catalog test_jdbc_catalog: dropped by another process");
    }

    @Test
    public void testCommitHistory() throws IOException {
        TableIdentifier testTable = TableIdentifier.of((String[])new String[]{"db", "ns", "tbl"});
        catalog.createTable(testTable, SCHEMA, PartitionSpec.unpartitioned());
        Table table = catalog.loadTable(testTable);
        String data = this.tableDir.resolve("data.parquet").toAbsolutePath().toString();
        Files.write(Paths.get(data, new String[0]), (Iterable<? extends CharSequence>)Lists.newArrayList(), StandardCharsets.UTF_8, new OpenOption[0]);
        DataFile dataFile = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withPath(data).withFileSizeInBytes(10L).withRecordCount(1L).build();
        table.newAppend().appendFile(dataFile).commit();
        Assert.assertEquals((long)1L, (long)table.history().size());
        data = this.tableDir.resolve("data2.parquet").toAbsolutePath().toString();
        Files.write(Paths.get(data, new String[0]), (Iterable<? extends CharSequence>)Lists.newArrayList(), StandardCharsets.UTF_8, new OpenOption[0]);
        dataFile = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withPath(data).withFileSizeInBytes(10L).withRecordCount(1L).build();
        table.newAppend().appendFile(dataFile).commit();
        Assert.assertEquals((long)2L, (long)table.history().size());
        data = this.tableDir.resolve("data3.parquet").toAbsolutePath().toString();
        Files.write(Paths.get(data, new String[0]), (Iterable<? extends CharSequence>)Lists.newArrayList(), StandardCharsets.UTF_8, new OpenOption[0]);
        dataFile = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withPath(data).withFileSizeInBytes(10L).withRecordCount(1L).build();
        table.newAppend().appendFile(dataFile).commit();
        Assert.assertEquals((long)3L, (long)table.history().size());
    }

    @Override
    @Test
    public void testDropTable() {
        TableIdentifier testTable = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl"});
        TableIdentifier testTable2 = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl2"});
        catalog.createTable(testTable, SCHEMA, PartitionSpec.unpartitioned());
        catalog.createTable(testTable2, SCHEMA, PartitionSpec.unpartitioned());
        catalog.dropTable(testTable);
        Assert.assertFalse((boolean)catalog.listTables(testTable.namespace()).contains(testTable));
        catalog.dropTable(testTable2);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.listTables(testTable2.namespace())).isInstanceOf(NoSuchNamespaceException.class)).hasMessage("Namespace does not exist: db.ns1.ns2");
        Assert.assertFalse((boolean)catalog.dropTable(TableIdentifier.of((String[])new String[]{"db", "tbl-not-exists"})));
    }

    @Test
    public void testDropTableWithoutMetadataFile() {
        TableIdentifier testTable = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl"});
        catalog.createTable(testTable, SCHEMA, PartitionSpec.unpartitioned());
        String metadataFileLocation = catalog.newTableOps(testTable).current().metadataFileLocation();
        TableOperations ops = catalog.newTableOps(testTable);
        ops.io().deleteFile(metadataFileLocation);
        Assert.assertTrue((boolean)catalog.dropTable(testTable));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.loadTable(testTable)).isInstanceOf(NoSuchTableException.class)).hasMessageContaining("Table does not exist:");
    }

    @Override
    @Test
    public void testRenameTable() {
        TableIdentifier from = TableIdentifier.of((String[])new String[]{"db", "tbl1"});
        TableIdentifier to = TableIdentifier.of((String[])new String[]{"db", "tbl2-newtable"});
        catalog.createTable(from, SCHEMA, PartitionSpec.unpartitioned());
        catalog.renameTable(from, to);
        Assert.assertTrue((boolean)catalog.listTables(to.namespace()).contains(to));
        Assert.assertFalse((boolean)catalog.listTables(to.namespace()).contains(from));
        Assert.assertTrue((boolean)catalog.loadTable(to).name().endsWith(to.name()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.renameTable(TableIdentifier.of((String[])new String[]{"db", "tbl-not-exists"}), to)).isInstanceOf(NoSuchTableException.class)).hasMessage("Table does not exist: db.tbl-not-exists");
        TableIdentifier from2 = TableIdentifier.of((String[])new String[]{"db", "tbl2"});
        catalog.createTable(from2, SCHEMA, PartitionSpec.unpartitioned());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.renameTable(from2, to)).isInstanceOf(AlreadyExistsException.class)).hasMessage("Table already exists: db.tbl2-newtable");
    }

    @Override
    @Test
    public void testListTables() {
        TableIdentifier tbl1 = TableIdentifier.of((String[])new String[]{"db", "tbl1"});
        TableIdentifier tbl2 = TableIdentifier.of((String[])new String[]{"db", "tbl2"});
        TableIdentifier tbl3 = TableIdentifier.of((String[])new String[]{"db", "tbl2", "subtbl2"});
        TableIdentifier tbl4 = TableIdentifier.of((String[])new String[]{"db", "ns1", "tbl3"});
        TableIdentifier tbl5 = TableIdentifier.of((String[])new String[]{"db", "metadata", "metadata"});
        Lists.newArrayList((Object[])new TableIdentifier[]{tbl1, tbl2, tbl3, tbl4, tbl5}).forEach(t -> catalog.createTable(t, SCHEMA, PartitionSpec.unpartitioned()));
        List tbls1 = catalog.listTables(Namespace.of((String[])new String[]{"db"}));
        HashSet tblSet = Sets.newHashSet(tbls1.stream().map(TableIdentifier::name).iterator());
        Assert.assertEquals((long)tblSet.size(), (long)2L);
        Assert.assertTrue((boolean)tblSet.contains("tbl1"));
        Assert.assertTrue((boolean)tblSet.contains("tbl2"));
        List tbls2 = catalog.listTables(Namespace.of((String[])new String[]{"db", "ns1"}));
        Assert.assertEquals((long)tbls2.size(), (long)1L);
        Assert.assertEquals((Object)"tbl3", (Object)((TableIdentifier)tbls2.get(0)).name());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.listTables(Namespace.of((String[])new String[]{"db", "ns1", "ns2"}))).isInstanceOf(NoSuchNamespaceException.class)).hasMessage("Namespace does not exist: db.ns1.ns2");
    }

    @Test
    public void testCallingLocationProviderWhenNoCurrentMetadata() {
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"ns1", "ns2", "table1"});
        Transaction create = catalog.newCreateTableTransaction(tableIdent, SCHEMA);
        create.table().locationProvider();
        create.commitTransaction();
        Assert.assertEquals((String)"1 table expected", (long)1L, (long)catalog.listTables(Namespace.of((String[])new String[]{"ns1", "ns2"})).size());
        catalog.dropTable(tableIdent, true);
    }

    @Test
    public void testExistingTableUpdate() {
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"ns1", "ns2", "table1"});
        Transaction create = catalog.newCreateTableTransaction(tableIdent, SCHEMA);
        create.table().locationProvider();
        create.commitTransaction();
        Table icebergTable = catalog.loadTable(tableIdent);
        icebergTable.updateSchema().addColumn("Coll3", (Type)Types.LongType.get()).commit();
        icebergTable = catalog.loadTable(tableIdent);
        Assert.assertEquals((long)2L, (long)this.metadataVersionFiles(icebergTable.location() + "/metadata/").size());
        Assert.assertEquals((long)0L, (long)this.manifestFiles(icebergTable.location() + "/metadata/").size());
        Assert.assertNotEquals((Object)SCHEMA.asStruct(), (Object)icebergTable.schema().asStruct());
        Assert.assertTrue((boolean)icebergTable.schema().asStruct().toString().contains("Coll3"));
    }

    @Test
    public void testTableName() {
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl"});
        catalog.buildTable(tableIdent, SCHEMA).withPartitionSpec(PARTITION_SPEC).create();
        Table table = catalog.loadTable(tableIdent);
        Assert.assertEquals((String)"Name must match", (Object)(catalog.name() + ".db.ns1.ns2.tbl"), (Object)table.name());
        TableIdentifier snapshotsTableIdent = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl", "snapshots"});
        Table snapshotsTable = catalog.loadTable(snapshotsTableIdent);
        Assert.assertEquals((String)"Name must match", (Object)(catalog.name() + ".db.ns1.ns2.tbl.snapshots"), (Object)snapshotsTable.name());
    }

    @Test
    public void testListNamespace() {
        TableIdentifier tbl1 = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "metadata"});
        TableIdentifier tbl2 = TableIdentifier.of((String[])new String[]{"db", "ns2", "ns3", "tbl2"});
        TableIdentifier tbl3 = TableIdentifier.of((String[])new String[]{"db", "ns3", "tbl4"});
        TableIdentifier tbl4 = TableIdentifier.of((String[])new String[]{"db", "metadata"});
        TableIdentifier tbl5 = TableIdentifier.of((String[])new String[]{"db2", "metadata"});
        TableIdentifier tbl6 = TableIdentifier.of((String[])new String[]{"tbl6"});
        Lists.newArrayList((Object[])new TableIdentifier[]{tbl1, tbl2, tbl3, tbl4, tbl5, tbl6}).forEach(t -> catalog.createTable(t, SCHEMA, PartitionSpec.unpartitioned()));
        List nsp1 = catalog.listNamespaces(Namespace.of((String[])new String[]{"db"}));
        Assert.assertEquals((long)nsp1.size(), (long)3L);
        HashSet tblSet = Sets.newHashSet(nsp1.stream().map(Namespace::toString).iterator());
        Assert.assertEquals((long)tblSet.size(), (long)3L);
        Assert.assertTrue((boolean)tblSet.contains("db.ns1"));
        Assert.assertTrue((boolean)tblSet.contains("db.ns2"));
        Assert.assertTrue((boolean)tblSet.contains("db.ns3"));
        List nsp2 = catalog.listNamespaces(Namespace.of((String[])new String[]{"db", "ns1"}));
        Assert.assertEquals((long)nsp2.size(), (long)1L);
        Assert.assertEquals((Object)"db.ns1.ns2", (Object)((Namespace)nsp2.get(0)).toString());
        List nsp3 = catalog.listNamespaces();
        HashSet tblSet2 = Sets.newHashSet(nsp3.stream().map(Namespace::toString).iterator());
        Assert.assertEquals((long)tblSet2.size(), (long)3L);
        Assert.assertTrue((boolean)tblSet2.contains("db"));
        Assert.assertTrue((boolean)tblSet2.contains("db2"));
        Assert.assertTrue((boolean)tblSet2.contains(""));
        List nsp4 = catalog.listNamespaces();
        HashSet tblSet3 = Sets.newHashSet(nsp4.stream().map(Namespace::toString).iterator());
        Assert.assertEquals((long)tblSet3.size(), (long)3L);
        Assert.assertTrue((boolean)tblSet3.contains("db"));
        Assert.assertTrue((boolean)tblSet3.contains("db2"));
        Assert.assertTrue((boolean)tblSet3.contains(""));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.listNamespaces(Namespace.of((String[])new String[]{"db", "db2", "ns2"}))).isInstanceOf(NoSuchNamespaceException.class)).hasMessage("Namespace does not exist: db.db2.ns2");
    }

    @Test
    public void testLoadNamespaceMeta() {
        TableIdentifier tbl1 = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "metadata"});
        TableIdentifier tbl2 = TableIdentifier.of((String[])new String[]{"db", "ns2", "ns3", "tbl2"});
        TableIdentifier tbl3 = TableIdentifier.of((String[])new String[]{"db", "ns3", "tbl4"});
        TableIdentifier tbl4 = TableIdentifier.of((String[])new String[]{"db", "metadata"});
        Lists.newArrayList((Object[])new TableIdentifier[]{tbl1, tbl2, tbl3, tbl4}).forEach(t -> catalog.createTable(t, SCHEMA, PartitionSpec.unpartitioned()));
        Assert.assertTrue((boolean)catalog.loadNamespaceMetadata(Namespace.of((String[])new String[]{"db"})).containsKey("location"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.loadNamespaceMetadata(Namespace.of((String[])new String[]{"db", "db2", "ns2"}))).isInstanceOf(NoSuchNamespaceException.class)).hasMessage("Namespace does not exist: db.db2.ns2");
    }

    @Test
    public void testNamespaceExists() {
        TableIdentifier tbl1 = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "metadata"});
        TableIdentifier tbl2 = TableIdentifier.of((String[])new String[]{"db", "ns2", "ns3", "tbl2"});
        TableIdentifier tbl3 = TableIdentifier.of((String[])new String[]{"db", "ns3", "tbl4"});
        TableIdentifier tbl4 = TableIdentifier.of((String[])new String[]{"db", "metadata"});
        Lists.newArrayList((Object[])new TableIdentifier[]{tbl1, tbl2, tbl3, tbl4}).forEach(t -> catalog.createTable(t, SCHEMA, PartitionSpec.unpartitioned()));
        Assert.assertTrue((String)"Should true to namespace exist", (boolean)catalog.namespaceExists(Namespace.of((String[])new String[]{"db", "ns1", "ns2"})));
        Assert.assertFalse((String)"Should false to namespace doesn't exist", (boolean)catalog.namespaceExists(Namespace.of((String[])new String[]{"db", "db2", "not_exist"})));
    }

    @Override
    @Test
    public void testDropNamespace() {
        Assert.assertFalse((String)"Should return false if drop does not modify state", (boolean)catalog.dropNamespace(Namespace.of((String[])new String[]{"db", "ns1_not_exitss"})));
        TableIdentifier tbl0 = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl2"});
        TableIdentifier tbl1 = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl1"});
        TableIdentifier tbl2 = TableIdentifier.of((String[])new String[]{"db", "ns1", "tbl2"});
        TableIdentifier tbl3 = TableIdentifier.of((String[])new String[]{"db", "ns3", "tbl4"});
        TableIdentifier tbl4 = TableIdentifier.of((String[])new String[]{"db", "tbl"});
        Lists.newArrayList((Object[])new TableIdentifier[]{tbl0, tbl1, tbl2, tbl3, tbl4}).forEach(t -> catalog.createTable(t, SCHEMA, PartitionSpec.unpartitioned()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.dropNamespace(tbl1.namespace())).isInstanceOf(NamespaceNotEmptyException.class)).hasMessage("Namespace db.ns1.ns2 is not empty. 2 tables exist.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.dropNamespace(tbl2.namespace())).isInstanceOf(NamespaceNotEmptyException.class)).hasMessage("Namespace db.ns1 is not empty. 1 tables exist.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.dropNamespace(tbl4.namespace())).isInstanceOf(NamespaceNotEmptyException.class)).hasMessage("Namespace db is not empty. 1 tables exist.");
    }

    @Override
    @Test
    public void testCreateNamespace() {
        Namespace testNamespace = Namespace.of((String[])new String[]{"testDb", "ns1", "ns2"});
        Assert.assertFalse((boolean)catalog.namespaceExists(testNamespace));
        catalog.createNamespace(testNamespace);
        Assert.assertTrue((boolean)catalog.namespaceExists(testNamespace));
    }

    @Test
    public void testCreateTableInNonExistingNamespace() {
        try (JdbcCatalog jdbcCatalog = this.initCatalog("non_strict_jdbc_catalog", (Map<String, String>)ImmutableMap.of());){
            Namespace namespace = Namespace.of((String[])new String[]{"testDb", "ns1", "ns2"});
            TableIdentifier identifier = TableIdentifier.of((Namespace)namespace, (String)"someTable");
            Assertions.assertThat((boolean)jdbcCatalog.namespaceExists(namespace)).isFalse();
            Assertions.assertThat((boolean)jdbcCatalog.tableExists(identifier)).isFalse();
            jdbcCatalog.createTable(identifier, SCHEMA, PARTITION_SPEC);
            Assertions.assertThat((Object)jdbcCatalog.loadTable(identifier)).isNotNull();
        }
    }

    @Test
    public void testCreateTableInNonExistingNamespaceStrictMode() {
        try (JdbcCatalog jdbcCatalog = this.initCatalog("strict_jdbc_catalog", (Map<String, String>)ImmutableMap.of((Object)"jdbc.strict-mode", (Object)"true"));){
            Namespace namespace = Namespace.of((String[])new String[]{"testDb", "ns1", "ns2"});
            TableIdentifier identifier = TableIdentifier.of((Namespace)namespace, (String)"someTable");
            Assertions.assertThat((boolean)jdbcCatalog.namespaceExists(namespace)).isFalse();
            Assertions.assertThat((boolean)jdbcCatalog.tableExists(identifier)).isFalse();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> jdbcCatalog.createTable(identifier, SCHEMA, PARTITION_SPEC)).isInstanceOf(NoSuchNamespaceException.class)).hasMessage("Cannot create table testDb.ns1.ns2.someTable in catalog strict_jdbc_catalog. Namespace testDb.ns1.ns2 does not exist");
            Assertions.assertThat((boolean)jdbcCatalog.tableExists(identifier)).isFalse();
            jdbcCatalog.createNamespace(namespace);
            Assertions.assertThat((boolean)jdbcCatalog.tableExists(identifier)).isFalse();
            jdbcCatalog.createTable(identifier, SCHEMA, PARTITION_SPEC);
            Assertions.assertThat((Object)jdbcCatalog.loadTable(identifier)).isNotNull();
        }
    }

    @Test
    public void testCreateNamespaceWithMetadata() {
        Namespace testNamespace = Namespace.of((String[])new String[]{"testDb", "ns1", "ns2"});
        ImmutableMap testMetadata = ImmutableMap.of((Object)"key_1", (Object)"value_1", (Object)"key_2", (Object)"value_2", (Object)"key_3", (Object)"value_3");
        catalog.createNamespace(testNamespace, (Map)testMetadata);
        Assert.assertTrue((boolean)catalog.namespaceExists(testNamespace));
    }

    @Test
    public void testNamespaceLocation() {
        Namespace testNamespace = Namespace.of((String[])new String[]{"testDb", "ns1", "ns2"});
        ImmutableMap testMetadata = ImmutableMap.of();
        catalog.createNamespace(testNamespace, (Map)testMetadata);
        Assertions.assertThat((Map)catalog.loadNamespaceMetadata(testNamespace)).containsKey((Object)"location");
    }

    @Test
    public void testNamespaceCustomLocation() {
        Namespace testNamespace = Namespace.of((String[])new String[]{"testDb", "ns1", "ns2"});
        String namespaceLocation = "file:///tmp/warehouse/ns/path";
        ImmutableMap testMetadata = ImmutableMap.of((Object)"location", (Object)namespaceLocation);
        catalog.createNamespace(testNamespace, (Map)testMetadata);
        Assertions.assertThat((String)((String)catalog.loadNamespaceMetadata(testNamespace).get("location"))).isEqualTo(namespaceLocation);
    }

    @Test
    public void testSetProperties() {
        Namespace testNamespace = Namespace.of((String[])new String[]{"testDb", "ns1", "ns2"});
        ImmutableMap testMetadata = ImmutableMap.of((Object)"key_1", (Object)"value_1", (Object)"key_2", (Object)"value_2", (Object)"key_3", (Object)"value_3");
        catalog.createNamespace(testNamespace, (Map)testMetadata);
        ImmutableMap propertiesToSet = ImmutableMap.of((Object)"key_5", (Object)"value_5", (Object)"key_3", (Object)"new_value_3", (Object)"key_1", (Object)"new_value_1", (Object)"key_4", (Object)"value_4", (Object)"key_2", (Object)"new_value_2");
        Assert.assertTrue((boolean)catalog.namespaceExists(testNamespace));
        Assert.assertTrue((boolean)catalog.setProperties(testNamespace, (Map)propertiesToSet));
        Map allProperties = catalog.loadNamespaceMetadata(testNamespace);
        Assert.assertEquals((long)6L, (long)allProperties.size());
        Map namespaceProperties = catalog.loadNamespaceMetadata(testNamespace);
        Assert.assertEquals((String)"All new keys should be in the namespace properties", propertiesToSet.keySet(), (Object)Sets.intersection(propertiesToSet.keySet(), namespaceProperties.keySet()));
        for (Map.Entry keyValue : propertiesToSet.entrySet()) {
            Assert.assertEquals((String)("Value for key " + (String)keyValue.getKey() + " should match"), keyValue.getValue(), namespaceProperties.get(keyValue.getKey()));
        }
    }

    @Test
    public void testRemoveProperties() {
        Namespace testNamespace = Namespace.of((String[])new String[]{"testDb", "ns1", "ns2"});
        ImmutableMap testMetadata = ImmutableMap.of((Object)"key_1", (Object)"value_1", (Object)"key_2", (Object)"value_2", (Object)"key_3", (Object)"value_3", (Object)"key_4", (Object)"value_4");
        catalog.createNamespace(testNamespace, (Map)testMetadata);
        ImmutableSet propertiesToRemove = ImmutableSet.of((Object)"key_2", (Object)"key_4");
        catalog.removeProperties(testNamespace, (Set)propertiesToRemove);
        Map remainderProperties = catalog.loadNamespaceMetadata(testNamespace);
        Assert.assertEquals((long)3L, (long)remainderProperties.size());
        Assert.assertTrue((boolean)remainderProperties.containsKey("key_1"));
        Assert.assertTrue((boolean)remainderProperties.containsKey("key_3"));
        Assert.assertTrue((boolean)remainderProperties.containsKey("location"));
        ImmutableSet allProperties = ImmutableSet.of((Object)"key_1", (Object)"key_3");
        catalog.removeProperties(testNamespace, (Set)allProperties);
        Assert.assertTrue((boolean)catalog.namespaceExists(testNamespace));
    }

    @Test
    public void testConversions() {
        Namespace ns = Namespace.of((String[])new String[]{"db", "db2", "ns2"});
        String nsString = JdbcUtil.namespaceToString((Namespace)ns);
        Assert.assertEquals((Object)ns, (Object)JdbcUtil.stringToNamespace((String)nsString));
    }

    @Test
    public void testRegisterTable() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"a", "t1"});
        catalog.createTable(identifier, SCHEMA);
        Table registeringTable = catalog.loadTable(identifier);
        catalog.dropTable(identifier, false);
        TableOperations ops = ((HasTableOperations)registeringTable).operations();
        String metadataLocation = ((JdbcTableOperations)ops).currentMetadataLocation();
        Table registeredTable = catalog.registerTable(identifier, metadataLocation);
        Assertions.assertThat((Object)registeredTable).isNotNull();
        TestHelpers.assertSerializedAndLoadedMetadata((Table)registeringTable, (Table)registeredTable);
        String expectedMetadataLocation = ((HasTableOperations)registeredTable).operations().current().metadataFileLocation();
        Assertions.assertThat((String)metadataLocation).isEqualTo(expectedMetadataLocation);
        Assertions.assertThat((Object)catalog.loadTable(identifier)).isNotNull();
        Assertions.assertThat((boolean)catalog.dropTable(identifier)).isTrue();
    }

    @Test
    public void testRegisterExistingTable() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"a", "t1"});
        catalog.createTable(identifier, SCHEMA);
        Table registeringTable = catalog.loadTable(identifier);
        TableOperations ops = ((HasTableOperations)registeringTable).operations();
        String metadataLocation = ((JdbcTableOperations)ops).currentMetadataLocation();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.registerTable(identifier, metadataLocation)).isInstanceOf(AlreadyExistsException.class)).hasMessage("Table already exists: a.t1");
        Assertions.assertThat((boolean)catalog.dropTable(identifier)).isTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCatalogWithCustomMetricsReporter() throws IOException {
        JdbcCatalog catalogWithCustomReporter = this.initCatalog("test_jdbc_catalog_with_custom_reporter", (Map<String, String>)ImmutableMap.of((Object)"metrics-reporter-impl", (Object)CustomMetricsReporter.class.getName()));
        try {
            catalogWithCustomReporter.buildTable(TABLE, SCHEMA).create();
            Table table = catalogWithCustomReporter.loadTable(TABLE);
            table.newFastAppend().appendFile(DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withPath(FileFormat.PARQUET.addExtension(UUID.randomUUID().toString())).withFileSizeInBytes(10L).withRecordCount(2L).build()).commit();
            try (CloseableIterable tasks = table.newScan().planFiles();){
                Assertions.assertThat((Iterator)tasks.iterator()).hasNext();
            }
        }
        finally {
            catalogWithCustomReporter.dropTable(TABLE);
        }
        Assertions.assertThat((int)CustomMetricsReporter.COUNTER.get()).isEqualTo(2);
    }

    public static class CustomMetricsReporter
    implements MetricsReporter {
        static final AtomicInteger COUNTER = new AtomicInteger(0);

        public void report(MetricsReport report) {
            COUNTER.incrementAndGet();
        }
    }
}

