/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.util.Map;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestOutputFileFactory
extends TableTestBase {
    private static final int PARTITION_ID = 1;
    private static final int TASK_ID = 100;

    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestOutputFileFactory(int formatVersion) {
        super(formatVersion);
    }

    @Test
    public void testOutputFileFactoryWithCustomFormat() {
        this.table.updateProperties().defaultFormat(FileFormat.ORC).commit();
        OutputFileFactory fileFactory = OutputFileFactory.builderFor((Table)this.table, (int)1, (long)100L).format(FileFormat.AVRO).build();
        String location = fileFactory.newOutputFile().encryptingOutputFile().location();
        Assert.assertEquals((String)"File format should be correct", (Object)FileFormat.AVRO, (Object)FileFormat.fromFileName((CharSequence)location));
    }

    @Test
    public void testOutputFileFactoryWithMultipleSpecs() {
        OutputFileFactory fileFactory = OutputFileFactory.builderFor((Table)this.table, (int)1, (long)100L).operationId("append").build();
        EncryptedOutputFile unpartitionedFile = fileFactory.newOutputFile(PartitionSpec.unpartitioned(), null);
        String unpartitionedFileLocation = unpartitionedFile.encryptingOutputFile().location();
        Assert.assertTrue((boolean)unpartitionedFileLocation.endsWith("data/00001-100-append-00001.parquet"));
        GenericRecord record = GenericRecord.create((Schema)this.table.schema()).copy((Map)ImmutableMap.of((Object)"data", (Object)"aaa"));
        PartitionKey partitionKey = new PartitionKey(this.table.spec(), this.table.schema());
        partitionKey.partition((StructLike)record);
        EncryptedOutputFile partitionedFile = fileFactory.newOutputFile(this.table.spec(), (StructLike)partitionKey);
        String partitionedFileLocation = partitionedFile.encryptingOutputFile().location();
        Assert.assertTrue((boolean)partitionedFileLocation.endsWith("data_bucket=7/00001-100-append-00002.parquet"));
    }

    @Test
    public void testWithCustomSuffix() {
        OutputFileFactory fileFactory = OutputFileFactory.builderFor((Table)this.table, (int)1, (long)100L).operationId("append").suffix("suffix").build();
        EncryptedOutputFile unpartitionedFile = fileFactory.newOutputFile(PartitionSpec.unpartitioned(), null);
        String unpartitionedFileLocation = unpartitionedFile.encryptingOutputFile().location();
        Assertions.assertThat((String)unpartitionedFileLocation).endsWith((CharSequence)"data/00001-100-append-00001-suffix.parquet");
        GenericRecord record = GenericRecord.create((Schema)this.table.schema()).copy((Map)ImmutableMap.of((Object)"data", (Object)"aaa"));
        PartitionKey partitionKey = new PartitionKey(this.table.spec(), this.table.schema());
        partitionKey.partition((StructLike)record);
        EncryptedOutputFile partitionedFile = fileFactory.newOutputFile(this.table.spec(), (StructLike)partitionKey);
        String partitionedFileLocation = partitionedFile.encryptingOutputFile().location();
        Assertions.assertThat((String)partitionedFileLocation).endsWith((CharSequence)"data_bucket=7/00001-100-append-00002-suffix.parquet");
    }
}

