/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.iceberg.inmemory.InMemoryOutputFile;
import org.apache.iceberg.io.IOUtil;
import org.apache.iceberg.io.MockInputStream;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.relocated.com.google.common.base.Strings;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestIOUtil {
    @Test
    public void testReadFully() throws Exception {
        byte[] buffer = new byte[5];
        MockInputStream stream = new MockInputStream(new int[0]);
        IOUtil.readFully((InputStream)stream, (byte[])buffer, (int)0, (int)buffer.length);
        Assert.assertArrayEquals((String)"Byte array contents should match", (byte[])Arrays.copyOfRange(MockInputStream.TEST_ARRAY, 0, 5), (byte[])buffer);
        Assert.assertEquals((String)"Stream position should reflect bytes read", (long)5L, (long)stream.getPos());
    }

    @Test
    public void testReadFullySmallReads() throws Exception {
        byte[] buffer = new byte[5];
        MockInputStream stream = new MockInputStream(2, 3, 3);
        IOUtil.readFully((InputStream)stream, (byte[])buffer, (int)0, (int)buffer.length);
        Assert.assertArrayEquals((String)"Byte array contents should match", (byte[])Arrays.copyOfRange(MockInputStream.TEST_ARRAY, 0, 5), (byte[])buffer);
        Assert.assertEquals((String)"Stream position should reflect bytes read", (long)5L, (long)stream.getPos());
    }

    @Test
    public void testReadFullyJustRight() throws Exception {
        byte[] buffer = new byte[10];
        MockInputStream stream = new MockInputStream(2, 3, 3);
        IOUtil.readFully((InputStream)stream, (byte[])buffer, (int)0, (int)buffer.length);
        Assert.assertArrayEquals((String)"Byte array contents should match", (byte[])MockInputStream.TEST_ARRAY, (byte[])buffer);
        Assert.assertEquals((String)"Stream position should reflect bytes read", (long)10L, (long)stream.getPos());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IOUtil.readFully((InputStream)stream, (byte[])buffer, (int)0, (int)1)).isInstanceOf(EOFException.class)).hasMessage("Reached the end of stream with 1 bytes left to read");
    }

    @Test
    public void testReadFullyUnderflow() {
        byte[] buffer = new byte[11];
        MockInputStream stream = new MockInputStream(2, 3, 3);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IOUtil.readFully((InputStream)stream, (byte[])buffer, (int)0, (int)buffer.length)).isInstanceOf(EOFException.class)).hasMessage("Reached the end of stream with 1 bytes left to read");
        Assert.assertArrayEquals((String)"Should have consumed bytes", (byte[])MockInputStream.TEST_ARRAY, (byte[])Arrays.copyOfRange(buffer, 0, 10));
        Assert.assertEquals((String)"Stream position should reflect bytes read", (long)10L, (long)stream.getPos());
    }

    @Test
    public void testReadFullyStartAndLength() throws IOException {
        byte[] buffer = new byte[10];
        MockInputStream stream = new MockInputStream(new int[0]);
        IOUtil.readFully((InputStream)stream, (byte[])buffer, (int)2, (int)5);
        Assert.assertArrayEquals((String)"Byte array contents should match", (byte[])Arrays.copyOfRange(MockInputStream.TEST_ARRAY, 0, 5), (byte[])Arrays.copyOfRange(buffer, 2, 7));
        Assert.assertEquals((String)"Stream position should reflect bytes read", (long)5L, (long)stream.getPos());
    }

    @Test
    public void testReadFullyZeroByteRead() throws IOException {
        byte[] buffer = new byte[]{};
        MockInputStream stream = new MockInputStream(new int[0]);
        IOUtil.readFully((InputStream)stream, (byte[])buffer, (int)0, (int)buffer.length);
        Assert.assertEquals((String)"Stream position should reflect bytes read", (long)0L, (long)stream.getPos());
    }

    @Test
    public void testReadFullySmallReadsWithStartAndLength() throws IOException {
        byte[] buffer = new byte[10];
        MockInputStream stream = new MockInputStream(2, 2, 3);
        IOUtil.readFully((InputStream)stream, (byte[])buffer, (int)2, (int)5);
        Assert.assertArrayEquals((String)"Byte array contents should match", (byte[])Arrays.copyOfRange(MockInputStream.TEST_ARRAY, 0, 5), (byte[])Arrays.copyOfRange(buffer, 2, 7));
        Assert.assertEquals((String)"Stream position should reflect bytes read", (long)5L, (long)stream.getPos());
    }

    @Test
    public void testWriteFully() throws Exception {
        byte[] input = Strings.repeat((String)"Welcome to Warsaw!\n", (int)12345).getBytes(StandardCharsets.UTF_8);
        InMemoryOutputFile outputFile = new InMemoryOutputFile();
        try (PositionOutputStream outputStream = outputFile.create();){
            IOUtil.writeFully((OutputStream)outputStream, (ByteBuffer)ByteBuffer.wrap((byte[])input.clone()));
        }
        Assertions.assertThat((byte[])outputFile.toByteArray()).isEqualTo((Object)input);
    }
}

